;(function ($) {
	'use strict';
	
	var ExpandableContent = window.ExpandableContent || {};
	
	ExpandableContent = (function () {
		
		function ExpandableContent(element, options) {
			
			var $self = this;
			
			/**
			 * Current element.
			 *
			 * @public
			 */
			this.$element = $(element);
			
			/**
			 * Current options set by the caller including defaults.
			 *
			 * @public
			 */
			$self.options = $.extend(true, {}, ExpandableContent.defaults, options);
			
			this.initialize();
			
		}
		
		return ExpandableContent;
		
	}());
	
	ExpandableContent.defaults = {
		containerSelector: null,
		gridSelector: null,
		listSelector: null,
		listItemSelector: null,
		noItemsTextSelector: null,
		toggleSelector: null,
		toggleTextSelector: null,
		footerSelector: null,
		sidebarSelector: null,
		listQty: {
			xs: 4,
			lg: 4
		},
		maxItems: null,
		toggleActiveClass: null,
		windowWidth: window.innerWidth,
		listIsOpened: false
	};
	
	/**
	 * Initialization of the plugin.
	 *
	 * @protected
	 */
	ExpandableContent.prototype.initialize = function () {
		// vars
		var $self = this;
		
		$self.options.toggleActiveClass = 'active';
		$self.options.sidebarSelector = '[data-sidebar]';
		
		$self.options.containerSelector = '#' + $self.$element[0].id;
		
		$self.options.listSelector = $self.options.containerSelector + ' [data-list-wrap]';
		$self.options.gridSelector = $self.options.containerSelector + ' [data-list]';
		$self.options.listItemSelector = $self.options.gridSelector + ' [data-list-item]';
		
		$self.options.noItemsTextSelector = $self.options.containerSelector + ' [data-no-items-text]';
		
		$self.options.toggleSelector = $self.options.containerSelector + ' [data-toggle]';
		$self.options.toggleTextSelector = $self.options.containerSelector + ' [data-toggle-text]';
		
		$self.options.footerSelector = $self.options.containerSelector + ' [data-footer]';
		
		
		// vars
		var windowWidth = window.innerWidth,
			list = document.querySelector($self.options.listSelector),
			cols = function () {
				if (windowWidth <= 992) {
					return $self.options.listQty.xs;
				} else {
					return $self.options.listQty.lg;
				}
			},
			newactualitiesToggle = $self.actualitiesToggle();
		
		if (!$($self.options.listItemSelector).length) {
			
			$($self.options.noItemsTextSelector).show();
			
		}
		
		if ($($self.options.listItemSelector).length < cols()) {
			
			$($self.options.footerSelector).hide();
			
		}
		
		list.style.maxHeight = $($self.options.listItemSelector).length ? $self.setMinHeight($self.options.listItemSelector, $($self.options.listItemSelector).length < cols() ? $($self.options.listItemSelector).length : cols()) + 'px' : 0;
		
		$($self.options.toggleSelector).on('click', function () {
			var $this = $(this),
				defaultText = $this.data('default-text'),
				activeText = $this.data('active-text');
			
			$this.toggleClass($self.options.toggleActiveClass);
			
			if ($this.hasClass($self.options.toggleActiveClass)) {
				$($self.options.toggleTextSelector).text(activeText);
			} else {
				$($self.options.toggleTextSelector).text(defaultText);
			}
			
			list.style.maxHeight = newactualitiesToggle();
		});
		
		$($self.options.sidebarSelector).on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd', function () {
			list.style.maxHeight = $($self.options.listItemSelector).length ? $self.setMinHeight($self.options.listItemSelector, $($self.options.listItemSelector).length < cols() ? $($self.options.listItemSelector).length : cols()) + 'px' : 0;
		});
		
		if ($self.options.maxItems && $($self.options.footerSelector).length) {
            if ($($self.options.listItemSelector).length > $self.options.maxItems) {
                $($self.options.footerSelector).show();
            }
        }
		
		return this;
		
	};
	
	ExpandableContent.prototype.setMinHeight = function (singleItem, qty) {
		var $items = document.querySelectorAll(singleItem),
			min = 0,
			countElements = 0;
		
		while (countElements < qty) {
			min += $items[countElements].offsetHeight;
			
			countElements++;
		}
		
		return min;
	};
	
	ExpandableContent.prototype.setMaxHeight = function (target) {
		var $target = document.querySelector(target);
		
		return $target.offsetHeight;
	};
	
	ExpandableContent.prototype.actualitiesToggle = function () {
		var $self = this;
		
		return function () {
			var windowWidth = window.innerWidth,
				cols = function () {
					if (windowWidth <= 992) {
						return $self.options.listQty.xs;
					} else {
						return $self.options.listQty.lg;
					}
				};
			
			if (!$self.options.listIsOpened) {
				$self.options.listIsOpened = true;
				
				return $self.setMaxHeight($self.options.gridSelector) + 'px';
			} else {
				$self.options.listIsOpened = false;
				
				return $self.setMinHeight($self.options.listItemSelector, cols()) + 'px';
			}
		};
	};
	
	ExpandableContent.prototype.update = function (func) {
		var $self = this,
			cols = function () {
				if ($self.options.windowWidth <= 992) {
					return $self.options.listQty.xs;
				} else {
					return $self.options.listQty.lg;
				}
			};
		
		if ($self.options.windowWidth !== window.innerWidth) {
			$self.options.windowWidth = window.innerWidth;
			
			if ($self.options.listIsOpened) {
				document.querySelector($self.options.listSelector).style.maxHeight = $self.setMaxHeight($self.options.gridSelector) + 'px';
			} else {
				document.querySelector($self.options.listSelector).style.maxHeight = $self.setMinHeight($self.options.listItemSelector, cols()) + 'px';
			}
		}
		
		if (func) {
			return func;
		}
	};
	
	$.fn.HSExpandableContent = function () {
		var _ = this,
			opt = arguments[0],
			args = Array.prototype.slice.call(arguments, 1),
			l = _.length,
			i,
			ret;
		for (i = 0; i < l; i++) {
			if (typeof opt == 'object' || typeof opt == 'undefined') {
				_[i].ExpandableContent = new ExpandableContent(_[i], opt);
			} else {
				ret = _[i].ExpandableContent[opt].apply(_[i].ExpandableContent, args);
		}
		
			if (typeof ret != 'undefined') return ret;
		}
		
		return _;
	};
	
})(jQuery);