<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:exsl="http://exslt.org/common"
    xmlns:text="http://ametys.org/text/3.0"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:math="java.lang.Math"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    extension-element-prefixes="exsl text resolver math ametys event escaper">

    <xsl:import href="plugin:calendar://pages/services/agenda/agenda_1.3.xsl" />
    
    <xsl:variable name="nbResultsMax">
    	<xsl:choose>
    		<xsl:when test="ametys:serviceViewParameter('nbResultsMax') != ''">
    			<xsl:value-of select="ametys:serviceViewParameter('nbResultsMax')"/>
    		</xsl:when>
    		<xsl:otherwise>3 <!-- Default value --></xsl:otherwise>
    	</xsl:choose>
	</xsl:variable>

    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-agenda/scss/main.css')}" />
    </xsl:template>

    <xsl:variable name="common-service-css-class-name"> ametys-cms-zone-timeline </xsl:variable>

    <xsl:template name="common-service-body-nonempty-content-title" />

    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-calendar card mb-4 {$override-card-styles}">
            <xsl:call-template name="header" />

            <xsl:call-template name="all-events-when-no-js" />
        </div>
    </xsl:template>

    <xsl:template name="header">
        <header class="card-header card-header--space-between">
            <h2 class="card-title mb-0">
                <xsl:call-template name="card-header-icon"/>
                <xsl:value-of select="@title" />
            </h2>
            <xsl:call-template name="link" />
        </header>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
    	<span class="card-header__icon material-icons access_time"></span>
    </xsl:template>

    <xsl:template name="all-events-when-no-js">
        
        <xsl:if test="/events/contents/event">
            <div class="card-body ametys-cms-service search agenda pt-0">
                <xsl:for-each select="/events/contents/event">
                    <xsl:sort select="content/metadata/start-date" order="ascending"/>
                    
	                <xsl:if test="position() &lt;= $nbResultsMax">
	                    <xsl:variable name="page-id" select="view/content/html/head/meta[@name = 'pages/page;id']/@content" />
	                    
		                <a class="news view-abstract agenda__item agenda__item">
		                  <xsl:if test="$page-id"><xsl:attribute name="href"><xsl:value-of select="resolver:resolve('page', $page-id, false)"/></xsl:attribute></xsl:if>
	                      
	                      <xsl:call-template name="event-date"/>
	                      <xsl:call-template name="event-info"/>
		                </a>
		            </xsl:if>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="event-date">
    	<div class="agenda__item__date">
            <xsl:call-template name="event-date-format"/>
        </div>
    </xsl:template>
    
    <xsl:template name="event-date-format">
         <span class="agenda__item__date__nb">
             <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="d">
                 <xsl:value-of select="content/metadata/start-date"/>
             </i18n:date>
         </span>
         <span class="agenda__item__date__month">
             <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="MMM">
                 <xsl:value-of select="content/metadata/start-date" />
             </i18n:date>
         </span>
    </xsl:template>
    
    <xsl:template name="event-info">
        <div class="agenda__item__info">
            <div>
            	<xsl:call-template name="event-info-title"/>
            	<xsl:call-template name="event-info-content"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="event-info-title">
        <h2 class="agenda__item__info__title">
            <xsl:value-of select="content/metadata/title" />
        </h2>
    </xsl:template>
                
    <xsl:template name="event-info-content">
        <p class="agenda__item__info__text">
            <xsl:value-of select="content/metadata/content" />
        </p>
    </xsl:template>

    <xsl:template name="link">
        <xsl:if test="starts-with($link, 'page://')">
            <div class="link">
                <a href="{resolver:resolve('page', $link)}" class="card-link">
                    <xsl:choose>
                        <xsl:when test="$linkTitle != ''">
                            <xsl:value-of select="$linkTitle" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="ametys:pageTitle($link)" />
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </div>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>       