<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="is-empty" select="count(/subscriptions/subscription) = 0"/>    
    
    <!-- Refresh delay for unread pages -->
    <xsl:variable name="pageFollowRefreshDelay" select="ametys:siteParameter('page-follow-refresh-delay') * 60000"/><!-- refresh delay in min -->
    
    <xsl:variable name="dataSettings">{
                         "appsListQty": {
                            "xs": 6,
                            "md": 6
                          }
                 }</xsl:variable><!-- define number of rows displayed on load -->
                 
    <xsl:variable name="common-service-css-class-name">zone-abo</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/animate.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/plugins/custombox/custombox.min.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}" />
        
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/scss/print.css')}"/>
        
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools-abo/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools-abo/scss/print.css')}"/>
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <script src="{ametys:skinURL('zones/index-tools/plugins/web-animations-js/web-animations.min.js')}"></script>
        <script src="{ametys:skinURL('zones/index-tools/plugins/hammerjs/hammer.min.js')}"></script>
        <script src="{ametys:skinURL('zones/index-tools/plugins/muuri/dist/muuri.min.js')}"></script>
        <script src="{ametys:skinURL('zones/index-tools/plugins/custombox/custombox.min.js')}"></script>
        
        <script src="{ametys:skinURL('zones/index-tools/plugins/perfect-scrollbar/dist/perfect-scrollbar.min.js')}"></script>
        <script src="{ametys:skinURL('zones/index-tools/js/ametys-tools.js')}"></script>
        
        <!-- Tooltip -->
        <script src="{ametys:skinURL('templates/common/plugins/popper.js/v2.11.8/dist/umd/popper.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/tippy.js/dist/tippy-bundle.umd.js')}"></script>
        
        <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.', ametys:lang(), '.js')}"/>   
        
        <script type="text/javascript">
            $j(function(){
              var $tool = $j('#tool-<xsl:value-of select="$uniqueId"/>');
              $tool.HSAmetysTools($j('#tool-<xsl:value-of select="$uniqueId"/>').data('settings'));
              $tool.on('elementDeleted', unsubscribe_<xsl:value-of select="$uniqueId"/>);
              
              AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-<xsl:value-of select="$uniqueId"/>', updateTooltip_<xsl:value-of select="$uniqueId"/>);
              
              setInterval(function() {
                AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-<xsl:value-of select="$uniqueId"/>');
              }, <xsl:value-of select="$pageFollowRefreshDelay"/>, updateTooltip_<xsl:value-of select="$uniqueId"/>);
             
            });
            
            // Tippy plugin to hide tooltip on ESC
            const hideTooltipOnEsc_<xsl:value-of select="$uniqueId"/> = {
              name: 'hideOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
            function updateTooltip_<xsl:value-of select="$uniqueId"/>(unreadPages)
            {
                $j.each(unreadPages, function(i, unreadPage) {
                
                    // Destroy tooltips
                    $j('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + ']').each(function(i, el) {
                        if ($j(el).get(0)._tippy)
                        {
                            $j(el).get(0)._tippy.destroy();
                        }
                    })
                    
                    $j.each(unreadPages, function(i, unreadPage) {
                        let $el = $j('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + '="' + unreadPage.pageId + '"]');
                        
                        // Create tooltip
                        tippy('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + '="' + unreadPage.pageId + '"]', {
                            allowHTML: true,
                            content: $el.html(),
                            placement: 'bottom-end',
                            plugins: [hideTooltipOnEsc_<xsl:value-of select="$uniqueId"/>]
                        });
                        
                        $el.attr("tabindex", 0); // to show tooltip on focus
                    });
                });
            }
            function unsubscribe_<xsl:value-of select="$uniqueId"/>(event, target)
            {
                let subscriptionId = $j(target).attr("data-ametys-subscription-id");
                AmetysFront.UserPageSubscriptions.unsubscribe('<xsl:value-of select="$uniqueId"/>', subscriptionId, null, true /* skipConfirm */)
            };
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="tool-{$uniqueId}" data-settings="{normalize-space($dataSettings)}">
			<xsl:if test="$template ='index'"><xsl:attribute name="class">ametys-tools card rounded mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute></xsl:if>
			
            <xsl:call-template name="header"/>
			
            <div class="card-body pt-0 pb-4 px-0">
				<div class="ametys-tools-list-wrap ametys-tools-list--block ametys-animated-heigth ametys-abonnements-tools-list" data-list-wrap="" id="selected-links-{$uniqueId}" data-ametys-subscriptions="{$uniqueId}">
                    <p class="ametys-tools-no-items-text" data-no-items-text="" data-ametys-subscription-page-role="no-result">
                        <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_NOSUBSCRIPTION" i18n:catalogue="skin.{$skin}"/>
                    </p>
                
					<ul class="ametys-tools-list ametys-tools-list_editable" data-list="" data-ametys-subscription-page-role="results">
						 <xsl:apply-templates select="/subscriptions/subscription"/>
					</ul>
                    
                    <p class="sr-only" role="status" data-ametys-subscription-page-role="status"></p>
				</div>
			</div>
			
			<xsl:call-template name="footer"/>
            
            <!-- Modal -->
            <xsl:call-template name="unsubscribe-modal">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:call-template>
            
		</div>
    </xsl:template>
    
    <xsl:template name="header">
        <header class="card-header pb-0">
            <h2 class="card-title">
                <xsl:call-template name="card-header-icon"/>
                <xsl:choose>
                    <xsl:when test="$header != ''">
                        <xsl:value-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="header-default-title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h2>
            
            <xsl:call-template name="configure-button"/>
        </header>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <svg aria-hidden="true" class="card-header__icon" width="32px" height="32px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Ametys-Intranet" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Intranet-Cards---Profil" transform="translate(-1307, -680)">
                    <g id="Pages-Suivies" transform="translate(1277, 665)">
                        <g id="icon-follow" transform="translate(30, 15.3143)">
                            <path
                                d="M21.3365079,1 C22.4410774,1 23.4410774,1.44771525 24.1649351,2.17157288 C24.7853845,2.79202227 25.2029537,3.61535177 25.309597,4.5335155 L25.322,4.685 L7.236,4.685 L7.24913315,4.5335155 C7.34688948,3.69186542 7.70591003,2.92990242 8.24297194,2.33084937 L8.3937951,2.17157288 C9.11765272,1.44771525 10.1176527,1 11.2222222,1 Z"
                                id="Rectangle" stroke="#795198" stroke-width="2"></path>
                            <path
                                d="M24.1555556,5.44444444 C25.2601251,5.44444444 26.2601251,5.89215969 26.9839827,6.61601732 C27.7078403,7.33987494 28.1555556,8.33987494 28.1555556,9.44444444 L28.1555556,9.95284228 L4.55555556,9.95284228 L4.55555556,9.44444444 C4.55555556,8.33987494 5.00327081,7.33987494 5.72712843,6.61601732 C6.45098606,5.89215969 7.45098606,5.44444444 8.55555556,5.44444444 Z"
                                id="Rectangle" stroke="#795198" stroke-width="2"></path>
                            <rect id="Rectangle" stroke="#795198" stroke-width="2" x="1" y="9.88888889" width="30" height="19.9428571" rx="5"></rect>
                            <rect id="Rectangle" stroke="#795198" stroke-width="2" x="9.88888889" y="13.4444444" width="12.6285714" height="12.6285714" rx="6.31428571"></rect>
                            <g id="plus-icon" transform="translate(12.7111, 16)" fill="#795198">
                                <rect id="Rectangle" x="2.88888889" y="0" width="1.33333333" height="7.11111111" rx="0.666666667"></rect>
                                <path
                                    d="M3.55555556,1.28341782e-13 C3.92374539,1.28230759e-13 4.22222222,0.298476833 4.22222222,0.666666667 L4.22222222,6.44444444 C4.22222222,6.81263428 3.92374539,7.11111111 3.55555556,7.11111111 C3.18736572,7.11111111 2.88888889,6.81263428 2.88888889,6.44444444 L2.88888889,0.666666667 C2.88888889,0.298476833 3.18736572,1.28341782e-13 3.55555556,1.28341782e-13 Z"
                                    id="Rectangle" transform="translate(3.5556, 3.5556) rotate(90) translate(-3.5556, -3.5556)"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="header-default-title">
        <i18n:text i18n:key="SKIN_MY_PAGES" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="configure-button">
        <label class="ametys-toggle">
            <input class="ametys-toggle__check ametys-edit-mode-checker" type="checkbox" data-edit-mode-toggle="" />
            
            <span class="ametys-toggle__control">
                <span class="ametys-toggle__control-dot">
                    <span class="ametys-toggle__control-dot-icon"></span>
                </span>
            </span>
        </label>
    </xsl:template>
    
    <xsl:template name="footer">
        <footer class="card-footer text-center" data-footer="">
            <span class="ametys-show-more" data-toggle="" data-default-text="skin.{$skin}:SKIN_DISPLAY_MORE" data-active-text="skin.{$skin}:SKIN_DISPLAY_LESS"  i18n:attr="data-default-text data-active-text" style="display: none;">
                <span class="ametys-show-more__text" data-toggle-text=""><i18n:text i18n:key="SKIN_DISPLAY_MORE" i18n:catalogue="skin.{$skin}"/></span>
                <span class="ametys-show-more__icon material-icons expand_more"></span>
            </span>
        </footer>
    </xsl:template> 
    
    <xsl:template match="subscription">
        <li class="ametys-tools-list__item ametys-tools-list__abo" data-list-item="" data-app-type="custom" data-ametys-subscription-id="{@id}">
            <a class="ametys-tools-list__link"
               href="{resolver:resolve('page', page/@id, false)}"
               data-list-link="">
                                  
              <div class="ametys-abonnements">
                   <xsl:apply-templates select="." mode="breadcrumb"/>     
                   <xsl:apply-templates select="." mode="title"/>  
                   <xsl:apply-templates select="." mode="notification"/>    
              </div>
           </a>
                                  
           <button type="button" arial-label="skin.{$skin}:SERVICE_PAGE_SUBSCRIPTION_UNSUBSCRIBE" i18n:attr="aria-label" class="ametys-tools-list__action"></button>
        </li>
    </xsl:template>
    
    <xsl:template match="subscription" mode="breadcrumb">
        <p class="ametys-abonnements__breadcrumb">
            <xsl:if test="ametys:pageExists($site, $lang, 'index')">
                <xsl:value-of select="ametys:pageTitle($site, $lang, 'index')"/>
                <xsl:text> / </xsl:text>
            </xsl:if>
            <xsl:for-each select="ametys:breadcrumb(page/@id)">
                <xsl:value-of select="ametys:pageTitle(.)"/>
                <xsl:text> / </xsl:text>
            </xsl:for-each>
            <xsl:value-of select="page"/>
          </p>
    </xsl:template>
    
    <xsl:template match="subscription" mode="title">
        <h3 class="ametys-abonnements__title">
          <xsl:value-of select="page"/> 
        </h3>
    </xsl:template>
    
    <xsl:template match="subscription" mode="notification">
        <div class="ametys-abonnement__circle" data-ametys-page-notification-id="{page/@id}" style="display: none">
            <div class="ametys-abonnement__last-edit">
                <span class="ametys-abonnement__last-edit__date" data-ametys-page-notification-role="date"></span>
                <div class="ametys-abonnement__last-edit__user">
                    <img alt="" data-ametys-page-notification-role="author-img"/>
                    <div class="ametys-abonnement__last-edit__user__info">
                        <span class="ametys-abonnement__last-edit__user__info__name" data-ametys-page-notification-role="author-name"></span>
                        <span class="ametys-abonnement__last-edit__user__info__action">
                            <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_PAGE_MODIFIED" i18n:catalogue="skin.{$skin}"/>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="unsubscribe-modal">
        <!-- Delete confirm -->
        <div id="data-delete-modal-{$uniqueId}" class="text-left g-max-width-600 g-bg-white g-overflow-y-auto g-pa-20" style="display: none;" data-delete-modal="" role="dialog" aria-modal="true" aria-labelledby="data-delete-modal-{$uniqueId}-title">
            <h4 class="g-mb-20" id="data-delete-modal-{$uniqueId}-title"><i18n:text i18n:key="PAGE_SUBSCRIPTION_HELPER_UNSUBSCRIBE_CONFIRM_MSG" i18n:catalogue="plugin.page-subscription"/></h4>
            
            <div class="text-center">
                <span class="btn btn-md btn-danger g-mx-5" data-delete-modal-confirm=""><i18n:text i18n:key="SKIN_LINKDIRECTORY_YES" i18n:catalogue="skin.{$skin}"/></span>
                <span class="btn btn-md u-btn-outline-bluegray g-mx-5" data-delete-modal-close=""><i18n:text i18n:key="SKIN_LINKDIRECTORY_NO" i18n:catalogue="skin.{$skin}"/></span>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
