<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        extension-element-prefixes="resolver">
	
	<xsl:import href="plugin:syndication://pages/services/feed/feed2xhtml_1.2.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-subscriptions/scss/main.css')}" media="screen, print, handheld"/>   
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-subscriptions/scss/print.css')}" media="print"/>
                
        <xsl:if test="ametys:renderingContext() = 'back'">
            <link href="{ametys:pluginResourceURL('syndication', 'css/bo-error.css')}" rel="stylesheet" type="text/css" />
        </xsl:if>    
    </xsl:template>     
    
    <xsl:template name="common-service-body-nonempty-content-title"/> 
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div>
            <xsl:call-template name="class-attribute"/>
            
	        <xsl:call-template name="card-header"/>

        	<!-- Handle my RSS feed form -->
            <xsl:call-template name="feed-config-form" />
            
			<div>
                <xsl:call-template name="body-class-attribute"/>
                
	           <!-- Errors on customs feed -->
	            <xsl:if test="/rssFeeds/feed-error-custom">
	                <div class="error">
	                    <ul>
	                        <xsl:for-each select="/rssFeeds/feed-error-custom">
	                           <xsl:call-template name="feed-error-custom" />
	                        </xsl:for-each>
	                    </ul>
	                </div>
	            </xsl:if>
	            
	            <!-- Errors on feed (BO mode only) -->
	            <xsl:if test="/rssFeeds/feed-error">
	                <div>
	                    <xsl:for-each select="/rssFeeds/feed-error">
	                       <xsl:call-template name="feed-error" />
	                    </xsl:for-each>        
	                </div>
	            </xsl:if>
	            
	            <!-- RSS entries -->
	            <xsl:if test="/rssFeeds/feed/entry">
	                <ul>
                        <xsl:call-template name="list-class-attribute"/>
                        
	    		        <xsl:for-each select="/rssFeeds/feed/entry">
	    		            <xsl:sort select="@date" order="descending"/>
	    			        <xsl:apply-templates select="."/>
	    		        </xsl:for-each>
	    	        </ul>
	            </xsl:if>
	        </div>
            
	        <xsl:call-template name="link-bottom"/>
	        
            <xsl:call-template name="card-footer"/>
            
			<xsl:call-template name="feed-form-script"/>
	    </div>
    </xsl:template>   
    
    <xsl:template name="class-attribute">
        <xsl:if test="ametys:template() = 'index'">
            <xsl:attribute name="class">card rounded mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="body-class-attribute">
        <xsl:attribute name="class">card-body p-0</xsl:attribute>
    </xsl:template>  
    
    <xsl:template name="list-class-attribute">
        <xsl:attribute name="class">ametys-subscriptions</xsl:attribute>
    </xsl:template>                   
    
    <xsl:template name="card-header">
        <header class="card-header">
            <h2 class="card-title">
                <xsl:call-template name="card-header-icon"/>
                
                <xsl:choose>
                    <xsl:when test="$header != ''">
                        <xsl:value-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="card-header-default-title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h2>
        </header>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons rss_feed"></span>
    </xsl:template>
    
    <xsl:template name="card-footer">
        <footer class="card-footer d-flex justify-content-end bg-transparent">
            <!-- Link to edit user RSS feed preferences -->
            <xsl:call-template name="feed-config-link"/>
        </footer>
    </xsl:template>
    
    <xsl:template name="card-header-default-title">
        <i18n:text i18n:key="SKIN_SYNDICATION" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="entry" mode="class-attribute">
        <xsl:attribute name="class">ametys-subscriptions__item</xsl:attribute>
    </xsl:template> 
    
    <xsl:template match="entry" mode="link-attribute">
        <xsl:attribute name="class">ametys-subscriptions__link</xsl:attribute>
    </xsl:template> 

	<xsl:template match="entry"> 
		<li>
			<xsl:apply-templates select="." mode="class-attribute"/>
            
			<a href="{@link}" target="_blank">
                <xsl:apply-templates select="." mode="link-attribute"/>
                
				<xsl:apply-templates select="." mode="body"/>
			</a>
		</li>
	</xsl:template>
    
    <xsl:template match="entry" mode="body">
        <article>
            <xsl:apply-templates select="." mode="category"/>   
            <xsl:apply-templates select="." mode="title"/>  
            <xsl:apply-templates select="." mode="date"/>  
        </article>
    </xsl:template>   
    
    <xsl:template match="entry" mode="category">   
        <span class="ametys-subscriptions__cat"><xsl:value-of select="../@title"/></span>
    </xsl:template>
    
	 <xsl:template match="entry" mode="title">   
        <p class="ametys-subscriptions__text"><xsl:value-of select="@title"/></p>
    </xsl:template>
    
	<xsl:template match="entry" mode="date">   
        <xsl:if test="@date">
            <div class="ametys-date">
                <span class="ametys-date__icon material-icons access_time"></span>
                
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm" pattern="medium"><xsl:value-of select="@date"/></i18n:date>
                <xsl:text> </xsl:text>
                <i18n:time src-pattern="yyyy-MM-dd'T'HH:mm" pattern="short"><xsl:value-of select="@date"/></i18n:time>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- Template used to display link "all contents" on the top -->
    <xsl:template name="link-top">
        <xsl:comment>empty</xsl:comment>
    </xsl:template>

    <!-- Template used to display link "all contents" on the bottom -->
    <xsl:template name="link-bottom">
    	<xsl:call-template name="link"/>
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="starts-with($link, 'page://')">
            <div class="link">
                <a class="ametys-subscriptions__link" href="{resolver:resolve('page', $link)}">
                    <xsl:choose>
                        <xsl:when test="normalize-space($link-title) != ''">
                            <xsl:value-of select="$link-title"/>
                        </xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="PLUGINS_WEB_SERVICE_FILTERED_CONTENTS_LINK_TITLE_DEFAULT" i18n:catalogue="plugin.web"/></xsl:otherwise>
                    </xsl:choose>
                </a>
            </div>
        </xsl:if>    
    </xsl:template>
    
    
    <xsl:template name="feed-config-link">
    	<xsl:if test="/rssFeeds/@showForm = 'true'">
            <div class="feed-config-link" id="feed-config-header-{$uniqueId}"><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG" i18n:catalogue="plugin.syndication"/></div>
		    <script type="text/javascript">
		        $j("#feed-config-header-<xsl:value-of select="$uniqueId"/>").wrapInner("&lt;a class='btn btn-primary btn-sm btn-info' href='javascript: feed_config_form_popup_<xsl:value-of select="$uniqueId"/>()'&gt;&lt;/a&gt;")
		    </script>
	   </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>		
