<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        extension-element-prefixes="resolver ametys filenameutils">
    
    <xsl:import href="service:web://pages/services/explorer-folder/common/files_3.3.xsl"/>

    <xsl:variable name="common-service-css-class-name">attachments small-icons</xsl:variable>
    
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-notes/scss/main.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="card mb-4">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
        
            <xsl:call-template name="common-service-body-nonempty-content-content"/>
        </div>
    </xsl:template>   

    <xsl:template name="common-service-body-nonempty-content-title">
        <header class="card-header justify-content-between pb-0 align-items-center">
            <h1 class="card-title mb-0">
                <xsl:call-template name="card-header-icon"/>
                <xsl:value-of select="$header"/>
            </h1>
        </header>
   </xsl:template>
   
   <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons">insert_drive_file</span>
   </xsl:template>

    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="card-body pt-0 pb-4 px-0">
           <ul class="ametys-notes">
              <xsl:apply-templates select="Node[@type = 'collection']"/>
            
              <xsl:apply-templates select="Node[@type = 'resource']"/>
           </ul>
       </div>
    </xsl:template>

    <xsl:template match="Node[@type = 'collection' and parent::*]">
        <xsl:param name="parentFolder">root-<xsl:value-of select="generate-id()"/></xsl:param>
        
        <!-- Ignore empty folder -->
        <xsl:if test=".//Node[@type = 'resource']">
            <li class="ametys-notes__item" id="telechargerMenu-{$parentFolder}">
                <div class="ametys-notes__item_btn">
                    <button id="telechargerMenuInvoker-{$parentFolder}"
                            class="ametys-notes__item_link_text collapsed" 
                            aria-expanded="false" 
                            aria-controls="telechargerMenu-{generate-id()}" 
                            data-toggle="collapse" 
                            data-target="#telechargerMenu-{generate-id()}">
                        <xsl:call-template name="FolderIcon"/>
                        <xsl:value-of select="@name"/>
                    </button>
                </div>
                   
                <ul id="telechargerMenu-{generate-id()}" class="ametys-notes collapse" aria-labelledby="telechargerMenuInvoker-{generate-id()}" data-parent="#telechargerMenu-{$parentFolder}">
                    <xsl:apply-templates select="Node[@type = 'collection']">
                        <xsl:with-param name="parentFolder" select="generate-id()"/>
                    </xsl:apply-templates>
                      
                    <xsl:apply-templates select="Node[@type = 'resource']"/>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']">
        <li class="ametys-notes__item">
           <a href="{resolver:resolve('explorer', @id, true())}" title="Télécharger {@name}" class="ametys-notes__item_link">
               <xsl:apply-templates select="." mode="file-title-attr"/>
               <i class="material-icons" aria-hidden="true">chevron_right</i>
               <span class="ametys-notes__item_link_text">
                   <xsl:value-of select="@name"/>
                   <em><xsl:call-template name="format-size"><xsl:with-param name="size" select="@size"/></xsl:call-template></em>
               </span>
           </a>
         </li>    
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']" mode="file-title-attr">
        <xsl:variable name="i18nparams">
            <filename><xsl:value-of select="@name"/></filename>
        </xsl:variable> 
        
        <xsl:attribute name="title">
            <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':DOWNLOAD_FILE_TOOLTIP'), $lang, $i18nparams)"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template name="FolderIcon">
        <span class="folder">
            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h240l80 80h320q33 0 56.5 23.5T880-640v400q0 33-23.5 56.5T800-160H160Zm0-80h640v-400H447l-80-80H160v480Zm0 0v-480 480Z"/></svg>
        </span>
        <span class="opened-folder">
            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h240l80 80h320q33 0 56.5 23.5T880-640H447l-80-80H160v480l96-320h684L837-217q-8 26-29.5 41.5T760-160H160Zm84-80h516l72-240H316l-72 240Zm0 0 72-240-72 240Zm-84-400v-80 80Z"/></svg>
        </span>
    </xsl:template>
    
    <xsl:template name="Icons"/>
    
</xsl:stylesheet>