<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
                
   <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
   
   <!-- Prefix for "Full text" criteria -->
   <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
   <!-- Prefix for  "Title or full text" criteria -->
   <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
   <xsl:template name="common-service-body-nonempty">
        <div>
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
      
            <xsl:call-template name="common-service-body-nonempty-content-content"/>
        </div>
    </xsl:template>
    
   <xsl:template name="common-service-body-nonempty-content-title"/>
   
   <xsl:template name="common-service-body-nonempty-content-content">
        <div class="card card-info mb-4 {$override-card-styles}">
            <xsl:call-template name="header"/>
            
            <xsl:call-template name="form-criteria"/>
        </div>
    </xsl:template>
    
    <xsl:template name="header">
        <xsl:if test="$header != ''">
            <header class="card-header">
                <h1 class="card-title mb-0 g-text-transform-none">
                    <xsl:call-template name="card-header-icon"/>
                    <xsl:value-of select="$header" />
                </h1>
            </header>       
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon icofont-users-alt-1"></span>
    </xsl:template>
    
    <xsl:template name="form-search">
        <div class="card-body py-0">
            <xsl:for-each select="/search/form/fields/criterion">
                <xsl:apply-templates select="." mode="field">
                    <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
                </xsl:apply-templates>
            </xsl:for-each>
            
            <footer class="card-footer bg-transparent">
                <div class="row justify-content-start">
                    <xsl:call-template name="link-tag"/>
                        
                     <div class="col-md-auto px-1 my-1">
                        <xsl:call-template name="common-utils-input-submit">
                            <xsl:with-param name="class-name">btn btn-info btn-sm</xsl:with-param>
                            <xsl:with-param name="i18nkey" select="'plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_OK'" />
                            <xsl:with-param name="onclick">
                                <xsl:call-template name="search-js-submit-button"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </div>
                </div>
            </footer>
        </div>
    </xsl:template>    
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div>
            <xsl:attribute name="class">
                <xsl:choose>
                    <xsl:when test="enumeration">form-group form-select</xsl:when>
                    <xsl:otherwise>form-group</xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>      
    
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}"  class="form-control ametys-search__input">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <select id="{$id}" name="{@name}" class="form-control ametys-search__dropdown">
            <xsl:apply-templates select="." mode="criterion-enumeration-select"/>
            
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="criterion-enumeration-all-option"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-options">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </select>
        <i class="fas fa-angle-down" aria-hidden="true"></i>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_VIEW_FULLTEXT_LABEL</xsl:attribute>
        <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input-placeholder">
        <option value="" selected="" disabled="" hidden=""><xsl:value-of select="label"/></option>
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <div class="col-md-auto px-1 my-1">
                <a  class="btn btn-outline-info">
                    <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                    <xsl:call-template name="link-attribute"/>
                    <xsl:call-template name="link-title"/>
                </a>
            </div>              
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
    