<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							  xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <!-- +
         |  Notes: View to use with the view "search-notes.xsl" of search service 
         + -->
         
    <xsl:import href="plugin:multimedia://stylesheets/content/document/document-link.xsl"/>		
	<xsl:import href="skin://stylesheets/content/document/document.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">document view-link</xsl:variable>
    
    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
		<xsl:if test="metadata/file/@path">
			<a class="ametys-notes__item_link" title="{metadata/file/@filename}">
                <xsl:call-template name="document-href-attribute"/>
				<xsl:call-template name="document-icon"/>
			        
				<span class="ametys-notes__item_link_text">
					<xsl:value-of select="metadata/title"/>
					<xsl:call-template name="document-extension"/>
		   		</span>
	         </a>
	     </xsl:if>
    </xsl:template>
    
    <xsl:template name="document-href-attribute">
        <xsl:attribute name="href"><xsl:value-of select="resolver:resolve(metadata/file/@type, metadata/file/@path, 'true')"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="document-icon">
        <i class="material-icons">chevron_right</i>
    </xsl:template>
    
    <xsl:template name="document-extension">
        <em><xsl:value-of select="substring-after(metadata/file/@filename, '.')"/></em>
    </xsl:template>
    
</xsl:stylesheet>