<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:exsl="http://exslt.org/common"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="exsl str">

    <!-- cst = dpi/2.54 -->
    <!-- mm * cst = px -->
    <xsl:variable name="TheConstantMilli">2.834</xsl:variable>
    
    <xsl:template name="deserialize">
        <xsl:param name="css"/>
        <xsl:for-each select="str:tokenize($css, ';&#x9;&#xA;&#xD;')">
            <xsl:variable name="value" select="normalize-space(substring-after(., ':'))"/>
            <xsl:element name="{normalize-space(substring-before(., ':'))}">
                <xsl:if test="substring($value, string-length($value) - 1) = 'px'">
                    <xsl:attribute name="mm">
                        <xsl:call-template name="px-to-mm">
                            <xsl:with-param name="px" select="substring-before($value, 'px')"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:if>
                <xsl:value-of select="$value"/>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="px-to-mm">
        <xsl:param name="px"/>
        <xsl:value-of select="round($px div $TheConstantMilli)"/>
        <xsl:text>mm</xsl:text>
    </xsl:template>
    
    <xsl:variable name="xsl-variables-start">
/* begin Page */
    </xsl:variable>
    
    <xsl:variable name="middle-texture-file-ext">
    </xsl:variable>
    
    <xsl:variable name="text-color">#0F1419</xsl:variable>
    <xsl:variable name="page-background-color">#F7F7F7</xsl:variable>
    <xsl:variable name="default-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: Tahoma, Arial, Helvetica, Sans-Serif;
    font-style: normal;
    font-weight: normal;
    font-size: 13px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="post-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: Tahoma, Arial, Helvetica, Sans-Serif;
    font-style: normal;
    font-weight: normal;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="post-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 12px;
    margin-right: 0px;
    margin-bottom: 12px;
    margin-left: 0px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="link-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">text-decoration: none;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="link-color">#95499C</xsl:variable>
    
    <xsl:variable name="heading-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: Arial, Helvetica, Sans-Serif;
    font-style: normal;
    font-weight: bold;
    font-size: 32px;
    text-decoration: none;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="heading-2-color">#773B7D</xsl:variable>
    <xsl:variable name="heading-2-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: "Trebuchet MS", Arial, Helvetica, Sans-Serif;
    font-size: 24px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="heading-2-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 19px;
    margin-right: 0px;
    margin-bottom: 19px;
    margin-left: 0px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="heading-3-color">#773B7D</xsl:variable>
    <xsl:variable name="heading-3-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: "Trebuchet MS", Arial, Helvetica, Sans-Serif;
    font-size: 22px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="heading-3-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 19px;
    margin-right: 0px;
    margin-bottom: 19px;
    margin-left: 0px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="heading-4-color">#95499C</xsl:variable>
    <xsl:variable name="heading-4-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: "Trebuchet MS", Arial, Helvetica, Sans-Serif;
    font-size: 18px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="heading-4-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 20px;
    margin-right: 0px;
    margin-bottom: 20px;
    margin-left: 0px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="heading-5-color">#773B7D</xsl:variable>
    <xsl:variable name="heading-5-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: "Trebuchet MS", Arial, Helvetica, Sans-Serif;
    font-size: 16px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="heading-5-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 26px;
    margin-right: 0px;
    margin-bottom: 26px;
    margin-left: 0px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="xsl-page">
    /* end Page */
    
    /* begin Box, Sheet */
    </xsl:variable>
    
    <xsl:variable name="box-background-image-sheet">
    </xsl:variable>
    
    <xsl:variable name="box-background-color-sheet">
        <xsl:text>#FFFFFF</xsl:text>
    </xsl:variable>
    
    <xsl:variable name="xsl-box-sheet">
    /* end Box, Sheet */
    
    /* begin Header */
    </xsl:variable>
    
    <xsl:variable name="header-image-header">
        <xsl:text>header.jpg</xsl:text>
    </xsl:variable>
    
    <xsl:variable name="xsl-header-header">
    /* end Header */
    
    /* begin Box, Block, VMenuBlock */
    </xsl:variable>
    
    <xsl:variable name="box-background-image-vmenublock">
        <xsl:text>vmenublock_c.png</xsl:text>
    </xsl:variable>
    
    <xsl:variable name="box-background-color-vmenublock">
    </xsl:variable>
    
    <xsl:variable name="xsl-box-vmenublock">
    /* end Box, Block, VMenuBlock */
    
    /* begin Box, Box, VMenuBlockContent */
    </xsl:variable>
    
    <xsl:variable name="box-background-image-vmenublockcontent">
    </xsl:variable>
    
    <xsl:variable name="box-background-color-vmenublockcontent">
    </xsl:variable>
    
    <xsl:variable name="xsl-box-vmenublockcontent">
    </xsl:variable>
    
    <xsl:variable name="box-background-image-vmenublockcontent">
    </xsl:variable>
    
    <xsl:variable name="box-background-color-vmenublockcontent">
    </xsl:variable>
    
    <xsl:variable name="xsl-box-vmenublockcontent">
    /* end Box, Box, VMenuBlockContent */
    
    /* begin Box, Block */
    </xsl:variable>
    
    <xsl:variable name="box-background-image-block">
        <xsl:text>block_c.png</xsl:text>
    </xsl:variable>
    
    <xsl:variable name="box-background-color-block">
    </xsl:variable>
    
    <xsl:variable name="xsl-box-block">
    /* end Box, Block */
    
    /* begin Box, BlockContent */
    </xsl:variable>
    
    <xsl:variable name="box-background-image-blockcontent">
    </xsl:variable>
    
    <xsl:variable name="box-background-color-blockcontent">
    </xsl:variable>
    
    <xsl:variable name="xsl-box-blockcontent">
    /* end Box, BlockContent */
    
    /* begin Box, Post */
    </xsl:variable>
    
    <xsl:variable name="box-background-image-post">
    </xsl:variable>
    
    <xsl:variable name="box-background-color-post">
    </xsl:variable>
    
    <xsl:variable name="xsl-box-post">
    </xsl:variable>
    
    <xsl:variable name="table-border-style">solid</xsl:variable>
    <xsl:variable name="table-border-weight">
        <xsl:choose>
            <xsl:when test="1 &gt; 0">thin</xsl:when>
            <xsl:otherwise>none</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="table-border-color">#95499C</xsl:variable>
    
    <xsl:variable name="images-border-style">
        <xsl:text>solid</xsl:text>
    </xsl:variable>
    <xsl:variable name="images-border-weight">
        <xsl:text>1</xsl:text>
    </xsl:variable>
    <xsl:variable name="images-border-color">
        <xsl:text>#D4D4D4</xsl:text>
    </xsl:variable>
    <xsl:variable name="images-margin">7</xsl:variable>
    
    <xsl:variable name="xsl-post">
    /* end Box, Post */
    
    /* begin PostHeaderIcon */
    </xsl:variable>
    
    <xsl:variable name="post-header-text-color">#773B7D</xsl:variable>
    <xsl:variable name="post-header-text-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-family: "Trebuchet MS", Arial, Helvetica, Sans-Serif;
    font-size: 26px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="post-header-text-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 0px;
    margin-right: 0px;
    margin-bottom: 5px;
    margin-left: 0px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="post-header-subtitle-font-size">20px</xsl:variable><!-- 0.8 * font-size -->
    <xsl:variable name="post-header-subtitle-font-style">italic</xsl:variable>
    <xsl:variable name="post-header-subtitle-font-weight">normal</xsl:variable>
    
    <xsl:variable name="xsl-post-header-icon">
    /* end PostHeaderIcon */
    
    /* begin PostBullets */
    </xsl:variable>
    
    <xsl:variable name="post-bullets-list-color">#0F1419</xsl:variable>
    
    <xsl:variable name="xsl-post-bullets">/* end PostBullets */
    
    /* begin PostQuote */
    </xsl:variable>
    
    <xsl:variable name="quote-text-color">#204256</xsl:variable>
    
    <xsl:variable name="quote-font">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">font-style: italic;
    font-weight: bold;
    text-align: left;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="quote-font-margin">
        <xsl:call-template name="deserialize"><xsl:with-param name="css">margin-top: 2px;
    margin-right: 0px;
    margin-bottom: 2px;
    margin-left: 15px;</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="quote-border-style">solid</xsl:variable>
    <xsl:variable name="quote-border-weight">
        <xsl:choose>
            <xsl:when test="1 &gt; 0">thin</xsl:when>
            <xsl:otherwise>none</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="quote-border-color">#D4D4D4</xsl:variable>
    
    <xsl:variable name="quote-icon-padding">
        <xsl:call-template name="px-to-mm"><xsl:with-param name="px">12</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="quote-icon-padding-left">
        <xsl:call-template name="px-to-mm"><xsl:with-param name="px">44</xsl:with-param></xsl:call-template>
    </xsl:variable>
    
    <xsl:variable name="quote-background-color">#F7F7F8</xsl:variable>
    <xsl:variable name="quote-background-image">postquote.png</xsl:variable>
    
    <xsl:variable name="xsl-post-quote">
    /* end PostQuote */
    
    
    </xsl:variable>
    
    <xsl:variable name="default-font-size" select="substring-before(exsl:node-set($default-font)/font-size, 'px')"/>
    <xsl:variable name="region-background-color">
        <xsl:choose>
            <xsl:when test="$box-background-color-sheet != ''">
                <xsl:value-of select="$box-background-color-sheet"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$page-background-color"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="header-image">
        <xsl:choose>
            <xsl:when test="normalize-space($header-image-header) != ''">
                <xsl:value-of select="$header-image-header"/>
            </xsl:when>
            <xsl:when test="normalize-space($middle-texture-file-ext) != ''">
                <xsl:text>Middle_texture</xsl:text>
                <xsl:value-of select="$middle-texture-file-ext"/>
            </xsl:when>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="region-body-definition">
        <xsl:if test="$box-background-image-sheet != ''">
            <xsl:attribute name="background-color"><xsl:value-of select="$box-background-image-sheet"/></xsl:attribute>
        </xsl:if>
        <xsl:if test="$region-background-color != ''">
            <xsl:attribute name="background-color"><xsl:value-of select="$region-background-color"/></xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="region-before-definition">
        <xsl:if test="$box-background-image-sheet != ''">
            <xsl:attribute name="background-color"><xsl:value-of select="$box-background-image-sheet"/></xsl:attribute>
        </xsl:if>
        <xsl:if test="$region-background-color != ''">
            <xsl:attribute name="background-color"><xsl:value-of select="$region-background-color"/></xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="region-after-definition">
        <xsl:if test="$box-background-image-sheet != ''">
            <xsl:attribute name="background-color"><xsl:value-of select="$box-background-image-sheet"/></xsl:attribute>
        </xsl:if>
        <xsl:if test="$region-background-color != ''">
            <xsl:attribute name="background-color"><xsl:value-of select="$region-background-color"/></xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="xsl-region-before">
        <xsl:if test="$header-image != ''">
        <fo:static-content flow-name="xsl-region-before">
              <fo:block-container absolute-position="fixed" left="0in" top="0in" width="21cm" height="29.7cm" background-image="skin://resources/img/{$header-image}" background-repeat="no-repeat">
                  <fo:block />
              </fo:block-container>
        </fo:static-content>
        </xsl:if>
    </xsl:template>
    
	<!-- +
         | Main block
         + -->
    <xsl:template name="main-body-block">
        <xsl:for-each select="exsl:node-set($default-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
        <xsl:attribute name="color"><xsl:value-of select="$text-color"/></xsl:attribute>
    </xsl:template>
    
	<!-- +
		 | Paragraph styles
		 + -->
	<xsl:template name="para-style">
		<xsl:param name="class"/>
		
		<xsl:attribute name="space-before"><xsl:value-of select="exsl:node-set($post-font-margin)/margin-top/@mm"/></xsl:attribute>
		<xsl:attribute name="space-after"><xsl:value-of select="exsl:node-set($post-font-margin)/margin-bottom/@mm"/></xsl:attribute>
		
		<xsl:choose>
			<xsl:when test="$class = 'introduction'">
                <xsl:attribute name="font-size"><xsl:value-of select="round(0.9 * $default-font-size)"/>px</xsl:attribute>
				<xsl:attribute name="font-weight">bold</xsl:attribute>
				<xsl:attribute name="letter-spacing">0.085em</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'sub-title'">
				<xsl:attribute name="font-size"><xsl:value-of select="round(0.9 * $default-font-size)"/>px</xsl:attribute>
				<xsl:attribute name="font-variant">small-caps</xsl:attribute>
				<xsl:attribute name="font-weight">bold</xsl:attribute>
				<xsl:attribute name="letter-spacing">0.085em</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'important'">
                <xsl:attribute name="color"><xsl:value-of select="$quote-text-color"/></xsl:attribute>
                <xsl:for-each select="exsl:node-set($quote-font)/*">
                    <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
                </xsl:for-each>
                <xsl:attribute name="background-color"><xsl:value-of select="$quote-background-color"/></xsl:attribute>
                <xsl:attribute name="background-image">skin://resources/img/<xsl:value-of select="$quote-background-image"/></xsl:attribute>
				<xsl:attribute name="background-position">left top</xsl:attribute>
				<xsl:attribute name="background-repeat">no-repeat</xsl:attribute>
                <xsl:attribute name="border-style"><xsl:value-of select="$quote-border-style"/></xsl:attribute>
                <xsl:attribute name="border-color"><xsl:value-of select="$quote-border-color"/></xsl:attribute>
                <xsl:attribute name="border-width"><xsl:value-of select="$quote-border-weight"/></xsl:attribute>
                <xsl:attribute name="margin">4mm 4mm 4mm 18mm</xsl:attribute>
				<xsl:attribute name="padding">
                    <xsl:value-of select="$quote-icon-padding"/><xsl:text> </xsl:text>
                    <xsl:value-of select="$quote-icon-padding"/><xsl:text> </xsl:text>
                    <xsl:value-of select="$quote-icon-padding"/><xsl:text> </xsl:text>
                    <xsl:value-of select="$quote-icon-padding-left"/>
                </xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'secondary'">
				<xsl:attribute name="color"><xsl:value-of select="$post-bullets-list-color"/></xsl:attribute>
				<xsl:attribute name="font-size"><xsl:value-of select="round(0.9 * $default-font-size)"/>px</xsl:attribute>
				<xsl:attribute name="font-style">italic</xsl:attribute>
				<xsl:attribute name="margin-left">14mm</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'narrow-spaced'">
				<xsl:attribute name="line-height">110%</xsl:attribute>
                <xsl:attribute name="space-before">0mm</xsl:attribute>
                <xsl:attribute name="space-after">0mm</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="subscript">
		<xsl:attribute name="font-size">8px</xsl:attribute>
        <xsl:attribute name="baseline-shift">sub</xsl:attribute>
	</xsl:template>
	
	<xsl:template name="supscript">
		<xsl:attribute name="font-size">8px</xsl:attribute>
        <xsl:attribute name="baseline-shift">super</xsl:attribute>
	</xsl:template>
	
	<!-- +
	     | Title styles
	     + -->
	<xsl:template name="title-style">
		<xsl:param name="level"/>
		
		<xsl:choose>
			<xsl:when test="$level = '2'">
                <xsl:for-each select="exsl:node-set($heading-2-font)/*">
                    <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
                </xsl:for-each>
                <xsl:for-each select="exsl:node-set($post-header-text-font)/*">
                    <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
                </xsl:for-each>
				<xsl:attribute name="color"><xsl:value-of select="$post-header-text-color"/></xsl:attribute>
                <xsl:attribute name="space-after"><xsl:value-of select="exsl:node-set($post-header-text-font-margin)/margin-bottom/@mm"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$level = '3'">
                <xsl:for-each select="exsl:node-set($heading-3-font)/*">
                    <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
                </xsl:for-each>
                <xsl:attribute name="font-weight">bold</xsl:attribute>
				<xsl:attribute name="color"><xsl:value-of select="$heading-3-color"/></xsl:attribute>
				<xsl:attribute name="space-after"><xsl:value-of select="exsl:node-set($heading-3-font-margin)/margin-bottom/@mm"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$level = '4'">
                <xsl:for-each select="exsl:node-set($heading-4-font)/*">
                    <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
                </xsl:for-each>
				<xsl:attribute name="text-decoration">none</xsl:attribute><!-- <xsl:value-of select="$heading-font/text-decoration"/> ? -->
				<xsl:attribute name="color"><xsl:value-of select="$heading-4-color"/></xsl:attribute>
				<xsl:attribute name="space-after"><xsl:value-of select="exsl:node-set($heading-4-font-margin)/margin-bottom/@mm"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$level = '5'">
                <xsl:for-each select="exsl:node-set($heading-5-font)/*">
                    <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
                </xsl:for-each>
				<xsl:attribute name="text-decoration">none</xsl:attribute><!-- <xsl:value-of select="$heading-font/text-decoration"/> ? -->
                <xsl:attribute name="color"><xsl:value-of select="$heading-5-color"/></xsl:attribute>
                <xsl:attribute name="space-after"><xsl:value-of select="exsl:node-set($heading-5-font-margin)/margin-bottom/@mm"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    
    <xsl:template name="subtitle-style">
        <xsl:param name="level"/>
        
        <xsl:choose>
            <xsl:when test="$level = '2'">
                <xsl:attribute name="font-size"><xsl:value-of select="$post-header-subtitle-font-size"/></xsl:attribute>
                <xsl:attribute name="font-style"><xsl:value-of select="$post-header-subtitle-font-style"/></xsl:attribute>
                <xsl:attribute name="color"><xsl:value-of select="$post-header-text-color"/></xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    	
	<!-- +
	     | Image styles
	     + -->
	<xsl:template name="image-style">
		<xsl:param name="class"/>
		
        <xsl:if test="$images-border-style != '' and $images-border-weight != '' and $images-border-color != ''">
            <xsl:attribute name="border-style"><xsl:value-of select="$images-border-style"/></xsl:attribute>
            <xsl:attribute name="border-width"><xsl:value-of select="$images-border-weight"/>px</xsl:attribute>
            <xsl:attribute name="border-color"><xsl:value-of select="$images-border-color"/></xsl:attribute>
        </xsl:if>
        <xsl:attribute name="margin">
            <xsl:call-template name="px-to-mm">
                <xsl:with-param name="px" select="$images-margin"/>
            </xsl:call-template>
        </xsl:attribute>
        <xsl:attribute name="padding">0</xsl:attribute>
        
		<xsl:choose>
			<xsl:when test="$class = 'illustration'">
			</xsl:when>
            <xsl:when test="$class = 'invisible'">
                <xsl:attribute name="border-style">none</xsl:attribute>
                <xsl:attribute name="padding">0</xsl:attribute>
			</xsl:when>
            <xsl:when test="$class = 'frame' or $class = 'frame floatleft' or $class = 'frame floatright'">
                <xsl:attribute name="background-color">#FFFFFF</xsl:attribute>
                <xsl:attribute name="padding">1mm</xsl:attribute>
			</xsl:when>
            <xsl:when test="$class = 'largeframe' or $class = 'largeframe floatleft' or $class = 'largeframe floatright'">
                <xsl:attribute name="background-color">#FFFFFF</xsl:attribute>
                <xsl:attribute name="padding">3mm</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>     
	
	<xsl:template name="image-caption">
		<xsl:attribute name="color">#808080</xsl:attribute>
		<xsl:attribute name="font-size">10px</xsl:attribute>
		<xsl:attribute name="space-before">2mm</xsl:attribute>
		<xsl:attribute name="space-after">2mm</xsl:attribute>
	</xsl:template>
	
	<!-- +
	     | Link styles
	     + -->
	<xsl:template name="link-style">
		<xsl:param name="class"/>
		
        <xsl:for-each select="exsl:node-set($post-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
        <xsl:for-each select="exsl:node-set($link-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
        <xsl:attribute name="color"><xsl:value-of select="$link-color"/></xsl:attribute>
        
<!--         <xsl:attribute name="link-style-class"><xsl:value-of select="$class"/></xsl:attribute> -->
        
		<xsl:choose>
			<xsl:when test="$class = 'invisible'">
			</xsl:when>
			<xsl:when test="$class = 'external'">
                <xsl:attribute name="padding-left">6mm</xsl:attribute>
                <xsl:attribute name="background-image">skin://resources/img/link/external.png</xsl:attribute>
                <xsl:attribute name="background-position-horizontal">right</xsl:attribute>
                <xsl:attribute name="background-position-vertical">center</xsl:attribute>
                <xsl:attribute name="background-repeat">no-repeat</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'download'">
                <xsl:attribute name="padding-left">5mm</xsl:attribute>
                <xsl:attribute name="background-image">skin://resources/img/link/download.png</xsl:attribute>
                <xsl:attribute name="background-position-horizontal">left</xsl:attribute>
                <xsl:attribute name="background-position-vertical">center</xsl:attribute>
                <xsl:attribute name="background-repeat">no-repeat</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'know-more'">
                <xsl:attribute name="padding">1mm 6mm 1mm 1mm</xsl:attribute>
                <xsl:attribute name="margin-left">1mm</xsl:attribute>
                <xsl:attribute name="margin-right">1mm</xsl:attribute>
                <xsl:attribute name="background-image">skin://resources/img/link/knowmore.png</xsl:attribute>
                <xsl:attribute name="background-position-horizontal">right</xsl:attribute>
                <xsl:attribute name="background-position-vertical">center</xsl:attribute>
                <xsl:attribute name="background-repeat">no-repeat</xsl:attribute>
                <xsl:attribute name="border-style">solid</xsl:attribute>
                <xsl:attribute name="border-width">1px</xsl:attribute>
                <xsl:attribute name="border-color"><xsl:value-of select="$link-color"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'mailto'">
                <xsl:attribute name="padding-left">7mm</xsl:attribute>
                <xsl:attribute name="background-image">skin://resources/img/link/mailto.png</xsl:attribute>
                <xsl:attribute name="background-position-horizontal">left</xsl:attribute>
                <xsl:attribute name="background-position-vertical">center</xsl:attribute>
                <xsl:attribute name="background-repeat">no-repeat</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="link-href-style">
<!-- 		<xsl:attribute name="text-decoration">none</xsl:attribute> -->
<!-- 		<xsl:attribute name="font-size">10px</xsl:attribute> -->
	</xsl:template>
	
	
	<!-- +
	     | Table styles
	     + -->
	<xsl:template name="table-style">
		<xsl:param name="class"/>
		
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
		<xsl:attribute name="space-after">10mm</xsl:attribute>
		<xsl:choose>
			<xsl:when test="$class = 'invisible'"></xsl:when>
			<xsl:when test="$class = 'simple'">
				<xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
				<xsl:attribute name="border-style">solid</xsl:attribute>
				<xsl:attribute name="border-width">medium</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight'">
				<xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
				<xsl:attribute name="border-style">solid</xsl:attribute>
				<xsl:attribute name="border-width">medium</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'data'">
				<xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
				<xsl:attribute name="border-style">solid</xsl:attribute>
				<xsl:attribute name="border-width">medium</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datastrong'">
				<xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
				<xsl:attribute name="border-style">solid</xsl:attribute>
				<xsl:attribute name="border-width">medium</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="table-caption">
		<xsl:attribute name="color"><xsl:value-of select="$text-color"/></xsl:attribute>
		<xsl:attribute name="font-size">10px</xsl:attribute>
		<xsl:attribute name="space-before">10mm</xsl:attribute>
		<xsl:attribute name="space-after">2mm</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
        <xsl:for-each select="exsl:node-set($default-font)/*">
            <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        </xsl:for-each>
	</xsl:template>
	
	<xsl:template name="tr-style">
		<xsl:param name="class"/>
		<xsl:param name="table-class"/>
				
        <xsl:choose>
            <xsl:when test="$table-class = 'data'">
                <xsl:if test="contains($class, 'even')">
                    <!-- TODO image ?? -->
<!--                     <xsl:attribute name="background-image">skin://resources/img/services/even.png</xsl:attribute> -->
                </xsl:if>
            </xsl:when>
            <xsl:when test="$table-class = 'datastrong'">
                <xsl:if test="contains($class, 'even')">
                    <!-- TODO image ?? -->
<!--                     <xsl:attribute name="background-image">skin://resources/img/services/even.png</xsl:attribute> -->
                </xsl:if>
            </xsl:when>
        </xsl:choose>
	</xsl:template>
	     
	<xsl:template name="th-style">
		<xsl:param name="class"/>
		
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="display-align">center</xsl:attribute>
		<xsl:attribute name="padding-top">2mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">2mm</xsl:attribute>
		<xsl:attribute name="padding-left">2mm</xsl:attribute>
		<xsl:attribute name="padding-right">2mm</xsl:attribute>
		
		<xsl:choose>
			<xsl:when test="$class = 'invisible'">
			</xsl:when>
			<xsl:when test="$class = 'simple'">
				<xsl:attribute name="border-style">solid</xsl:attribute>
				<xsl:attribute name="border-width">medium</xsl:attribute>
                <xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight'">
                <xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'data'">
                <xsl:attribute name="border-style">solid</xsl:attribute>
                <xsl:attribute name="border-width">medium</xsl:attribute>
                <xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
                <!-- TODO image ?? -->
                <xsl:attribute name="background-color">#DFDFDF</xsl:attribute>
<!-- 				<xsl:attribute name="background-color">#006BB1</xsl:attribute> -->
<!-- 				<xsl:attribute name="background-image">skin://resources/img/services/important.png</xsl:attribute> -->
<!-- 				<xsl:attribute name="color">#FFFFFF</xsl:attribute> -->
			</xsl:when>
			<xsl:when test="$class = 'datastrong'">
                <xsl:attribute name="border-style">solid</xsl:attribute>
                <xsl:attribute name="border-width">medium</xsl:attribute>
                <xsl:attribute name="border-color">#FFFFFF</xsl:attribute>
                <xsl:attribute name="background-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
				<xsl:attribute name="color">#FFFFFF</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="td-style">
		<xsl:param name="class"/>
		
        <xsl:attribute name="margin">0mm</xsl:attribute>
        
		<xsl:attribute name="padding-top">2mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">2mm</xsl:attribute>
		<xsl:attribute name="padding-left">2mm</xsl:attribute>
		<xsl:attribute name="padding-right">2mm</xsl:attribute>
        
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">medium</xsl:attribute>
        <xsl:attribute name="border-color"><xsl:value-of select="$table-border-color"/></xsl:attribute>
        
		<xsl:choose>
            <!-- invisible -->
            <xsl:when test="starts-with($class, 'invisible ')">
                <xsl:attribute name="border-style">none</xsl:attribute>
            </xsl:when>
			<!-- simple -->
			<xsl:when test="$class = 'simple even'">
			</xsl:when>
			<xsl:when test="$class = 'simple even first'">
			</xsl:when>
			<xsl:when test="$class = 'simple even last'">
			</xsl:when>
			<xsl:when test="$class = 'simple even first last'">
			</xsl:when>
			<xsl:when test="$class = 'simple odd'">
			</xsl:when>
			<xsl:when test="$class = 'simple odd first'">
			</xsl:when>
			<xsl:when test="$class = 'simple odd last'">
			</xsl:when>
			<xsl:when test="$class = 'simple odd first last'">
			</xsl:when>
			<!-- datalight -->
			<xsl:when test="$class = 'datalight even'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight even first'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight even last'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight even first last'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight odd'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight odd first'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight odd last'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datalight odd first last'">
                <xsl:attribute name="border-style">none</xsl:attribute>
			</xsl:when>
			<!-- data -->
            <!-- TODO background-image even/odd ? -->
			<xsl:when test="$class = 'data even'">
			</xsl:when>
			<xsl:when test="$class = 'data even first'">
			</xsl:when>
			<xsl:when test="$class = 'data even last'">
			</xsl:when>
			<xsl:when test="$class = 'data even first last'">
			</xsl:when>
			<xsl:when test="$class = 'data odd'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'data odd first'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'data odd last'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'data odd first last'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<!-- datastrong -->
            <!-- TODO background-image even/odd ? -->
			<xsl:when test="$class = 'datastrong even'">
			</xsl:when>
			<xsl:when test="$class = 'datastrong even first'">
			</xsl:when>
			<xsl:when test="$class = 'datastrong even last'">
			</xsl:when>
			<xsl:when test="$class = 'datastrong even first last'">
			</xsl:when>
			<xsl:when test="$class = 'datastrong odd'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datastrong odd first'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datastrong odd last'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
			<xsl:when test="$class = 'datastrong odd first last'">
				<xsl:attribute name="background-color">#F2F2F2</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="ol-style">
		<xsl:param name="mark"/>
		
		<xsl:attribute name="text-indent">5mm</xsl:attribute>
		<xsl:attribute name="provisional-label-separation">1em</xsl:attribute>
		<xsl:attribute name="provisional-distance-between-starts">3em</xsl:attribute>
		<xsl:attribute name="space-after">5mm</xsl:attribute>
	</xsl:template>
	
	<xsl:template name="ul-style">
		<xsl:param name="mark"/>
		
		<xsl:attribute name="text-indent">5mm</xsl:attribute>
		<xsl:attribute name="provisional-label-separation">1em</xsl:attribute>
		<xsl:attribute name="provisional-distance-between-starts">3em</xsl:attribute>
		<xsl:attribute name="space-after">5mm</xsl:attribute>
	</xsl:template>
	

</xsl:stylesheet>
