<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:exsl="http://exslt.org/common"
							xmlns:exslt="http://exslt.org/common"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:date="http://exslt.org/dates-and-times"
                            xmlns:stringutils="org.apache.commons.lang.StringUtils"
                            xmlns:text="http://ametys.org/text/3.0"
							exclude-result-prefixes="sitemap resolver ametys date stringutils text exslt">
	
	<!-- https://weatherwidget.io/ -->
	<xsl:template name="weather">
        <div class="ametys-weather">
          <span class="ametys-sidebar__currentdate">
          	<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="full"><xsl:value-of select="date:date"/></i18n:date>
          </span>

          <xsl:call-template name="weather-list"/>
          
          <xsl:call-template name="weather-default"/>
          
          <xsl:call-template name="weather-script"/>
          
        </div>
	</xsl:template>
	
	<xsl:template name="weather-default">
          <a class="weatherwidget-io ametys-sidebar__weather" 
            href="https://forecast7.com/fr/48d862d35/paris/"  
            data-label_1="Paris"
            data-mode="Current" 
            data-font="Roboto"
            data-theme="pure" 
            data-basecolor="transparent" 
            data-textcolor="#ffffff" 
            data-highcolor="#ffffff" 
            data-lowcolor="#BACAD5" 
            data-suncolor="#ffffff" 
            data-mooncolor="#ffffff" 
            data-cloudcolor="#ffffff" 
            data-raincolor="#BACAD5" 
            data-snowcolor="#2BACAD5"
            ></a>
	</xsl:template>
	
	<xsl:template name="weather-list">
		<div class="ametys-weather__select">
            <i class="material-icons" id="ametysCities">keyboard_arrow_down</i>
            <ul class="ametys-weather__list none">
              <li data-url="https://forecast7.com/fr/48d862d35/paris/">PARIS</li>
              <li data-url="https://forecast7.com/fr/43d601d44/toulouse/">TOULOUSE</li>
              <li data-url="https://forecast7.com/fr/44d84n0d58/bordeaux/">BORDEAUX</li>
              <li data-url="https://forecast7.com/fr/43d305d37/marseille/">MARSEILLE</li>
            </ul>
          </div>
	</xsl:template>
	
	<xsl:template name="weather-script">
		<script>
            $j(window).load(function(){
              if(localStorage.length !== 0) {
                $j('.ametys-sidebar__weather').attr('data-label_1', localStorage.city);
                $j('.ametys-sidebar__weather').attr('href', localStorage.url);
                $j('#weatherwidget-io-js').remove();
              }
              weatherWidget();
            });

            $j('#ametysCities').on('click', function(){
              $j('.ametys-weather__list').toggleClass('none');
              $j('#ametysCities').toggleClass('active');
              if($j('#ametysCities').hasClass('active')) {
                $j(this).text('keyboard_arrow_up');
              } else {
                $j(this).text('keyboard_arrow_down');
              }
            });

            $j('.ametys-weather__list li').on('click', function() {
              var text = $(this).text();
              var url = $(this).data('url');

              localStorage.setItem('city', text);
              localStorage.setItem('url', url);

              $j('#ametysCities').text('keyboard_arrow_down');
              $j('#ametysCities').toggleClass('active');

              $j('.ametys-weather__list').toggleClass('none');
              $j('.ametys-sidebar__weather').attr('data-label_1', text);
              $j('.ametys-sidebar__weather').attr('href', url);
              $j('#weatherwidget-io-js').remove();
              weatherWidget();
            });

            $j(document).on('click', function(event) {
              if (!$j(event.target).is("#ametysCities, .ametys-weather__list li")) {
                $j('.ametys-weather__list').addClass('none');
                $j('#ametysCities').removeClass('active');
                $j('#ametysCities').text('keyboard_arrow_down');
              }
            });

            function weatherWidget() {
              !function weatherWidget (d, s, id){
                var js, fjs = d.getElementsByTagName(s)[0];

                if(!d.getElementById(id)){
                  js=d.createElement(s);
                  js.id=id;
                  js.src='https://weatherwidget.io/js/widget.min.js';
                  fjs.parentNode.insertBefore(js, fjs);
                }
              }(document, 'script', 'weatherwidget-io-js');
            }
          </script>
      </xsl:template>
</xsl:stylesheet>