<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="plugin:welcome-tour?://stylesheets/helper.xsl" />
	
	<xsl:variable name="override-card-styles"></xsl:variable>
		
	<xsl:template name="additionnal-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-communities/scss/main.css')}"/>
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-communities/scss/print.css')}" media="screen, print, handheld"/>
        <xsl:call-template name="head-tour-css"/>
	</xsl:template>
    
    <xsl:template name="head-tour-css">
        <xsl:if test="$tourEnabled">
            <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/tour/scss/main.css')}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <xsl:call-template name="head-tour-js"/>
    </xsl:template>
    
    <xsl:template name="head-tour-js">
        <xsl:call-template name="welcome-tour-js"/>
        <xsl:if test="$tourEnabled">
            <script type="text/javascript" src="{ametys:skinURL('templates/common/js/tour-transitions.js')}"></script>
        </xsl:if>
    </xsl:template>
	
	<!-- + 
	     | MAIN ZONE
	     + -->
	<xsl:template name="main-zone">
		<div class="row">
			<div class="col-xl-8 col-print-8">
				<xsl:if test="$template != 'index'">
					<xsl:call-template name="bread-crumb"/>
				</xsl:if>
				
				<a name="content"></a>
				<zone name="default" level="1"/>
			</div>
			<div class="col-xl-4 col-print-4 sidebar">
				<div class="row">
					<zone name="right" level="2"/>
				
					<zone name="syndication" level="2"/>
				</div>
			</div>
		</div>
	</xsl:template>
    
    <xsl:template name="zone-item-class">
        <xsl:variable name="zone-name" select="../@name"/>
        
        <xsl:if test="position() mod 2 = 0"><xsl:text>even </xsl:text></xsl:if>                                
        <xsl:if test="position() = 1"><xsl:text>first </xsl:text></xsl:if>
        <xsl:if test="position() = last()"><xsl:text>last </xsl:text></xsl:if>
        <xsl:if test="$zone-name = 'right' or $zone-name = 'syndication'"><xsl:text>col-md-6 col-xl-12 col-print-12</xsl:text></xsl:if>
    </xsl:template>
	
</xsl:stylesheet>