<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common">
                
    <xsl:import href="plugin:link-directory://pages/services/directory/utils/inputdata_utils.xsl"/>
    
    <!-- // Link directory for lateral menu -->
    <xsl:template match="link[@urlType='PAGE' and @url != '' and @isHidden = 'false']" mode="lateral-menu">
        <li class="ametys-sidebar-main-nav__item">
        	
            <a class="ametys-sidebar-main-nav__link" href="{resolver:resolve('page', @url)}">
                <xsl:apply-templates select="." mode="lateral-menu-link-icon"/>
                <xsl:apply-templates select="." mode="lateral-menu-link-title"/>
            </a>
       </li>
     </xsl:template>
     
     <xsl:template match="link[@urlType='URL' and @url != '' and @isHidden = 'false']" mode="lateral-menu">  
        <li class="ametys-sidebar-main-nav__item">                            
            <a class="ametys-sidebar-main-nav__link" href="{@url}" target="_blank">
                <xsl:apply-templates select="." mode="lateral-menu-link-icon"/>
                <xsl:apply-templates select="." mode="lateral-menu-link-title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="lateral-menu-link-title">
        <xsl:value-of select="@title"/>
    </xsl:template>
    
    <xsl:template match="link" mode="lateral-menu-link-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
    			<span class="ametys-sidebar-main-nav__item-icon picture link-glyph {@pictureGlyph}"></span>
    		</xsl:when>
            <xsl:when test="@pictureType != ''">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <span class="ametys-sidebar-main-nav__item-icon">
                    <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 20, 20)}" alt="{@pictureAlternative}" width="20" height="20"/>
                </span>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!-- // END Link directory for lateral menu -->
    
    <!-- // Link directory for top menu (notifications) -->
    <xsl:template match="link[@urlType='PAGE' and @url != '' and @isHidden = 'false']" mode="top-menu">
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <li class="ametys-header-action-nav__item" data-list-item="" data-ametys-link-id="{$uniqueId}-{@id}">
            <a class="ametys-header-action-nav__link" href="{resolver:resolve('page', @url)}" data-ametys-link-role="link">
                <div class="ametys-header-action-nav__item-left">
                    <xsl:call-template name="link-dynamic-info">
                        <xsl:with-param name="uniqueId" select="$uniqueId" />
                    </xsl:call-template>
                    <xsl:apply-templates select="." mode="top-menu-link-icon"/>
                </div>
                <xsl:apply-templates select="." mode="top-menu-link-title"/>
            </a>
       </li>
     </xsl:template>
     
     <xsl:template match="link[@url != '' and @isHidden = 'false']" mode="top-menu">  
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <li class="ametys-header-action-nav__item" data-ametys-link-id="{$uniqueId}-{@id}">                            
            <a class="ametys-header-action-nav__link" href="{@url}" target="_blank" data-ametys-link-role="link">
                <div class="ametys-header-action-nav__item-left">
                    <xsl:call-template name="link-dynamic-info">
                        <xsl:with-param name="uniqueId" select="$uniqueId" />
                    </xsl:call-template>
                    <xsl:apply-templates select="." mode="top-menu-link-icon"/>
                </div>
                <xsl:apply-templates select="." mode="top-menu-link-title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="top-menu-link-title">
        <div class="ametys-header-action-nav__item-text">
            <xsl:value-of select="@title"/>
        </div>
    </xsl:template>
    
    <xsl:template match="link" mode="top-menu-link-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
    			<span class="ametys-header-action-nav__item-icon picture link-glyph {@pictureGlyph}"></span>
    		</xsl:when>
            <xsl:when test="@pictureType != ''">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <span class="ametys-header-action-nav__item-icon">
                    <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 20, 20)}" alt="{@pictureAlternative}" width="20" height="20"/>
                </span>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!-- // END Link directory for top menu -->
    
    <!-- // Link directory for footer links -->
    <xsl:template match="link[@urlType='PAGE' and @url != '' and @isHidden = 'false']" mode="footer">
        <li class="ametys-footer-social__item">
            <a class="ametys-footer-social__link" href="{resolver:resolve('page', @url)}" title="{@title}">
                <xsl:apply-templates select="." mode="footer-link-icon"/>
                <xsl:apply-templates select="." mode="footer-link-title"/>
            </a>
       </li>
     </xsl:template>
     
     <xsl:template match="link[@url != '' and @isHidden = 'false']" mode="footer">  
        <li class="ametys-footer-social__item">                            
            <a class="ametys-footer-social__link" href="{@url}" target="_blank" title="{@title}">
                <xsl:apply-templates select="." mode="footer-link-icon"/>
                <xsl:apply-templates select="." mode="footer-link-title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="footer-link-title">
    </xsl:template>
    
    <xsl:template match="link" mode="footer-link-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
    			<span class="ametys-footer-social__item-icon picture link-glyph {@pictureGlyph}"></span>
    		</xsl:when>
            <xsl:when test="@pictureType != ''">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <span class="ametys-footer-social__item-icon">
                    <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 20, 20)}" alt="{@pictureAlternative}" width="20" height="20"/>
                </span>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!-- // END Link directory for footer links -->
    
    <xsl:template name="link-dynamic-info">
        <xsl:param name="uniqueId" select="$uniqueId" />
        
    	<span class="link-dynamic-info" id="{concat('link-info-', $uniqueId, '-', substring-after(@id, 'directoryLink://'))}" data-ametys-link-role="dynamic-info"></span>
    </xsl:template>
    
</xsl:stylesheet>