<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
                
    <xsl:import href="plugin:link-directory://pages/services/directory/utils/config_utils.xsl"/>
    
    <xsl:variable name="buttonId" select="substring-after(math:random(), '.')"/>
    <!-- Max number of links displayed before a "See more" button appears -->    
    <xsl:variable name="maxCheckedLinks" select="8"/>
    
    <!-- Configure links button for a service or an input data -->
    <xsl:template name="configure-links-dialog">
        <xsl:param name="maxCheckedLinks"/>
        
        <xsl:variable name="buttonId" select="substring-after(math:random(), '.')"/>
        <script type="text/javascript">
            <!-- Set up the dialog's form -->
            <xsl:call-template name="configure-links-dialog-and-form">
                <xsl:with-param name="maxCheckedLinks" select="$maxCheckedLinks"/>
                <xsl:with-param name="links" select="/links/link"/>
                <xsl:with-param name="buttonId" select="$buttonId"/>
            </xsl:call-template> 
             
             <!-- Logic of the button and its dialog -->
             <xsl:call-template name="configure-links-btn-script">
                 <xsl:with-param name="maxCheckedLinks" select="$maxCheckedLinks"/>
                 <xsl:with-param name="buttonId" select="$buttonId"/>
             </xsl:call-template>
        
        </script>
    </xsl:template>
    
    <!-- Default rendering for a service -->
    <xsl:template name="configure-links-btn">
        <xsl:param name="buttonId"/>
        
        <xsl:choose>
            <xsl:when test="not(ametys:user())">
                <!-- The user is not connected: the button is not displayed -->
            </xsl:when>
            <xsl:otherwise>
                document.writeln("&lt;label class=\"ametys-toggle\"&gt;&lt;input id=\"configure-links-hyperlink-<xsl:value-of select="$buttonId"/>\" class=\"ametys-toggle__check ametys-edit-mode-checker\"  type=\"checkbox\" data-edit-mode-toggle=\"\"&gt;&lt;span class=\"ametys-toggle__control\"&gt;&lt;span class=\"ametys-toggle__control-dot\"&gt;&lt;span class=\"ametys-toggle__control-dot-icon material-icons filter_vintage\"&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/label&gt;");
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- The dialog and the form when clicking the button -->
    <xsl:template name="configure-links-dialog-and-form"> 
        <xsl:param name="maxCheckedLinks"/>
        <xsl:param name="links"/>
        <xsl:param name="buttonId"/>
        
		document.writeln("&lt;div class=\"ametys-add-new-item\" style=\"display: none;\" data-extra-list-wrap&gt;");
			document.writeln("&lt;h3 class=\"ametys-add-new-item__title mb-0\"&gt;<i18n:text i18n:key="SKIN_LINKDIRECTORY_CONFIGURE_LINKS_TITLE" i18n:catalogue="skin.{$skin}"/>&lt;/h3&gt;");
<!-- 					document.writeln("&lt;p class=\"ametys-add-new-item__text\"&gt;<i18n:translate><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_DIALOG_TITLE" i18n:catalogue="plugin.link-directory"/><i18n:param name="maxCheckedLinks"><xsl:value-of select="$maxCheckedLinks"/></i18n:param></i18n:translate>&lt;/p&gt;") -->
				document.writeln("&lt;div class=\"ametys-tools-list-scroll\" data-extra-list-scroll&gt;");
					document.writeln("&lt;ul class=\"ametys-tools-list\" data-extra-list&gt;");
					
						<xsl:for-each select="$links">
		                     <xsl:apply-templates select="." mode="configure-field">
		                         <xsl:with-param name="buttonId" select="$buttonId"/>
		                     </xsl:apply-templates>
		               </xsl:for-each>
		               
					document.writeln("&lt;/ul&gt;");
				document.writeln("&lt;/div&gt;");
			document.writeln("&lt;/div&gt;");
    </xsl:template>
    
     <!-- Configure the checkboxes of the form -->    
    <xsl:template match="link" mode="configure-field">
        <xsl:param name="buttonId"/>
    
        <xsl:variable name="label">
            <xsl:choose>
                <xsl:when test="normalize-space(@title) != ''">
                    <xsl:value-of select="@title"/>
                </xsl:when>
                <xsl:when test="normalize-space(@pageTitle) != ''">
                    <xsl:value-of select="@pageTitle"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@url"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:choose>
        	<xsl:when test="@user-selected = 'true'"></xsl:when>
        	<xsl:otherwise>
		        document.writeln("&lt;li class=\"ametys-tools-list__item\" data-extra-list-item&gt;");
					document.writeln("&lt;a class=\"ametys-tools-list__link\" href=\"#\"&gt;");
						document.writeln("&lt;span class=\"ametys-tools-list__icon\" style=\"background-color:<xsl:value-of select="@color"/>\" &gt;");
							document.writeln("&lt;span class=\"ametys-tools-list__action\"&gt;&lt;/span&gt;");
								document.writeln("&lt;span class=\"ametys-tools-list__icon-content material-icons ondemand_video\"&gt;&lt;/span&gt;");
							document.writeln("&lt;/span&gt;");
						document.writeln("&lt;span class=\"ametys-tools-list__title\"&gt;<xsl:value-of select="ametys:escapeJS($label)"/>&lt;/span&gt;");
					document.writeln("&lt;/a&gt;");
				document.writeln("&lt;/li&gt;");
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
    