<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
     
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:template name="common-service-head-css">    
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-web/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="search-results-class-attribute">
        <xsl:attribute name="class">card-body d-flex flex-wrap align-items-sm-end flex-column flex-sm-row pt-0</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="hits-class-attribute">
        <xsl:attribute name="class">ametys-webtv-list</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-webtv-list__item<xsl:text> </xsl:text>
    </xsl:template>           
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_MULTIMEDIA" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
    	<i class="card-header__icon material-icons">live_tv</i>
    </xsl:template>
	
</xsl:stylesheet>
