<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="plugin:link-directory://pages/services/directory/dynamic-info/default.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/utils.xsl"/>
    
    <!-- Override to display long value in tooltip -->
    <xsl:template match="dynamic-information[@id]">
        <dynamic-information id="{@id}">
            <xsl:if test="error">
                <xsl:attribute name="error"><xsl:value-of select="error/@type"/></xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="short-value" />
            <xsl:if test="tooltip/item">
                <xsl:apply-templates select="tooltip" />
            </xsl:if>
            <xsl:apply-templates select="error" />
        </dynamic-information>
    </xsl:template>
    
    <!-- Override to display long value in tooltip -->
    <xsl:template match="tooltip">
        <span class="link-info-tooltip" data-ametys-link-role="tooltip">)>
            <xsl:apply-templates select="../long-value"/>
            <ul>
                <xsl:apply-templates select="item" />
            </ul>
        </span>
    </xsl:template>
    
    <!-- Override to use ul/li elements -->
    <xsl:template match="item">
        <li class="link-info-item">
            <xsl:apply-templates select="title" />
            <xsl:apply-templates select="summary" />
            <xsl:apply-templates select="footer" />
        </li>
    </xsl:template>
    
    <xsl:template match="short-value">
    	<xsl:if test=". != '0'">
	       <span class="ametys-header-action-nav__item-badge" data-ametys-link-role="short-value">
	           <xsl:apply-templates />
	       </span>
	    </xsl:if>
   </xsl:template>
   
   <!-- Override to truncate summary -->
   <xsl:template match="summary">
        <span class="link-info-summary">
            <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="defaultText" select="text()"/>                
                <xsl:with-param name="maxDefaultTextSize" select="'70'"/>                
            </xsl:call-template>
        </span>
    </xsl:template>
   
</xsl:stylesheet>