<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	    xmlns:docbook="http://docbook.org/ns/docbook"
	    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
	    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	    xmlns:text="http://ametys.org/text/3.0" 
	    xmlns:exslt="http://exslt.org/common"
	    exclude-result-prefixes="docbook resolver ametys exslt"
	    xmlns:datetime="http://ametys.org/datetime/4.2"
	    extension-element-prefixes="datetime text">

	<xsl:import href="plugin:news://stylesheets/content/news/news-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl" />
	
    <xsl:variable name="abstractTextMaxSize">150</xsl:variable>
    
	<xsl:template name="common-content-body-title"/>
	
    <xsl:template name="common-content-body">
        <xsl:call-template name="common-content-body-content"/>
    </xsl:template>
    
	<xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}" class="agenda__item">
                    <xsl:call-template name="content"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <div class="agenda__item">
                    <xsl:call-template name="content"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
	<xsl:template name="content">
        <xsl:call-template name="content-dates"/>
        
        <div class="agenda__item__info">
            <div>
                <xsl:call-template name="content-title"/>
                <xsl:call-template name="content-abstract"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h2 class="agenda__item__info__title">
            <xsl:value-of select="metadata/title" />
        </h2>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">agenda__item__info__text</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="$abstractTextMaxSize" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <div class="agenda__item__date">
            <xsl:call-template name="content-date-format">
                <xsl:with-param name="date" select="metadata/start-date"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="content-date-format">
        <xsl:param name="date"/>
        
        <span class="agenda__item__date__nb">
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="d">
                <xsl:value-of select="$date"/>
            </i18n:date>
        </span>
        <span class="agenda__item__date__month">
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="MMM">
                <xsl:value-of select="$date" />
            </i18n:date>
        </span>
    </xsl:template>
    
</xsl:stylesheet>