<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
                
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">ametys-cms-zone-timeline</xsl:variable>
    <xsl:variable name="is-empty" select="count(/search/hits/hit) = 0"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-agenda/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-calendar card mb-4 {$override-card-styles}">
            <xsl:call-template name="header"/>
            
            <xsl:call-template name="search-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_NEWS_AGENDA" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons access_time"></span>
    </xsl:template>
    
    <xsl:template name="hits">
        <xsl:for-each select="/search/hits/hit">
            <xsl:call-template name="hit"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="hit">
        <xsl:apply-templates select="."/>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']">
        <xsl:apply-templates select="content/html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level">1</xsl:with-param>
        </xsl:apply-templates>                           
    </xsl:template>
     
</xsl:stylesheet>
