<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	xmlns:math="java.lang.Math"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	extension-element-prefixes="ametys math sitemap resolver">

	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>

    <!-- +
         | Name of global search text field :
         | * use "user.input.criterion.common$wording$textfield$1" if global search service if configured with "Full text" criteria
         | * use "user.input.criterion.common$titleorwording$textfield$1" if global search service if configured with "Title or full text" criteria
         + -->
    <xsl:variable name="searchInputName">user.input.criterion.common$titleorwording$textfield$1</xsl:variable>
    
    <xsl:template name="search-head">
		<xsl:call-template name="search-placeholder"/>
		<xsl:call-template name="search-keywords-highlight"/>
	</xsl:template>

    <xsl:template name="search-placeholder">
<!-- 		<script type="text/javascript" src="{ametys:skinURL('templates/common/js/jquery.placeholder.min.js')}"></script> -->
<!-- 		<script type="text/javascript"> -->
<!-- 			$j().ready(function() { $j("#search-field-<xsl:value-of select="$uniqueId"/>").placeholder(); }); -->
<!-- 		</script> -->
	</xsl:template>
	
    <xsl:template name="search">
    	<xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]">
    		<a name="search"></a>
    		
    		<div class="ametys-header-search-wrap">
								
				<form id="searchMenu"  action="{resolver:resolve('page', /cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]/@sitemap:id)}" method="post">
					<xsl:if test="ametys:renderingContext() = 'back'"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>
					
					<div class="ametys-header-search">
						<label for="search-field-{$uniqueId}" class="d-none"><i18n:text i18n:key="SKIN_SEARCH_LABEL" i18n:catalogue="skin.{$skin}"/></label>
						<input type="text" class="ametys-header-search__field" name="{$searchInputName}" id="search-field-{$uniqueId}" placeholder="skin.{$skin}:SKIN_SEARCH_INPUT_TITLE" i18n:attr="placeholder">
                            <xsl:call-template name="search-form-fields-additionnal-attributes"/>
                        </input>
						<input type="hidden" name="submit-form" />
						
						<span class="ametys-header-search-invoker d-md-none"
						      data-target-show="#search-field-{$uniqueId}"
						      data-target-hide="#headerLogo">
							<span class="ametys-header-search-invoker__icon material-icons search"></span>
						</span>
						<button class="ametys-header-search-invoker d-none d-md-inline-flex" type="submit"
						      data-target-show="#search-field-{$uniqueId}"
						      data-target-hide="#headerLogo">
							<span class="ametys-header-search-invoker__icon material-icons search"></span>
						</button>
					</div>
				</form>
			</div>
	    </xsl:if>
    </xsl:template>
    
    <!-- Activate the fast search on page title -->
    <xsl:template name="search-form-fields-additionnal-attributes">
        <xsl:attribute name="data-ametys-fastsearch">page</xsl:attribute>
        <xsl:attribute name="data-ametys-fastsearch-result-classname-hide">noresult</xsl:attribute>
        <xsl:attribute name="data-ametys-fastsearch-result-ul-classname">ametys-fastsearch-result-ul</xsl:attribute>
        <xsl:attribute name="data-ametys-fastsearch-result-li-classname">ametys-fastsearch-result-li</xsl:attribute>
    </xsl:template>

    <xsl:template name="search-keywords-highlight">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/jquery.mark.js')}"></script>
        <script type="text/javascript">
            $j(function()
            {
                // Extract the keywords from the URL
                var hlRegexp = new RegExp('[\?\&amp;]search-keywords=([^\?\&amp;#;]+)', 'i');
                var result = hlRegexp.exec(location.search);
                if (result != null &amp;&amp; result.length &gt; 1)
                {
                    var keywords = result[1].split('+');
                    for (var x = 0; x &lt; keywords.length; x++)
                    {
                        if (keywords[x] != '')
                        {
                            <xsl:for-each select="/cms/template-information/template/zone">
                                $j('#ametys-cms-zone-<xsl:value-of select="@id"/>').mark($j.trim(decodeURIComponent(keywords[x])));
                            </xsl:for-each> 
                        }
                    }
                }
            });
        </script>
    </xsl:template> 
    
</xsl:stylesheet>
