<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:exsl="http://exslt.org/common"
    xmlns:math="java.lang.Math"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:encoder="java.net.URLEncoder"
    xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
    extension-element-prefixes="resolver exsl math escaper ametys encoder event">

    <xsl:import href="plugin:mobileapp://pages/services/mobilelink/mobilelink_1.0.xsl"/>

	<xsl:template name="common-service-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/mobile-link/scss/main.css')}" />
	</xsl:template>
    
    <xsl:template name="mobilelink-connection-generate-btn">
        <xsl:variable name="onclick">
            <xsl:call-template name="generate-js-method-call">
                <xsl:with-param name="element-id-to-visual-link">#access-link-<xsl:value-of select="$uniqueId" /></xsl:with-param>
                <xsl:with-param name="element-id-to-insert-qrcode">#access-qr-<xsl:value-of select="$uniqueId" /></xsl:with-param>
                <xsl:with-param name="link-text">Cliquer ici depuis votre mobile</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
            
        <div id="generate-link-{$uniqueId}" class="{$common-service-css-class-name}__generate-link">
            <a href="javascript:void(0)" onclick="{$onclick}">
                <i class="fas fa-qrcode"></i>
                <i18n:text i18n:key="SERVICE_MOBILE_LINK_GENERATE_ACCESS"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="mobilelink-connection-access-link">
        <div class="{$common-service-css-class-name}__access-link" id="access-link-{$uniqueId}"></div>
    </xsl:template>

</xsl:stylesheet>
