<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="ametys docbook">

    <xsl:import href="plugin:user-directory://stylesheets/content/udorgunit/udorgunit-main.xsl"/>  
    
    <xsl:template name="common-content-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/udorgunit/scss/main.css')}"/>
    </xsl:template> 

   <xsl:template name="main-users-list" >
        <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
        
        <ul class="ametys-udorgunit-list">
            <xsl:for-each select="//users/user[@role and @metadataSetName=$metadataSetName]">
                <li class="ametys-udorgunit-list__item ">
           			<xsl:call-template name="main-user">
                        <xsl:with-param name="truelevel" select="$truelevel"/>
                    </xsl:call-template>
	            </li>
	        </xsl:for-each>	        
        </ul>
    </xsl:template>
    
    <xsl:template name="main-user">
        <xsl:param name="truelevel"/>
        
         <article class="card card-no-shadow card-bordered h-100">
         	<div class="card-body">
	            <xsl:element name="h{$truelevel}">
	            	<xsl:attribute name="class">card-title</xsl:attribute>
	            <xsl:value-of select="@role"/></xsl:element>
	            <xsl:call-template name="content">
	                <xsl:with-param name="content" select="content"/>
	                <xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template>
	        </div>
        </article>
    </xsl:template>
    
    <xsl:template name="other-users-list" >
	        
	    <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
        <ul class="ametys-udorgunit-list"> 
             <xsl:for-each select="//users/user[not(@role) and @metadataSetName=$metadataSetName]">
                <li class="ametys-udorgunit-list__item member">
           			<xsl:call-template name="main-user">
                        <xsl:with-param name="truelevel" select="$truelevel"/>
                    </xsl:call-template>
	            </li>
	        </xsl:for-each>	        
        </ul>
	        
    </xsl:template>
    
        
    <xsl:template name="other-users">
        <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
        <xsl:if test="//users/user[not(@role) and @metadataSetName=$metadataSetName]" >
	        <div class="other-users">
	            <xsl:call-template name="other-users-title">
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
	            <xsl:call-template name="other-users-list">
                    <xsl:with-param name="metadataSetName" select="$metadataSetName"/>
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-list">
        <xsl:param name="truelevel"/>
        <ul class="child-orgUnits-list">
            <xsl:for-each select="//orgUnits/orgUnit">
                <li>
                    <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
                    <i class="fas fa-chevron-right"></i>
                    <xsl:call-template name="content">
                        <xsl:with-param name="content" select="content"/>
                        <xsl:with-param name="level" select="$truelevel + 1"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
</xsl:stylesheet>