<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:linkDirectory="org.ametys.plugins.linkdirectory.LinkDirectoryXSLTHelper">

<!--     <xsl:import href="service:web://pages/services/common.xsl"/>  -->
    <xsl:import href="plugin:link-directory://pages/services/directory/thumbnails_1.1.xsl"/>
    
    <xsl:template name="dynamic-info-view">thumbnails</xsl:template>
    
    <xsl:variable name="is-empty" select="count(/links/link) = 0"/>    
    <xsl:variable name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="configurable" select="ametys:serviceParameter('configurable')/text()"/>
    <xsl:variable name="display-user-links" select="ametys:serviceParameter('displayUserLinks')/text()"/>
    <!-- Rendering -->
    <xsl:variable name="ametys-tools-list-rendering">ametys-tools-list--round</xsl:variable>
    <xsl:variable name="dataSettings">{
    					 "qty": 6,
						 "appsListQty": {
						   "xs": 2,
							 "md": 2
						 }
			     }</xsl:variable><!-- define number of rows displayed on load -->
    
    <xsl:template name="common-service-head-css">
    	<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/animate.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/plugins/custombox/custombox.min.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}" />
		
		<link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/index-tools/scss/print.css')}"/>
	</xsl:template>
	
	<xsl:template name="common-service-head-js">
		<script src="{ametys:skinURL('zones/index-tools/plugins/web-animations-js/web-animations.min.js')}"></script>
		<script src="{ametys:skinURL('zones/index-tools/plugins/hammerjs/hammer.min.js')}"></script>
		<script src="{ametys:skinURL('zones/index-tools/plugins/muuri/dist/muuri.min.js')}"></script>
		<script src="{ametys:skinURL('zones/index-tools/plugins/custombox/custombox.min.js')}"></script>
		
		<script src="{ametys:skinURL('zones/index-tools/plugins/perfect-scrollbar/dist/perfect-scrollbar.min.js')}"></script>
		<script src="{ametys:skinURL('zones/index-tools/js/ametys-tools.js')}"></script>
		<script src="{ametys:pluginResourceURL('link-directory', 'js/LinkDirectoryHelper.js')}" type="text/javascript"></script>
        
        <xsl:call-template name="link-dynamic-info-js">
            <xsl:with-param name="themes" select="ametys:serviceParameter('themes')"/>
        </xsl:call-template>
	</xsl:template>
    
    <xsl:template name="common-service-head-other">
        <script type="text/javascript">
            $j(function(){
              var $tool = $j('#tool-<xsl:value-of select="$uniqueId"/>');
              $tool.HSAmetysTools($j('#tool-<xsl:value-of select="$uniqueId"/>').data('settings'));
              $tool.on('elementDeleted', deleteLink_<xsl:value-of select="$uniqueId"/>);
              $tool.on('elementDeactivated', deactivateLink_<xsl:value-of select="$uniqueId"/>);
              $tool.on('elementActivated', activateLink_<xsl:value-of select="$uniqueId"/>);
              $tool.on('elementMoved', moveLink_<xsl:value-of select="$uniqueId"/>);
            });
        </script>
    </xsl:template>

    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
		<div id="tool-{$uniqueId}" data-settings="{normalize-space($dataSettings)}">
			<xsl:if test="$template ='index'"><xsl:attribute name="class">ametys-tools card rounded mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute></xsl:if>
			
            <xsl:call-template name="header"/>
			
            <div class="card-body pt-0 pb-4 px-0">
				<xsl:if test="$is-empty">
					<p class="ametys-tools-no-items-text" data-no-items-text="">
						<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SERVICE_NO_ENTRY" i18n:catalogue="plugin.link-directory"/>
					</p>
				</xsl:if>
                
                <!-- Selected links -->
				<div class="ametys-tools-list-wrap {$ametys-tools-list-rendering} ametys-animated-heigth" data-list-wrap="" id="selected-links-{$uniqueId}">
					<ul class="ametys-tools-list ametys-tools-list_editable" data-list="">
						 <xsl:apply-templates select="/links/link[@isHidden = 'false']"  mode="config">
		                    <xsl:sort select="@user-selected='true'" order="descending"/>
		                </xsl:apply-templates>
					</ul>
				</div>
			</div>
			
            <!-- Unselected links -->
            <xsl:call-template name="extra-links"/>
            
            <!-- Add form -->
            <xsl:call-template name="add-user-link-form">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
                <xsl:with-param name="display-user-links" select="$display-user-links"/>
            </xsl:call-template>
                      
			<xsl:call-template name="footer"/>
            
            <!-- Modal (delete, confirm) -->
            <xsl:call-template name="user-links-modals">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:call-template>
            
            <xsl:call-template name="app-js"/>
		</div>
    </xsl:template>
    
    <xsl:template name="extra-links">
        <xsl:param name="links"/>
        <xsl:param name="uniqueId" select="$uniqueId"/>
        <xsl:param name="configurable" select="$configurable"/>
        <xsl:param name="display-user-links" select="$display-user-links"/>
        
        <xsl:if test="$configurable = 'true'">
            <div class="ametys-add-new-item" style="display: none;" data-extra-list-wrap="" id="unselected-links-{$uniqueId}">
                <h3 class="ametys-add-new-item__title mb-0"><i18n:text i18n:key="SKIN_LINKDIRECTORY_EXTRA_LINKS_TITLE" i18n:catalogue="skin.{$skin}"/></h3>
                <div class="ametys-tools-list-scroll" data-extra-list-scroll="">
                    <ul class="ametys-tools-list" data-extra-list="">
                        <xsl:apply-templates select="/links/link[@isHidden = 'true']" mode="config">
                            <xsl:sort select="@user-selected='true'" order="descending"/>
                            <xsl:with-param name="extra" select="true()"/>
                        </xsl:apply-templates>
                    </ul>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="add-user-link-form">
        <xsl:if test="$display-user-links = 'true'">
            <div id="data-add-new-item-form-{$uniqueId}" class="ametys-add-new-item" style="display: none;" data-add-new-item-wrap="">
				<form action="/" data-add-new-item-form="">
					<h2 class="ametys-add-new-item__title"><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS_TITLE" i18n:catalogue="plugin.link-directory"/></h2>
					
					<div class="ametys-field-group">
						<div class="ametys-field-group__error-message" style="display:none">
                             <div class="ametys-field-group__icon">
                                 <span class="fas fa-warning"></span>
                             </div>
                             <div class="ametys-field-group__error-message-text"><i18n:text i18n:key="SKIN_LINKDIRECTORY_ADD_LINK_ERROR" i18n:catalogue="skin.{$skin}"/></div>
                         </div>
                         
						<label class="d-none" for="mesOutilsItemUrl"><i18n:text i18n:key="SKIN_LINKDIRECTORY_ADD_USER_LINK_DIALOG_FIELD_URL_PLACEHOLDER" i18n:catalogue="skin.{$skin}"/></label>
						
						<div class="ametys-field-group__prepend">
							<div class="ametys-field-group__icon">
								<span class="fas fa-link"></span>
							</div>
						</div>
						
						<input id="mesOutilsItemUrl" class="ametys-field-group__control" name="mesOutilsItemUrl" type="text" placeholder="skin.{$skin}:SKIN_LINKDIRECTORY_ADD_USER_LINK_DIALOG_FIELD_URL_PLACEHOLDER" i18n:attr="placeholder" data-add-new-item-field-url="" />
					</div>
					<div class="ametys-field-group">
						<label class="d-none" for="mesOutilsItemTitle"><i18n:text i18n:key="SKIN_LINKDIRECTORY_ADD_USER_LINK_DIALOG_FIELD_TITLE_PLACEHOLDER" i18n:catalogue="skin.{$skin}"/></label>
						
						<div class="ametys-field-group__prepend">
							<div class="ametys-field-group__icon">
								<span class="fas fa-pencil-alt"></span>
							</div>
						</div>
						
						<input id="mesOutilsItemTitle" class="ametys-field-group__control" name="mesOutilsItemTitle" type="text" placeholder="skin.{$skin}:SKIN_LINKDIRECTORY_ADD_USER_LINK_DIALOG_FIELD_TITLE_PLACEHOLDER" i18n:attr="placeholder" data-add-new-item-field-title="" />
					</div>
					
					<div class="text-right">
                        <input id="linkId" name="linkId" type="hidden" />
                        <input id="favicon" name="favicon" type="hidden" />
						<button class="btn btn-sm btn-pilled font-weight-bold text-uppercase g-py-5 px-3" type="submit" disabled="" data-add-new-item-field-submit="">
							<span class="g-font-size-16 fas fa-plus mr-2"></span>
							<i18n:text i18n:key="SKIN_LINKDIRECTORY_ADD" i18n:catalogue="skin.{$skin}"/>
						</button>
					</div>
				</form>
			</div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-links-modals">
        <!-- Delete confirm -->
        <div id="data-delete-modal-{$uniqueId}" class="text-left g-max-width-600 g-bg-white g-overflow-y-auto g-pa-20" style="display: none;" data-delete-modal="">
            <h4 class="g-mb-20"><i18n:text i18n:key="SKIN_LINKDIRECTORY_DELETE_LINK" i18n:catalogue="skin.{$skin}"/></h4>
            
            <div class="text-center">
                <span class="btn btn-md u-btn-primary g-mx-5" data-delete-modal-confirm=""><i18n:text i18n:key="SKIN_LINKDIRECTORY_YES" i18n:catalogue="skin.{$skin}"/></span>
                <span class="btn btn-md u-btn-outline-bluegray g-mx-5" data-delete-modal-close=""><i18n:text i18n:key="SKIN_LINKDIRECTORY_NO" i18n:catalogue="skin.{$skin}"/></span>
            </div>
        </div>
        
        <!-- Deactivate confirm -->
        <div id="data-deactivate-modal-{$uniqueId}" class="text-left g-max-width-600 g-bg-white g-overflow-y-auto g-pa-20" style="display: none;" data-deactivate-modal="">
            <h4 class="g-mb-20"><i18n:text i18n:key="SKIN_LINKDIRECTORY_DEACTIVATE_LINK" i18n:catalogue="skin.{$skin}"/></h4>
            
            <div class="text-center">
                <span class="btn btn-md u-btn-primary g-mx-5" data-deactivate-modal-confirm="{$uniqueId}"><i18n:text i18n:key="SKIN_LINKDIRECTORY_YES" i18n:catalogue="skin.{$skin}"/></span>
                <span class="btn btn-md u-btn-outline-bluegray g-mx-5" data-deactivate-modal-close=""><i18n:text i18n:key="SKIN_LINKDIRECTORY_NO" i18n:catalogue="skin.{$skin}"/></span>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="header">
    	<header class="card-header pb-0">
			<h2 class="card-title">
				<xsl:call-template name="card-header-icon"/>
				<xsl:choose>
		            <xsl:when test="$header != ''">
		              	<xsl:value-of select="$header"/>
		            </xsl:when>
		            <xsl:otherwise>
		            	<xsl:call-template name="header-default-title"/>
		            </xsl:otherwise>
		        </xsl:choose>
			</h2>
			
			<xsl:call-template name="configure-button"/>
		</header>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon icofont-layers"></span>
    </xsl:template>
    
    <xsl:template name="header-default-title">
        <i18n:text i18n:key="SKIN_MY_TOOLS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="configure-button">
        <xsl:if test="ametys:user() and ($display-user-links = 'true' or $configurable = 'true')">
            <label class="ametys-toggle">
                <input class="ametys-toggle__check ametys-edit-mode-checker" type="checkbox"
                       data-edit-mode-toggle="" />
                
                <span class="ametys-toggle__control">
                    <span class="ametys-toggle__control-dot">
                        <span class="ametys-toggle__control-dot-icon"></span>
                    </span>
                </span>
            </label>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer">
    	<footer class="card-footer text-center" data-footer="">
			<span class="ametys-show-more" data-toggle="" data-default-text="skin.{$skin}:SKIN_DISPLAY_MORE" data-active-text="skin.{$skin}:SKIN_DISPLAY_LESS"  i18n:attr="data-default-text data-active-text" style="display: none;">
				<span class="ametys-show-more__text" data-toggle-text=""><i18n:text i18n:key="SKIN_DISPLAY_MORE" i18n:catalogue="skin.{$skin}"/></span>
				<span class="ametys-show-more__icon material-icons expand_more"></span>
			</span>
		</footer>
	</xsl:template>	

    <xsl:template name="app-js">
		<script type="text/javascript">
                function getSelectedLinks_<xsl:value-of select="$uniqueId"/>()
                {
                    var orderedItems = $j("#selected-links-<xsl:value-of select="$uniqueId"/> li").map(function(){
                        var $this = $(this);
                        return {
                            offset : $this.offset(),
                            servid : $this.find("a[data-serverid]").attr("data-serverid")
                        };
                    }).get();
                
                    orderedItems.sort(function(a, b) {
                        if (a.offset.top != b.offset.top)
                        {
                            return a.offset.top - b.offset.top;
                        }
                        else
                        {
                            return a.offset.left - b.offset.left;
                        }
                    });
                    var orderedItemsIds = [];
                    for (var i in orderedItems)
                    {
                        orderedItemsIds.push(orderedItems[i].servid);
                    }
                    
                    return orderedItemsIds;
                }
                
                function getHiddenLinks_<xsl:value-of select="$uniqueId"/>()
                {
                    return $j("#unselected-links-<xsl:value-of select="$uniqueId"/> li>a[data-serverid]").map(function() {return $j(this).attr("data-serverid");}).get();
                }
                
                var orderedItemIds_<xsl:value-of select="$uniqueId"/> = getSelectedLinks_<xsl:value-of select="$uniqueId"/>();
                var hiddenItemIds_<xsl:value-of select="$uniqueId"/> = getHiddenLinks_<xsl:value-of select="$uniqueId"/>();
                
		        function saveUserPrefs_<xsl:value-of select="$uniqueId"/>()
		        {
				    var orderedItemsIds = getSelectedLinks_<xsl:value-of select="$uniqueId"/>();
		          
		            var hidden = getHiddenLinks_<xsl:value-of select="$uniqueId"/>();
		            
		            if (orderedItemsIds.toString() != orderedItemIds_<xsl:value-of select="$uniqueId"/>.toString() || hidden.toString() != hiddenItemIds_<xsl:value-of select="$uniqueId"/>.toString())
		            {
		                orderedItemIds_<xsl:value-of select="$uniqueId"/> = orderedItemsIds;
		                hiddenItemIds_<xsl:value-of select="$uniqueId"/> = hidden;
		                
			            var siteUriPrefix = '<xsl:value-of select="ametys:siteUriPrefix()" />';
			            var zoneItemId = '<xsl:value-of select="ametys:zoneItemId()" />';
			            var lang = '<xsl:value-of select="ametys:lang()" />';
                        AmetysHelperLinkDirectory.saveUserPrefs(orderedItemsIds, hidden, siteUriPrefix, lang, zoneItemId, null, null);
			        }
		        }
		      
		        function addUserLink_<xsl:value-of select="$uniqueId"/>(title, url, color)
		        {
		            $j.ajax({
		                url: '<xsl:value-of select="ametys:siteUriPrefix()"/>/_plugins/link-directory/add-user-link',
		                data: {
		                    siteName: "<xsl:value-of select="ametys:site()"/>",
		                    lang: "<xsl:value-of select="ametys:lang()"/>",
		                    title: title,
		                    url: url,
		                    color: color,
                            themes: "<xsl:value-of select="@custom-theme" />"
		                },
		                method: 'POST',
		                success: addUserLinkCb_<xsl:value-of select="$uniqueId"/>,
		                error: function(data) {alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_ERROR" i18n:catalogue="plugin.link-directory"/>");}
		            });
		        };
		        function addUserLinkCb_<xsl:value-of select="$uniqueId"/>(data)
		        {
		            var result = typeof data === 'object' ? data : JSON.parse(data);
		            var error = result.error;
		            
		            switch (error)
		            {
		                case "none":
			                var form = $j("#data-add-new-item-form-<xsl:value-of select="$uniqueId"/> [data-add-new-item-form]");
                            form.find("input[name='linkId']").val(result.id);
                            form.find("input[name='linkId']").trigger("change");
                            form.find("input[name='favicon']").val(result.picture.viewUrl);
                            form.find("input[name='favicon']").trigger("change");
			                form.submit();
<!-- 		                    //save the order with the new link -->
<!-- 		                    saveUserPrefs_<xsl:value-of select="$uniqueId"/>() -->
			                break;
                        case "already-exists":
                            alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_ERROR_ALREADY_EXISTS" i18n:catalogue="plugin.link-directory"/>");
                            break;
		                default:
		                    alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_ERROR_CREATE" i18n:catalogue="plugin.link-directory"/>");
		            }
		        }
                
                function deleteLink_<xsl:value-of select="$uniqueId"/>(event, target)
                {
                    var linkId = $j(target).find("a[data-serverid]").attr("data-serverid");
                    if (linkId != null &amp;&amp; linkId != "")
                    {
                        AmetysHelperLinkDirectory.removeUserLinks([linkId], "<xsl:value-of select="ametys:siteUriPrefix()"/>", null, null, null);
                    }
                };
                
                function deactivateLink_<xsl:value-of select="$uniqueId"/>(event, target)
                {
                    saveUserPrefs_<xsl:value-of select="$uniqueId"/>();
                };

                function activateLink_<xsl:value-of select="$uniqueId"/>(event, target)
                {
                    saveUserPrefs_<xsl:value-of select="$uniqueId"/>();
                };

                function moveLink_<xsl:value-of select="$uniqueId"/>(event, target)
                {
                    saveUserPrefs_<xsl:value-of select="$uniqueId"/>();
                };
                
                 $j('#data-add-new-item-form-<xsl:value-of select="$uniqueId"/> button[data-add-new-item-field-submit]').on('click', function(event) {
	                var form = $j("#data-add-new-item-form-<xsl:value-of select="$uniqueId"/> [data-add-new-item-form]");
                    form.find("input[name='linkId']").val("");//reset the ID
                    form.find("input[name='favicon']").val("");//reset the favicon
	                var href = form.find("input[data-add-new-item-field-url]").val();
	                var title = form.find("input[data-add-new-item-field-title]").val();
	                var color = form.find("input:checked[data-add-new-item-field-color]").attr("data-color-id");
	                
	                // This test is here to avoid to show the message during typing
	                var hrefregex = new RegExp('^https?:\/\/.+');
	                
	                if (href == null || !hrefregex.test(href))
	                {
	                    $j('#data-add-new-item-form-<xsl:value-of select="$uniqueId"/> .ametys-field-group__error-message').show();
	                }
	                else
	                {
	                $j('#data-add-new-item-form-<xsl:value-of select="$uniqueId"/> .ametys-field-group__error-message').hide();
	                    addUserLink_<xsl:value-of select="$uniqueId"/>(title, href, color);
	                }
	                
	                event.preventDefault();
	                return false;
                });
                
              $j(window).on('resize', function () {
                $j('#tool-<xsl:value-of select="$uniqueId"/>').HSAmetysTools('update');
              });
		</script>
	</xsl:template>
    
    <xsl:template name="action-top"><span class="ametys-tools-list__action"></span></xsl:template>
    <xsl:template name="action-bottom"/>
    
    <xsl:template match="link" mode="config">
        <xsl:param name="extra" select="false()"/>
        
       <li class="ametys-tools-list__item" data-ametys-link-id="{$uniqueId}-{@id}">
           <xsl:choose>
                <xsl:when test="$extra"><xsl:attribute name="data-extra-list-item"></xsl:attribute></xsl:when>
                <xsl:otherwise><xsl:attribute name="data-list-item"></xsl:attribute></xsl:otherwise>
           </xsl:choose>
           <xsl:if test="@userLink = 'true'">
               <xsl:attribute name="data-app-type">custom</xsl:attribute>
           </xsl:if>
           <xsl:if test="@disabled = 'true'">
                <xsl:attribute name="data-app-disabled">true</xsl:attribute>
            </xsl:if>
            <a data-list-link="" class="ametys-tools-list__link" data-serverid="{@id}" data-ametys-link-role="link">
              <xsl:apply-templates select="." mode="app-href-attr"/>
              <xsl:apply-templates select="." mode="app-title-attr"/>
              <xsl:apply-templates select="." mode="app-target-attr"/>
              
              <xsl:apply-templates select="." mode="app-icon"/>
                                              
              <span class="ametys-tools-list__title">
                <xsl:value-of select="@title"/>
              </span>
              
              <xsl:call-template name="broken-status"/>
              <xsl:call-template name="new-status-bottom"/>
              
              <xsl:call-template name="link-dynamic-info">
                <xsl:with-param name="uniqueId" select="$uniqueId" />
              </xsl:call-template>
              
               <!-- Delete action -->
               <xsl:call-template name="action-bottom"/>  
             </a>
        </li>
    </xsl:template>
    
    <xsl:template name="broken-status">
        <xsl:if test="@status = 'BROKEN'">
            <span class="ametys-tools-list__broken" title="skin.{$skin}:SKIN_LINKDIRECTORY_STATUS_BROKEN" i18n:attr="title">
                <span class="material-icons warning"></span>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="new-status-top">
        <xsl:call-template name="new-status"/>
    </xsl:template>
    
    <xsl:template name="new-status-bottom"/>
    
    <xsl:template name="new-status">
        <xsl:if test="@status = 'NEW'">
            <span class="ametys-tools-list__new"><i18n:text i18n:key="SKIN_LINKDIRECTORY_STATUS_NEW" i18n:catalogue="skin.{$skin}"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="app-href-attr">
        <xsl:attribute name="href">
            <xsl:choose>
                <xsl:when test="@disabled">javascript:void(0)</xsl:when>
                <xsl:when test="@urlType = 'PAGE'">
                    <xsl:value-of select="resolver:resolve('page', @url)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@url"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template match="link" mode="app-title-attr">
        <xsl:attribute name="title">
            <xsl:choose>
                <xsl:when test="@disabled"><xsl:value-of select="concat('skin.', $skin, ':SKIN_USER_MENU_LINK_DIRECTORY_INTERNAL_ONLY')"/></xsl:when>
                <xsl:when test="@alternative != ''"><xsl:value-of select="@alternative"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:if test="@disabled">
            <xsl:attribute name="i18n:attr">title</xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="app-target-attr">
        <xsl:if test="@urlType != 'PAGE' and not(@disabled)"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="app-icon">
        <xsl:param name="height" select="30"/>
        <xsl:param name="width" select="30"/>
                                
        <span class="ametys-tools-list__icon">
            
            <!-- Delete action -->
            <xsl:call-template name="action-top"/>
            
            <xsl:choose>
                <xsl:when test="@pictureType = 'glyph'">
                    <span class="ametys-tools-list__icon-content ametys-favorites-list__icon_left {@pictureGlyph}" style="font-size: {$height}px;"></span>
                </xsl:when>
                <xsl:when test="@pictureType != ''">
                    <xsl:variable name="id">
                        <xsl:choose>
                            <xsl:when test="@pictureType = 'resource'">
                                <xsl:value-of select="@pictureId"/>
                            </xsl:when>
                            <xsl:when test="@pictureType = 'external'">
                                <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:variable>
                    <span class="ametys-tools-list__icon-content">
                        <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 30, 30)}" alt="{@pictureAlternative}"/>
                    </span>
                </xsl:when>
                <xsl:otherwise>
                    <span class="ametys-tools-list__icon-content UOI"><xsl:value-of select="substring(@title, 0, 3)"/></span>
                </xsl:otherwise>
            </xsl:choose>
              
            <xsl:call-template name="new-status-top"/>
        </span>
    </xsl:template>
</xsl:stylesheet>       
