<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              exclude-result-prefixes="ametys docbook resolver"
                              extension-element-prefixes="text">

     <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
     
     <xsl:template name="common-content-body-content">
        <xsl:call-template name="content"/>
    </xsl:template>
    
    <xsl:template name="content">
        <div>
            <a>
                <xsl:call-template name="content-link-class-attribute"/>
                <xsl:call-template name="content-link-attribute"/>
                
                <xsl:call-template name="content-image"/>
                
                <xsl:call-template name="content-icon"/>
            </a>
            
            <xsl:call-template name="content-title"/>
        </div>
        
        <xsl:call-template name="content-additional"/>
        <xsl:call-template name="content-js"/>
    </xsl:template>
    
    <xsl:template name="content-link-class-attribute">
        <xsl:attribute name="class">ametys-webtv-list__item_link ametys-webtv--play</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-link-attribute">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <xsl:attribute name="href"><xsl:value-of select="resolver:resolve('page', $page-id, false)"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="href">#</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-title">
         <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-webtv-list__item_text">
                    <xsl:value-of select="metadata/title"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <span class="ametys-webtv-list__item_text">
                    <xsl:value-of select="metadata/title"/>
                </span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustration/image"/>
                    <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                    <xsl:with-param name="maxWidth" select="'239'"/>
                    <xsl:with-param name="maxHeight" select="'261'"/>
                    <xsl:with-param name="class" select="'ametys-document__img ametys-document__img--play'"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-document__img ametys-document__img--play">
                    <xsl:call-template name="content-default-image"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
     
    <xsl:template name="content-default-image">
        <div class="content-illustration">
            <img src="{ametys:skinURL('zones/index-web/img/web7.jpg')}" alt=""/>
        </div>
    </xsl:template>
    
    <xsl:template name="content-icon"/>
    <xsl:template name="content-additional"/>
    <xsl:template name="content-js"/>
     
</xsl:stylesheet>