<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
    <xsl:import href="plugin:multimedia://stylesheets/content/video/video-main.xsl"/>		
	
	<xsl:variable name="common-content-css-class-name">main-view video ametys-mb-60</xsl:variable>
    
    <xsl:template name="custom-content-css">
         <link rel="stylesheet" href="{ametys:skinURL('zones/main-video/scss/main.css')}" />
    </xsl:template>
    
	<xsl:template name="common-content-body-content">
        <div class="ametys-mainvideo">
            <xsl:call-template name="content-description"/>
	        
            <xsl:call-template name="video-player"/>
	    </div>
    </xsl:template>
    
    <xsl:template name="content-description">
        <xsl:if test="metadata/content">
          <div class="ametys-mainvideo_paragraph">
            <xsl:call-template name="common-content-body-content-rich"/>
          </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
