<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
	
    
    <xsl:template name="footer">
        <footer class="ametys-footer ametys-footer_with-sidebar-left">
            <div class="d-md-flex justify-content-md-between">
                
                <xsl:call-template name="footer-left"/>
                
                <xsl:call-template name="footer-middle"/>
            
                <xsl:call-template name="footer-right"/>
            </div>
        </footer>
    </xsl:template>	
    
    <xsl:template name="footer-left">
        <xsl:variable name="partnersPage" select="ametys:findPagesIdsByTag(ametys:site(),ametys:lang(),'FOOTER_LINKS_PARTNERS')"/>
                        
        <xsl:if test="/cms/inputData/sitemap/page[@PLUGIN_TAGS_FOOTER_LINKS_OTHERS] or $partnersPage">
            <nav class="ametys-footer-left">
                <ul class="ametys-footer-nav">
                    <xsl:if test="$partnersPage">
                        <li>
                            <a href="{resolver:resolve('page', $partnersPage/@id)}" class="btn btn-outline-light mb-3"><xsl:value-of select="ametys:pageLongTitle($partnersPage/@id)" /></a>
                        </li>                   
                    </xsl:if>
                    <xsl:for-each select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_FOOTER_LINKS_OTHERS]/page">
                        <li class="ametys-footer-nav__item">
                            <a class="ametys-footer-nav__link" href="{resolver:resolve('page', @sitemap:id)}">
                                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                                    <xsl:call-template name="external-link-attributes">
                                        <xsl:with-param name="title" select="@sitemap:title"/>
                                        <xsl:with-param name="className">ametys-footer-nav__link external</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:if>
                                <xsl:value-of select="@sitemap:title" />
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </nav>
        </xsl:if>   
    </xsl:template>
    
    <xsl:template name="footer-middle">
         <div class="ametys-footer-middle">
            <!-- Social links -->
            <xsl:call-template name="footer-social-links"/>
            
            <!-- Copyright -->
            <xsl:call-template name="footer-copyright"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-social-links">
        <xsl:if test="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link">
            <ul class="ametys-footer-social">
                <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link" mode="footer">
                   <xsl:with-param name="uniqueId" select="$uniqueId"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer-copyright">
        <small class="ametys-footer__copy">
            <i18n:text i18n:key="SKIN_FOOTER_COPYRIGHT_1" i18n:catalogue="skin.{$skin}"/><br/>
            <i18n:text i18n:key="SKIN_FOOTER_COPYRIGHT_2" i18n:catalogue="skin.{$skin}"/>
        </small>
    </xsl:template>
    
    <xsl:template name="footer-right">
        <div class="ametys-footer-right">
            <!-- Logo -->
            <xsl:call-template name="footer-logo"/>
            <!-- Address -->
            <xsl:call-template name="footer-address"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-address">
        <small class="ametys-footer__copy">
          <i18n:text i18n:key="SKIN_FOOTER_ADDRESS_1" i18n:catalogue="skin.{$skin}"/>
          <br/>
          <i18n:text i18n:key="SKIN_FOOTER_ADDRESS_2" i18n:catalogue="skin.{$skin}"/>
        </small>
    </xsl:template>
    
    <xsl:template name="footer-logo">
            <a class="ametys-footer-logo" href="/">
              <img class="ametys-footer-logo__img" src="{ametys:skinURL('templates/common/img/logo-white.png')}" height="110" alt="Intra" />
            </a>
    </xsl:template>
    
    <xsl:template name="scroll-top">
        <button class="up" title="skin.{$skin}:SKIN_SCROLL_TO_TOP" i18n:attr="title">
            <i class="fas fa-arrow-up" aria-hidden="true"></i>
        </button>
    
        <script>
            $j(document).scroll(function () {
                const scroll = $j(window).scrollTop();
    
                if (scroll == 0) {
                    $j('.up').fadeOut();
                } else {
                    $j('.up').fadeIn();
                }
            });
    
            $j(".up").on('click', function () {
               window.scrollTo({ top: 0, behavior: 'smooth' });
            });
        </script>
    </xsl:template>
</xsl:stylesheet>