<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:variable name="openFlipbookInPopup" select="ametys:serviceViewParameter('openFlipbookInPopup')" />
    
    <xsl:variable name="common-service-css-class-name">kiosk <xsl:value-of select="$template"/></xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
	    <link rel="stylesheet" href="{ametys:skinURL('zones/index-kiosk/scss/main.css')}" />
    </xsl:template> 
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_WEBTV" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <i class="card-header__icon icofont-read-book"></i>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:choose>
            <xsl:when test="$template = 'index'">
                <div class="card mb-4 {$override-card-styles}">
                    <xsl:call-template name="header"/>
                    
                    <xsl:call-template name="search-results"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="search-results"/>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:if test="$openFlipbookInPopup = 'true'">
            <xsl:call-template name="kiosk-popup"/>
            <xsl:call-template name="kiosk-popup-js"/>
        </xsl:if>
        
        <script type="text/javascript">
            $j(function(){
            
                $j.HSCore.components.HSCarousel.init("#kiosk-<xsl:value-of select="$uniqueId" />");
        
                $j("#sidebar").on("transitionend webkitTransitionEnd oTransRsearchitionEnd otransitionend MSTransitionEnd",
                function () {
                    $j("#kiosk-<xsl:value-of select="$uniqueId" />").slick("setPosition");
                });
        
                $j.HSCore.components.HSPopup.init(".ametys-kiosk__link");
            });
        </script>
    </xsl:template>
    
    <xsl:template name="hits">
		<ul data-ametys-search-role="hits" id="kiosk-{$uniqueId}" class="ametys-kiosk"
			data-slides-show="4" data-slides-scroll="1" data-infinite="true">
            
            <xsl:call-template name="data-responsive-attribute"/>
			
             <xsl:for-each select="/search/hits/hit">
              	<xsl:call-template name="hit"/>
            </xsl:for-each>
         </ul>
    </xsl:template>
    
    <xsl:template name="data-responsive-attribute">
        <xsl:attribute name="data-responsive">
        <xsl:text>[{
                "breakpoint": 992,
                "settings": {
                  "slidesToShow": 3
                }
              }, {
                "breakpoint": 768,
                "settings": {
                  "slidesToShow": 2
                }
              }]</xsl:text>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-kiosk__item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="kiosk-popup">
        <div id="kiosk-overlay-{$uniqueId}" class="ametys-overlay-modal" onclick="closeKioskPopup{$uniqueId}()"></div>
            
        <div id="kiosk-popup-{$uniqueId}" class="ametys-modal ametys-modal-fullscreen" role="dialog" aria-modal="true">
            <button class="ametys-modal-close" onclick="closeKioskPopup{$uniqueId}()" title="skin.{$skin}:SERVICE_KIOSK_CLOSE_DIALOG" i18n:attr="title"><i class="fas fa-times" aria-hidden="true"></i></button>
            <div class="ametys-modal-content">
                <iframe allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%; height: 100%" ></iframe>
            </div>
        </div>
    </xsl:template>  
    
    
    <xsl:template name="kiosk-popup-js">
        <script type="text/javascript">
            const closeKioskPopupOnEscape<xsl:value-of select="$uniqueId"/> = (event) => {
                if (event.key === "Escape") {
                  closeKioskPopup<xsl:value-of select="$uniqueId"/>();
                }
            };
            
            var kioskPopupInvoker<xsl:value-of select="$uniqueId"/> = null;
            
            function openKioskPopup<xsl:value-of select="$uniqueId"/>(item)
            {
                kioskPopupInvoker<xsl:value-of select="$uniqueId"/> = $j(item);
            
                let $dialog = $j('#kiosk-popup-<xsl:value-of select="$uniqueId"/>');
                $dialog.find('iframe').attr('src', $j(item).attr("data-href"));
                $dialog.find('iframe').attr("title", $j(item).attr("title"));
                $dialog.attr("aria-label", $j(item).attr("title"));
                $dialog.addClass('active');
                $j('#kiosk-overlay-<xsl:value-of select="$uniqueId"/>').addClass('active');
                
                // Trap focus into modal
                AmetysFront.Accessibility.trapFocus($dialog.get(0), true);
                // Close modal when ESCAPE key is pressed
                $dialog.on('keydown', closeKioskPopupOnEscape<xsl:value-of select="$uniqueId"/>);
                
                // Disable scroll on main page
                $j('body').css('overflow', 'hidden');
            }
            function closeKioskPopup<xsl:value-of select="$uniqueId"/>()
            {
                let $dialog = $j('#kiosk-popup-<xsl:value-of select="$uniqueId"/>');
                $dialog.removeClass('active');
                $j('#kiosk-overlay-<xsl:value-of select="$uniqueId"/>').removeClass('active');
                
                $dialog.find('iframe').attr('src', '');
                
                AmetysFront.Accessibility.untrapFocus($dialog.get(0));
                $dialog.off('keydown', closeKioskPopupOnEscape<xsl:value-of select="$uniqueId"/>);
                
                // Re-enable scroll on main page
                $j('body').css('overflow', 'inherit');
                
                kioskPopupInvoker<xsl:value-of select="$uniqueId"/>.trigger('focus');
                kioskPopupInvoker<xsl:value-of select="$uniqueId"/> = null;
            }
            
            $j(function(){
            
                // Move popup to body
                $j("#kiosk-popup-<xsl:value-of select="$uniqueId"/>").appendTo(document.body);
                $j("#kiosk-overlay-<xsl:value-of select="$uniqueId"/>").appendTo(document.body);
                
                // Change href by onclick function
                $j('#kiosk-<xsl:value-of select="$uniqueId"/> .ametys-kiosk__item a').each((index, item) => {
                    $j(item).attr("data-href", $j(item).attr("href"));
                    $j(item).removeAttr("href");
                    $j(item).on('click', function()  {openKioskPopup<xsl:value-of select="$uniqueId"/>(this)});
                })
            });
        </script>
    </xsl:template> 
</xsl:stylesheet>