$j(document).on('scroll', function () {
    const scroll = $j(window).scrollTop();

    if (scroll == 0) {
        $j('header[role=banner]').removeClass('sticky');
    } else {
        $j('header[role=banner]').addClass('sticky');

    }
});

function openSearchMobile() {
    $j('.search-mobile').addClass('open');
}
function closeSearchMobile() {
    $j('.search-mobile').removeClass('open');
}

const hideMobileMenuOnEscape = (event) => {
    if (event.key === "Escape") {
      closeMenuMobile();
    }
};
            
function openMenuMobile(e) {
    $j(e).attr('aria-expanded', 'true');
    $j('.menu-mobile').addClass('open');
    $j('header[role=banner]').addClass('menuMobileOpen');
    $j('.ametys-zone-access').appendTo('.access-mobile');
    $j('.menu-mobile .ametys-zone-access').removeClass('access-home');
    
    // Trap focus into menu
    AmetysFront.Accessibility.trapFocus($j('.menu-mobile').get(0), true);
    // Close menu when ESCAPE key is pressed
    $j('.menu-mobile').get(0).addEventListener('keydown', hideMobileMenuOnEscape);
}
function closeMenuMobile() {
    $j('.burger button').attr('aria-expanded', 'false');
    $j('header[role=banner]').removeClass('menuMobileOpen');
    $j('.menu-mobile').removeClass('open');
    $j('.menu-mobile .submenu').removeClass('open');
    
    // Untrap focus into modal
    AmetysFront.Accessibility.untrapFocus($j('.menu-mobile').get(0));
    $j('.menu-mobile').get(0).removeEventListener('keydown', hideMobileMenuOnEscape);
    
    $j('.burger button').trigger('focus');
}

function closeLevel(el, level) {
    $j(el).closest('.submenu').removeClass('open');
    $j(el).closest('.submenu').closest('.submenu.open').find('> .return').show(); // show back button of opened submenu
    
    // Focus open menu invoker
    $j(el).closest('.submenu').prev('button').trigger('focus');
    $j(el).closest('.submenu').prev('button').attr("aria-expanded", false);
}

function openSearchInput() {
    $j('.open-search-input > button').attr('aria-expanded', 'true');
    $j('.search-input').addClass('active');
    $j('.open-search-input > button').hide();
    $j('.close-search-input').show();
    $j('.overlay-search-input').addClass('active');
    $j('header[role=banner]').addClass('have-search-input');
    setTimeout(function () {
        $j('.search-input input[type="text"]').trigger('focus');
    }, 50);
}

function closeSearchInput() {
    $j('.open-search-input > button').attr('aria-expanded', 'false')
    $j('.search-input').removeClass('active');
    $j('.open-search-input > button').show();
    $j('.close-search-input').hide();
    $j('.overlay-search-input').removeClass('active');
    $j('header[role=banner]').removeClass('have-search-input');
    $j('.open-search-input > button').trigger('focus');
}

$j(function () {

    $j(".menu-mobile .has-submenu > button:not(.return)").on('click', function (e) {
	    e.preventDefault();
        let $this = $j(this);
        $this.attr("aria-expanded", true);
	    $this.siblings(".submenu").addClass('open'); // open submenu
        
        $j(".menu-mobile .return").hide(); // hide all back buttons
        $this.siblings(".submenu").find('> .return').show(); // show back button of opened submenu
	    
        setTimeout(function() {
            $this.siblings(".submenu").find('> .return').trigger('focus'); // focus back button (waiting css animation)
        }, 20);
	});
});


function addAlert() {

    setTimeout(function () {
        $j('.alert').show();
        $j('body').addClass('has-alert');

        if ($j('body').hasClass('has-alert')) {
            const alertHeight = $j('.alert').height() + 12;
            $j('header[role=banner]').css('top', `${alertHeight}px`);
        }

        $j(document).on('scroll', function () {
            const scroll = $j(window).scrollTop();
            var alertHeight = $j('.alert').height();
            if ($j('body').hasClass('has-alert')) {
                if (scroll - 12 < alertHeight) {
                    alertHeight = alertHeight + 12 - scroll;
                    $j('header[role=banner]').css('top', `${alertHeight}px`);
                } else {

                    $j('header[role=banner]').css('top', `0px`);
                }
            }
        });

        $j(window).on('resize', function () {
       // if windows width > 1400
            const scroll = $j(window).scrollTop();
            var alertHeight = $j('.alert').height();
            if ($j('body').hasClass('has-alert')) {
                if (scroll - 12 < alertHeight) {
                    alertHeight = alertHeight + 12 - scroll;
                    $j('header[role=banner]').css('top', `${alertHeight}px`);
                } else {

                    $j('header[role=banner]').css('top', `0px`);
                }
            }
        });

    }, 20);
}

function removeAlert() {
    $j('.alert').hide();
    $j('body').removeClass('has-alert');
    $j('header[role=banner]').css('top', `0px`);
}

$j(window).on( 'keyup', function( e ) {
    const el = e.target;
    if( e.which == 9 /* TAB */) {
        if ($j('.nav-perso.open').length == 1 /*nav perso is open*/ && $j(el).parents('.nav-perso').length == 0 /*TAB outside nav perso*/ && $j(el).parents('[role="dialog"]').length == 0 /*not in modal*/ ){ 
            $j('.nav-perso').removeClass('open');
            $j('.overlayNav').removeClass('active');
            $j('.espace-perso-btn-in-menu').removeClass('open');
            $j('.espace-perso-btn-in-menu').attr("aria-expanded", "false");
            $j('.espace-perso-btn').removeClass('open');
            $j('.espace-perso-btn').attr("aria-expanded", "false");
            setTimeout(function () {
                $j('.espace-perso-btn').trigger('focus');
            }, 100); /* timeout because of css animation */
        }
    }
} );

// Ajust height on main menu according visible levels
function adjustMenuHeight()
{
    var $submenu = $j(".links.desktop > .has-submenu.open .submenu");
    
    var maxHeight = $submenu.find('.list-lvl-one').innerHeight();
    $submenu.find('.has-submenu.open > .level').each(function(index) {
        var height = $j(this).height() + 65 /* padding-top */;
        if (height > maxHeight)
        {
            maxHeight = height;
        }
    });
    
    if (maxHeight > 0)
    {
        $submenu.height(maxHeight);
        $submenu.find(".has-submenu.open > .level").each(function (){
            var padding = Math.max(0, maxHeight - $j(this).height() - 65 /* padding-top */);
            $j(this).css('padding-bottom', padding + "px");    
        });
    }
}

$j(document).ready(function () {
    
   // Close main menu or notification link dropdown on escape
   const espaceKeySubmenu = (event) => {
        if (event.key === "Escape") {
            var $currentOpenMenu = $j(".links.desktop > .has-submenu.open");
            $j(".has-submenu").removeClass('open');
            $j(".open-submenu-sr").removeClass('expanded');
            $j(".open-submenu-sr").attr("aria-expanded", false);
            $j(".submenu .link a").removeClass("active");   
            
            $currentOpenMenu.find("> a").trigger('focus');
            
            var $currentOpenNotif = $j(".top-link .dropdown.openAccessibility");
            closeNotification($currentOpenNotif.closest('.top-link'), false);
            $currentOpenNotif.closest('.top-link').find("> a").trigger('focus');
        }
    }
    document.addEventListener('keydown', espaceKeySubmenu); 
    
    // Accessibility: handle open submenu with keyboard navigation
    $j('nav.left .links .has-submenu .open-submenu-sr').on('click', function() {
        
        const isOpen = $j(this).attr('aria-expanded') === 'true' || false;
        const isSectionBtn = $j(this).closest('.has-submenu').parent(".links").length == 1;
        
        if (!isOpen)
        {
            if (isSectionBtn)
	        {
	            // Close opened sections
	            $j('nav.left .links > .has-submenu.open').each(function() {
	                $j(this).removeClass('open');
                    $j(this).find(".has-submenu").removeClass('open');
                    $j(this).find(".open-submenu-sr").removeClass('expanded');
		            $j(this).find(".open-submenu-sr").attr("aria-expanded", false);
		            $j(this).find(".link a").removeClass("active");
	            })
	        }
        
            $j(this).closest('.has-submenu').addClass('open');
            $j(this).attr("aria-expanded", true);
            $j(this).addClass("expanded");
            $j(this).prev().addClass("active");
        }
        else
        {
            // close submenu and all child submenus
            var $parentUL = $j(this).closest('.has-submenu').parent();
            $parentUL.find(".has-submenu").removeClass('open');
            $parentUL.find(".open-submenu-sr").removeClass('expanded');
            $parentUL.find(".open-submenu-sr").attr("aria-expanded", false);
            $parentUL.find(".link a").removeClass("active");
        }
        
        // Ajust submenu height
        adjustMenuHeight();
    });
    
    // open/show level N+1
    $j('nav.left .links .has-submenu').on('mouseenter', function () {
        $j(this).addClass("open");
        $j(this).find("button").attr("aria-expanded", true);
        $j(this).find("button").addClass("expanded");
        //$j(this).find("> .link a").addClass("active");
        // Ajust submenu height
        adjustMenuHeight();
    });
    
    // close/hide level N+1
    $j('nav.left .links .has-submenu').on('mouseleave', function () {
        $j(this).removeClass("open");
        $j(this).find("has-submenu").removeClass("open");
        $j(this).find(".open-submenu-sr").attr("aria-expanded", false);
        $j(this).find(".open-submenu-sr").removeClass("expanded");
        //$j(this).find(".link a").removeClass("active");
        // Ajust submenu height
        adjustMenuHeight();
    });
    
    function closeNotification($link, focus)
    {
        $link.find('.dropdown').removeClass('openAccessibility');
        let $btn = $link.find('.open-notification-sr');
        $btn.removeClass('expanded');
        $btn.attr("aria-expanded", false);
        $link.find('a').removeClass("active");
        $link.off('keydown', closeNotificationDropdownOnEscape);
        $btn.off('blur', closeNotificationDropdownOnBlur);
        
        if (focus)
        {
            $btn.trigger('focus');
        }
    }
    // Close notification dropdown on escape
   const closeNotificationDropdownOnEscape = (event) => {
        if (event.key === "Escape") {
            var $currentOpenNotif = $j(".top-link .dropdown.openAccessibility");
            closeNotification($currentOpenNotif.closest('.top-link'), true);
        }
    }
    
    const closeNotificationDropdownOnBlur = (event) => {
        let $btn = $j(event.target);
        closeNotification($btn.closest('.top-link'), false);
    }
    
    // Accessibility: handle open notifications with keyboard navigation
    $j('.top-link .open-notification-sr').on('click', function() {
        let $btn = $j(this),
            $link = $btn.closest('.top-link'),
            $dropdown = $link.find('.dropdown');
            
        const isOpen = $btn.attr('aria-expanded') === 'true';
         
        if (!isOpen)
        {
            $btn.attr("aria-expanded", true);
            $btn.addClass("expanded");
            $dropdown.addClass('openAccessibility');
            $link.on('keydown', closeNotificationDropdownOnEscape);
            $link.find('a').addClass("active");
            $btn.on('blur', closeNotificationDropdownOnBlur);
        }
        else
        {
            closeNotification($link, false);
        }
    });
    
    $j('.top-link').on( "mouseenter", function() {
        $j(this).find('.dropdown').addClass('openAccessibility');
    }).on( "mouseleave", function() {
        $j(this).find('.dropdown').removeClass('openAccessibility');
    })
});


