<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        extension-element-prefixes="resolver">
	
	<xsl:import href="plugin:syndication://pages/services/feed/feed2xhtml_1.2.xsl"/>
	
	<xsl:variable name="common-service-css-class-name">ametys-zone-flux</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title"/> 
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div class="flux">
            <!-- Title -->
            <xsl:call-template name="feed-title"/>
        	
        	<!-- Handle my RSS feed form -->
            <xsl:call-template name="feed-config-form" />
            
           <!-- Errors on customs feed -->
            <xsl:if test="/rssFeeds/feed-error-custom">
                <div class="error">
                    <ul>
                        <xsl:for-each select="/rssFeeds/feed-error-custom">
                           <xsl:call-template name="feed-error-custom" />
                        </xsl:for-each>
                    </ul>
                </div>
            </xsl:if>
            
            <!-- Errors on feed (BO mode only) -->
            <xsl:if test="/rssFeeds/feed-error">
                <div>
                    <xsl:for-each select="/rssFeeds/feed-error">
                       <xsl:call-template name="feed-error" />
                    </xsl:for-each>        
                </div>
            </xsl:if>
            
            <!-- RSS entries -->
            <xsl:if test="/rssFeeds/feed/entry">
                <ul class="list">
    		        <xsl:for-each select="/rssFeeds/feed/entry">
    		            <xsl:sort select="@date" order="descending"/>
    			        <xsl:call-template name="entry"/>
    		        </xsl:for-each>
    	        </ul>
            </xsl:if>
    	</div>
    </xsl:template>   
    
    <xsl:template name="feed-title">
        <div class="title">
             <h2><xsl:value-of select="$header"/></h2>
             <xsl:call-template name="feed-config-link"/>
         </div>
    </xsl:template>
    
    <xsl:template name="configure-links-btn">
        <a class="config-link" aria-haspopup="dialog" onclick="javascript:feed_config_form_popup_{$uniqueId}(this)" href="#">Configurer<i class="fa fa-cog"></i></a>
    </xsl:template>
    
    <xsl:template name="entry"> 
		<li class="list-item">
			<div class="icon">
               <i class="fa fa-rss" aria-hidden="true"></i>
           </div>
			<a href="{@link}" target="_blank">
				<div class="text">
		            <xsl:call-template name="item-title"/>
		            <xsl:call-template name="item-description"/>
	            </div>
            </a>
		</li>
	</xsl:template>
	
	<!-- Title of RSS entry -->
    <xsl:template name="item-title">
   	   <span class="title"><xsl:value-of select="../@title"/></span>
    </xsl:template>
    
    <!-- Description of RSS entry -->
    <xsl:template name="item-description">
    	<p><xsl:value-of select="@title"/></p>  
    </xsl:template>    

</xsl:stylesheet>		
