<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">

    <xsl:import href="skin://services/link-directory/pages/services/directory/utils/thumbnails_utils.xsl"/>
    
    <xsl:template name="acces-rapides">
        <xsl:param name="height">20</xsl:param>
        <xsl:param name="width">20</xsl:param>
        
        <xsl:if test="/cms/inputData/linkDirectory/links/link[themes/theme/@id='ACCES_RAPIDES']">
            <div class="ametys-cms-service ametys-zone-access link-directory">
                <xsl:call-template name="acces-rapides-title"/>
                
                <xsl:call-template name="acces-rapides-ul">
                    <xsl:with-param name="height" select="$height"/>
                    <xsl:with-param name="width" select="$width"/>
                </xsl:call-template>
           </div>
        </xsl:if>
    </xsl:template>
          
    <xsl:template name="acces-rapides-title">
        <h2 class="service-title"><i18n:text i18n:key="SKIN_ACCESS_RAPIDES_LABEL" i18n:catalogue="skin.{$skin}"/></h2>
    </xsl:template>
    
    <xsl:template name="acces-rapides-ul">
        <xsl:param name="height">20</xsl:param>
        <xsl:param name="width">20</xsl:param>
        
        <ul>
            <xsl:for-each select="cms/inputData/linkDirectory[@id='accesRapides']/links/link[themes/theme/@id='ACCES_RAPIDES' and not(@disabled)]">
                <xsl:apply-templates select="." mode="acces-rapides">
                    <xsl:with-param name="height" select="$height"/>
                    <xsl:with-param name="width" select="$width"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template match="link" mode="acces-rapides">
        <xsl:param name="height">20</xsl:param>
        <xsl:param name="width">20</xsl:param>
                
        <li>
             <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                        <div class="icon">
                            <xsl:call-template name="link-picture">
                               <xsl:with-param name="height" select="$height"/>
                               <xsl:with-param name="width" select="$width"/>
                            </xsl:call-template>
                        </div>
                        <div class="title">
                            <xsl:call-template name="link-text"/>
                        </div>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                   <a href="{@url}" onclick="window.open(this.href); return false;">
                        <div class="icon">
                            <xsl:call-template name="link-picture">
                               <xsl:with-param name="height" select="$height"/>
                               <xsl:with-param name="width" select="$width"/>
                            </xsl:call-template>
                        </div>
                        <div class="title">
                            <xsl:call-template name="link-text"/>
                        </div>
                   </a> 
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template name="accessibility-links">
		<div class="accessibility">
			<a href="#main-content"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_CONTENT" i18n:catalogue="skin.{$skin}"/></a>
            <xsl:if test="$template != 'index' and $template != 'login' and $template != 'signup'">
                <a href="#search"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_SEARCH" i18n:catalogue="skin.{$skin}"/></a>
            </xsl:if>
		</div>
	</xsl:template>
    
    <xsl:template name="matomo-stats">
        <xsl:variable name="piwikUrl" select="ametys:config('piwik-url')"/>
        <xsl:variable name="piwikId" select="ametys:siteParameter('piwik-id')"/>
        <xsl:variable name="statsEnabled" select="ametys:siteParameter('matomo-live-stats')"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($piwikId) != '' and normalize-space($piwikUrl) != '' and $statsEnabled = 'true' and not(ametys:isEditionMode())">
            <span class="nb-visits" style="display: none" tabindex="0">
                <span class="icon fa-solid fa-eye" aria-hidden="true"></span>
                <span id="nb-visits-multiple"><i18n:text i18n:key="SKIN_MATOMO_STATS_VISITS" i18n:catalogue="skin.{$skin}"/></span>
                <span id="nb-visits-single"><i18n:text i18n:key="SKIN_MATOMO_STATS_VISIT" i18n:catalogue="skin.{$skin}"/></span>
                
                <span class="nb-visits-tooltip sr-only">
                     <i18n:text i18n:key="SKIN_MATOMO_STATS_VISITS_TOOLTIP" i18n:catalogue="skin.{$skin}"/>
                </span>
            </span>
            <script type="text/javascript">
               // Tippy plugin to hide tooltip on ESC
                const hideVisitTooltipOnEsc = {
                  name: 'hideOnEsc',
                  defaultValue: true,
                  fn({hide}) {
                    function onKeyDown(event) {
                      if (event.keyCode === 27) {
                        hide();
                      }
                    }
                    return {
                      onShow() {
                        document.addEventListener('keydown', onKeyDown);
                      },
                      onHide() {
                        document.removeEventListener('keydown', onKeyDown);
                      },
                    };
                  },
                };
                
               $j(function() {
                 AmetysMatomoHelper.getPageData(".nb-visits", "<xsl:value-of select="$site-uri-prefix" />", null, function() {
                    
                    var nbVisits = $j(".nb-visits #nb-visits-multiple [data-matomo='nb-visits']").text();
                    if (nbVisits)
                    {
                        if (Number(nbVisits) == 1)
                        {
                            $j(".nb-visits #nb-visits-multiple").remove();
                        }
                        else
                        {
                            $j(".nb-visits #nb-visits-single").remove();
                        }
                            
                        $j(".nb-visits").show();
                        
                        // Tooltip
                        tippy('.nb-visits', {
                            content: $j(".nb-visits .nb-visits-tooltip").text(), 
                            plugins: [hideVisitTooltipOnEsc]
                        });
                    }
                    else
                    {
                        $j(".nb-visits").remove();
                    }
                });
               });
            </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>