<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="plugin:forms://pages/services/common/admin-dashboard.xsl"/>
    
    <xsl:template name="dashboard">
        <xsl:call-template name="back-to-form" />

        <xsl:call-template name="dashboard-title" />
        
        <xsl:call-template name="dashboard-filters"/>
    
        <xsl:call-template name="dashboard-table" />

        <xsl:apply-templates select="answer" mode="history"/>

        <!-- Actions that need dialog -->
        <xsl:apply-templates select=".//action" mode="action-dialog"/>
    
        <xsl:call-template name="show-answer-popup" />
        
        <xsl:call-template name="show-error-popup" />
        
        <xsl:call-template name="pagination" />
        
        <!-- background overlay for popups -->
        <div class="dashboard-popup-overlay" data-dashboard-popup-overlay="{$uniqueId}" style="display: none;" onclick="onHideDialog_{$uniqueId}()"></div>
    </xsl:template>
    
    <!-- Override to display page number -->
    <xsl:template name="dashboard-title">
        <h3 class="form-title" id="form-title-{substring-after(@formId, 'form://')}">
            <xsl:value-of select="@formTitle" />
            
            <xsl:if test="@page > 1 or @hasNextPage = 'true'">
                <i18n:text i18n:key="SKIN_SERVICES_FORMS_DASHBOARD_PAGE_NUMBER_PREFIX" i18n:catalogue="skin.{$skin}"/><span data-dashboard="page-number"></span>
            </xsl:if>
        </h3>
    </xsl:template> 
    
    <xsl:template match="action[@type='comment']" mode="action-dialog">
        <div class="dashboard-popup" data-dashboard-popup="{$uniqueId}" data-dashboard-comment-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-popup-header-{generate-id()}">
            <h1 class="header" id="dashboard-popup-header-{generate-id()}"><xsl:value-of select="."/></h1>
            
            <div class="innercontent"> 
                <xsl:call-template name="comment-form" />
            </div>
            
            <div class="bottom">
                <button type="button" class="btn" onclick="DashboardHelper.doAction('{$uniqueId}', '{../@formId}', '{../@id}', '{@id}')">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
                <button type="button" class="btn" onclick="onHideActionDialog_{$uniqueId}()">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_CANCEL_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="action[@type='send-mail']" mode="action-dialog">
        <div class="dashboard-popup" data-dashboard-popup="{$uniqueId}" data-dashboard-send-mail-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-popup-header-{generate-id()}">
            <h1 class="header" id="dashboard-popup-header-{generate-id()}"><xsl:value-of select="."/></h1>
            
            <div class="innercontent"> 
                <p><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/></p>
                <xsl:call-template name="send-mail-form" />
            </div>
            
            <div class="bottom">
                <button type="button" class="btn" onclick="DashboardHelper.doAction('{$uniqueId}', '{../@formId}', '{../@id}', '{@id}')">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
                <button type="button" class="btn" onclick="onHideActionDialog_{$uniqueId}()">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_CANCEL_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="action[@type='edit']" mode="action-dialog">
        <div class="dashboard-popup dashboard-edit" data-dashboard-popup="{$uniqueId}" data-dashboard-edit-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-popup-header-{generate-id()}">
            <h1 class="header" id="dashboard-popup-header-{generate-id()}"><xsl:value-of select="."/></h1>
            
            <div class="innercontent">
                <div data-dashboard-edit-values="{../@formId}-{../@id}-{@id}">
                    <!-- Rendered by edit.xsl --> 
                </div>
                
                <xsl:apply-templates select="." mode="action-dialog-loader"/>
            </div>
            
            <div class="bottom">
                <button type="button" class="btn" onclick="DashboardHelper.editFormEntry('{$uniqueId}', '{../@formId}', '{../@id}', '{@id}')">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
                <button type="button" class="btn" onclick="onHideActionDialog_{$uniqueId}()">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_CANCEL_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
