<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        xmlns:math="http://exslt.org/math"
		exclude-result-prefixes="ametys">
	
    <xsl:import href="skin://services/web/pages/services/attachments.xsl"/>
    <xsl:import href="service:nextcloud://stylesheets/helper.xsl"/>
    
        <!-- Used in common.xsl -->
    <xsl:variable name="is-empty" select="not(/Node/*)"/>    
    <xsl:variable name="common-service-name">service-nextcloud-folder</xsl:variable>  
    
    <xsl:variable name="id" select="concat('nextcloud_', substring-after(math:random(), '.'))"/>    
    
    <xsl:template name="common-service-body-empty">
        <xsl:call-template name="common-service-body-nonempty-content-title"/>
        
        <xsl:choose>
            <xsl:when test="/not-connected">
                <xsl:call-template name="connect-button">
                    <xsl:with-param name="uri-prefix" select="$uri-prefix"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="ATTACHMENTS_NO_FILE" i18n:catalogue="skin.{$skin}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="list-folders">
        <xsl:apply-templates select="Node[@type = 'collection']" mode="folder">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="list-files">
        <xsl:apply-templates select="Node[@type = 'resource']" mode="file">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']" mode="file-href-attr">
        <xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
