<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:text="http://ametys.org/text/3.0" 
                              exclude-result-prefixes="docbook resolver ametys"
                              extension-element-prefixes="text">
                              
	<xsl:import href="plugin:news://stylesheets/content/news/news-main.xsl"/>	
	
	<xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
		
        <xsl:if test="$zone != 'default' and ($template = 'index' or $template = 'page' or $template = 'full-page')">
	        <h1 class="ametys-richtext-title-1">
	        	<span class="content-title summary"><xsl:value-of select="$title"/></span>
	            <xsl:if test="$subtitle != ''">
	                <span class="content-subtitle"><xsl:value-of select="$subtitle"/></span>
	            </xsl:if>
	        </h1>
	     </xsl:if>
    </xsl:template>
    
	
	<xsl:template name="common-content-body-content">
     	<!-- Dates -->
        <xsl:if test="(metadata/start-date != '' or metadata/end-date != '') and not(metadata/hide-date = 'true')">
	        <span class="date">
	            <xsl:call-template name="dates">
	                <xsl:with-param name="startDate" select="metadata/start-date"/>
	                <xsl:with-param name="endDate" select="metadata/end-date"/>
	            </xsl:call-template>
            </span>
        </xsl:if>
        
        <xsl:call-template name="common-content-body-content-rich"/>
    </xsl:template> 
	
</xsl:stylesheet>