<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            exclude-result-prefixes="sitemap resolver ametys i18n exslt">

    
    <xsl:import href="skin://stylesheets/search.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/menus.xsl"/>
    
	<xsl:import href="skin://services/link-directory/pages/services/directory/utils/thumbnails_utils.xsl"/>

    <xsl:template name="header">
    	<header role="banner">
			
            <div class="container">
                
                <xsl:call-template name="header-left"/>
                
                <xsl:call-template name="header-icons"/>
                
            </div>
            
			<xsl:call-template name="menu-mobile"/>
            
            <!-- Button to open personal menu -->
            <xsl:call-template name="boutonEspacePerso"/>
            <!-- Personal menu -->
            <xsl:call-template name="right-menu"/>
            <!-- Button to close personal menu -->
            <button aria-expanded="false" class="espace-perso-btn-in-menu" onclick="closeNavPerso()">
                <i18n:text i18n:key="SKIN_ESPACE_PERSO_LABEL" i18n:catalogue="skin.{$skin}"/>
            </button>
            <!-- Overlay when personal menu is open -->
            <div class="overlayNav" onclick="closeNavPerso()"></div>
        </header>
    </xsl:template>
    
    <xsl:template name="boutonEspacePerso">
        <button class="espace-perso-btn" onclick="openNavPerso();" aria-expanded="false">
            <i18n:text i18n:key="SKIN_ESPACE_PERSO_LABEL" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="header-left">
        <nav class="left" role="navigation" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION" i18n:attr="aria-label">
            <!-- Logo -->
            <xsl:call-template name="header-main-logo"/>
            
            <xsl:call-template name="main-menu">
                <xsl:with-param name="device">desktop</xsl:with-param>
            </xsl:call-template>
        </nav>
            
        <!-- For mobile -->
        <div class="left mobile">
            <xsl:call-template name="header-main-logo"/>    
        </div>
    </xsl:template>
    
    <xsl:template name="header-icons">
        <div class="icons">
            <ul>
                <xsl:call-template name="search-button"/>
                
                <xsl:call-template name="top-links"/>
                <xsl:call-template name="alerts"/>
                
                <!-- User menu -->
                <xsl:call-template name="user-menu"/>
                
                <li class="burger">
                    <nav role="navigation" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION" i18n:attr="aria-label">
                        <button aria-haspopup="dialog" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION_MENU" i18n:attr="aria-label" onclick="openMenuMobile(this)"><i aria-hidden="true" class="fas fa-bars"></i></button>
                    </nav>
                </li>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template name="top-links">
        <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='topMenu']/links/link[not(@disabled)]" mode="top-links">
             <xsl:with-param name="uniqueId" select="concat('header_link_', $uniqueId)"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="link[@url != '' and @isHidden = 'false']" mode="top-links">
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <li class="top-link">
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                         <xsl:call-template name="link-title">
                            <xsl:with-param name="showThemes" select="'false'"/>
                            <xsl:with-param name="showUrl" select="'false'"/>
                         </xsl:call-template>
                         <xsl:call-template name="link-picture">
                            <xsl:with-param name="height" select="'22'"/>
                            <xsl:with-param name="width" select="'22'"/>
                         </xsl:call-template>
                    </a>    
                </xsl:when>
                <xsl:otherwise>
                    <a href="{@url}" onclick="window.open(this.href); return false;">
                         <xsl:call-template name="link-title">
                            <xsl:with-param name="showThemes" select="'false'"/>
                            <xsl:with-param name="showUrl" select="'false'"/>
                         </xsl:call-template>
                         <xsl:call-template name="link-picture">
                            <xsl:with-param name="height" select="'22'"/>
                            <xsl:with-param name="width" select="'22'"/>
                         </xsl:call-template>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
            <button class="open-notification-sr" aria-expanded="false">
                <xsl:attribute name="aria-label">
                    <xsl:choose>
                       <xsl:when test="normalize-space(@pageTitle) != ''">
                           <xsl:value-of select="@pageTitle"/>
                       </xsl:when>
                       <xsl:otherwise>
                           <xsl:value-of select="@title"/>
                       </xsl:otherwise>
                   </xsl:choose>
                </xsl:attribute>
                <i aria-hidden="true" class="fas fa-angle-down"></i>
            </button>
            <xsl:call-template name="link-dynamic-info">
                <xsl:with-param name="uniqueId" select="$uniqueId" />
             </xsl:call-template>
        </li>
    </xsl:template>
    
    <xsl:template name="alerts">
        <li class="top-link">
            <xsl:variable name="allalertes" select="ametys:findPagesIdsByTag('ALL_FLASH_INFO')"/>
            <xsl:variable name="allalertesUri" select="resolver:resolve('page', $allalertes/@id)"/>
            
            <a onclick="window.open(this.href); return false;" href="{$allalertesUri}" title="skin.{$skin}:SKIN_ALERTS" i18n:attr="title">
                <xsl:call-template name="alerts-icon"/>
            </a>
            <button aria-expanded="false" class="open-notification-sr" aria-label="skin.{$skin}:SKIN_ALERTS" i18n:attr="aria-label"><i class="fas fa-angle-down" aria-hidden="true"></i></button>
            <div class="link-dynamic-info">
                    <xsl:if test="count(/cms/inputData/Model/alerts/content) &gt; 0">
                        <span class="link-info-short-value"><span class="sr-only"><i18n:text i18n:key="SKIN_ALERTS" i18n:catalogue="skin.{$skin}"/> (<xsl:value-of select="count(/cms/inputData/Model/alerts/content)"/>)</span></span>
                        <div class="dropdown message">
                            <div class="space"></div>
                            <ul>
                                <li>
                                    <i18n:text i18n:key="SKIN_ALERTS" i18n:catalogue="skin.{$skin}"/> (<xsl:value-of select="count(/cms/inputData/Model/alerts/content)"/>)
                                </li>
                                
                                <xsl:for-each select="/cms/inputData/Model/alerts/content">
                                    <li>
                                        <span class="link-info-title"><xsl:value-of select="@title"/></span>
                                        <span class="message">
                                            <xsl:call-template name="common-utils-simpletext">
                                                <xsl:with-param name="defaultText" select="html/body//p[@class='content-abstract']"/>                
                                                <xsl:with-param name="maxDefaultTextSize" select="'60'"/>                
                                            </xsl:call-template>    
                                        </span>
                                    </li>
                                </xsl:for-each>
                            </ul>
                        </div>
                    </xsl:if>
                </div>
        </li>
    </xsl:template>
    
    <xsl:template name="alerts-icon">
        <span class="fas fa-bell link-glyph" aria-hidden="true" role="img" aria-label="skin.{$skin}:SKIN_ALERTS" i18n:attr="aria-label"></span>
    </xsl:template>
    
    <xsl:template name="body-background-image">
    	<xsl:variable name="banner" select="ametys:templateParameter('image')"/>   
    	
	    <xsl:if test="$banner">     
            <xsl:variable name="bannerUrl" select="resolver:resolveImage($banner/@type, $banner/@path, '', 1920)"/>
	        <xsl:attribute name="style">background-image : url(<xsl:value-of select="ametys:escapeURLforCSS($bannerUrl)"/>);</xsl:attribute>
        </xsl:if>  
    </xsl:template>
    
    <xsl:template name="header-main-logo">
        <div class="logo">
            <a href="{$site-uri-prefix}/{$lang}/index.html" class="logo-color">
                <img src="{ametys:skinURL('templates/common/img/logo-colorful.png')}" alt="skin.{$skin}:SKIN_LOGO_ALT" i18n:attr="alt"/>
            </a>
            <a href="{$site-uri-prefix}/{$lang}/index.html" class="logo-white">
                <img src="{ametys:skinURL('templates/common/img/logo-white.png')}" alt="skin.{$skin}:SKIN_LOGO_ALT" i18n:attr="alt"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="user-menu">
    	<xsl:if test="$currentUser/user/login">
	    	<li class="profil" style="display: none">
                <nav role="navigation" aria-label="skin.{$skin}:SKIN_NAV_USER_MENU" i18n:attr="aria-label">
                    <!-- For keyboard navigation -->
                    <button class="sr-only sr-only-focusable" aria-label="skin.{$skin}:SKIN_USER_MENU_LABEL" i18n:attr="aria-label" aria-expanded="false" onclick="openUserMenuOnClick(this)">
                        <i class="fas fa-angle-down" aria-hidden="true"></i>
                    </button>
    		    	<div class="dropdown profil-dropdown">
    		            <div class="space"></div>
    		            <ul>
    		                <li>
    		                	<xsl:choose>
    		                        <xsl:when test="$currentUser/user/pageId != ''">
    		                            <a href="{resolver:resolve('page', $currentUser/user/pageId)}" class="ametys-header-invoker__text_profile"><i18n:text i18n:key="SKIN_USER_MENU_GO_TO_PROFIL" i18n:catalogue="skin.{$skin}"/></a>
    		                        </xsl:when>
    		                        <xsl:otherwise>
    		                            <span class="ametys-header-invoker__text_profile">&#160;</span>
    		                        </xsl:otherwise>
    		                    </xsl:choose>
    		                </li>
    		                <!-- Logout -->
    		                <xsl:call-template name="user-menu-logout"/>
    		            </ul>
    		        </div>
                    
                    <xsl:call-template name="profil-img"/>
                </nav>
		    </li>
		</xsl:if>
		
		<script type="text/javascript">
            const closeUserMenuOnEscape = (event) => {
                if (event.key === "Escape") {
                    var $openUserMenu = $j("header .icons .profil .dropdown.openAccessibility");
                    $openUserMenu.removeClass('openAccessibility');
                    $openUserMenu.prev().attr("aria-expanded", "false");
                    $openUserMenu.prev().trigger('focus');
                }
            }
    
            function openUserMenuOnClick(el)
            {
                var isOpen = $j(el).next(".dropdown").is(':visible');
                if(!isOpen) {
                    // Open menu
                    $j(el).next(".dropdown").addClass('openAccessibility');
                    $j(el).attr("aria-expanded", "true");
                    $j(el).next(".dropdown").find('ul > li a').first().trigger('focus');
                }  else {
                    // Close menu
                    $j(el).next(".dropdown").removeClass('openAccessibility');
                    $j(el).attr("aria-expanded", "false");
                }
            }
            
            $j(".icons ul li.profil").on('mouseenter', function (el) {
                // Show user menu
                var $dropdown = $j(this).find(".dropdown");
                if (!$dropdown.is(':visible'))
                {
                    $dropdown.addClass("openAccessibility");
                    $j(this).find('> button').attr("aria-expanded", true);
                }
            });
            
            $j(".icons ul li.profil").on('mouseleave', function (el) {
                // Hide user menu 
                var $dropdown = $j(this).find(".dropdown");
                if ($dropdown.is(':visible'))
                {
                    $dropdown.removeClass("openAccessibility");
                    $j(this).find('> button').attr("aria-expanded", false);
                }
            });
            
            $j(function() {
                var _getAmetysUserCb = function(user)
                {
                    if (user)
                    {
                        $j('.profil').show();
                    }
                    else
                    {
                        $j('.profil').hide();
                    }
                }
                
                getAmetysUser(_getAmetysUserCb);
                
                document.addEventListener('keydown', closeUserMenuOnEscape); 
            });
        </script>
    </xsl:template>
    
    <xsl:template name="user-menu-logout">
        <li>
            <a href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html" >
                <span><i18n:text i18n:key="SKIN_LOGOUT" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-activities">
         <div class="ametys-header-q-panel">
            <a class="ametys-header-invoker" href="javascript:;" id="qPanel">
                <span class="ametys-header-invoker__icon icon-activity_icon"></span>
                <span class="ametys-indicator ametys-indicator--bordered ametys-indicator--danger"></span>
            </a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>