<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://templates/page/stylesheets/template.xsl" />
	<xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
	
    <xsl:variable name="hideIllustration" select="true()"/>
    
    <!-- To ignore UD transitional page in breadcrumb -->
    <xsl:variable name="ignoreTransitionPages">true</xsl:variable>
    
	<xsl:template name="additionnal-script" >
		<xsl:call-template name="ametys-front-edition-head">
			<xsl:with-param name="edition-mode-only" select="false()"/>
			<xsl:with-param name="editActionId" select="'42'"/> 
<!-- 			<xsl:with-param name="start-callback">function() { $j('.front-edition-placeholder').show(); }</xsl:with-param> -->
		</xsl:call-template>
        
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/edition-fo.css')}" />
	</xsl:template>
	
    <xsl:template name="main-zone">
        <div class="page-container">
            <div class="top fullpage">
                 <div class="left">
                    
                    <xsl:call-template name="bread-crumb"/>
                    
                    <div class="content">
                        <xsl:call-template name="main-content"/>
                    </div>
                </div>
                <xsl:call-template name="right"/>
            </div>
        </div>
    </xsl:template>
	
	 <xsl:template name="right"/>
     <xsl:template name="fo-toolbar"/>
	 
	 <xsl:template name="default-zone">
    	<div class="left">
       		<!-- Tags, title and illustration highlight -->
       		<zone name="default" level="2"/>
       	</div>
    </xsl:template>
    
    <xsl:template match="page[starts-with(@sitemap:id, 'udtransitional://')]" mode="breadcrumb">
        <xsl:if test="$ignoreTransitionPages != 'true'">
            <li itemscope="itemscope" itemtype="http://data-vocabulary.org/Breadcrumb">
                <a href="{resolver:resolve('page', @sitemap:id)}" itemprop="url">
                    <span itemprop="title">
                        <xsl:value-of select="@sitemap:title" />
                    </span>
                </a>
            </li>
        </xsl:if>
        <xsl:apply-templates select="page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
    </xsl:template>
    
</xsl:stylesheet>