
/**
 * SVG marker icon for Leaflet that can hold a number
 */
 
AmetysMarkers = {
    
    defaultOptions: {
      iconSize: [34, 46],
      iconAnchor: [34/2, 46],
      popupAnchor: [0,-42],
      padding: 0,
      circleRay: 90,
      circleBgColor: 'transparent',
      topText: 0
    },
    
    smallOptions: {
      iconSize: [38, 51],
      iconAnchor: [38/2, 51],
      popupAnchor: [0,-45],
      padding: 9,
      circleRay: 90,
      circleBgColor: '#FFFFFF',
      topText: 10
    },
    
    mediumOptions: {
      iconSize: [44, 59],
      iconAnchor: [44/2, 59],
      popupAnchor: [0,-52],
      padding: 12,
      circleRay: 100,
      circleBgColor: '#FFFFFF',
      topText: 13
    },
    
    largeOptions: {
      iconSize: [48, 64],
      iconAnchor: [48/2, 64],
      popupAnchor: [0,-58],
      padding: 14,
      circleRay: 115,
      circleBgColor: '#FFFFFF',
      topText: 15
    }
}

AmetysMarkers.Icon = L.DivIcon.extend({
    
    options: {
        className: 'leaflet-div-icon ametys-leaflet-div-icon'
    },
    
    createIcon: function(oldIcon)
    {
        var text = this.options.text || '';
        var length = Number.isInteger(text) ? String(text).length : text.length;

        switch (length)
        {
            case 1:
                L.extend(this.options, AmetysMarkers.smallOptions);
                break;
            case 2:
                L.extend(this.options, AmetysMarkers.mediumOptions);
                break;
            case 3:
                L.extend(this.options, AmetysMarkers.largeOptions);
                break;
            default:
                L.extend(this.options, AmetysMarkers.defaultOptions);
                
        }
        
        var div = document.createElement('div');

        div.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">' +
            '            <path d="M172.268 501.67C26.97 291.031 0 269.413 0 192 0 85.961 85.961 0 192 0s192 85.961 192 192c0 77.413-26.97 99.031-172.268 309.67-9.535 13.774-29.93 13.773-39.464 0zM192 272c44.183 0 80-35.817 80-80s-35.817-80-80-80-80 35.817-80 80 35.817 80 80 80z"/>' +
            '            <circle cx="192" cy="192" r="' + this.options.circleRay + '" fill="' + this.options.circleBgColor + '" />' +
            '        </svg>' +
            '    <div class="marker-icon-text" style="top:' + this.options.topText + 'px">' + text + '</div>';
                            
        this._setIconStyles(div, 'icon');
        
        return div;
    }
});
    