<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver">

    <xsl:import href="plugin:classified-ads://stylesheets/content/ads/ads-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
    
    <xsl:variable name="wrapperContentCssClass">item actu-item with-icon</xsl:variable>
    
    <xsl:template name="content">
        <div class="content">
            <xsl:call-template name="content-tags"/>
            
            <xsl:call-template name="content-icon"/>
            
            <xsl:call-template name="content-title"/>
            
            <xsl:call-template name="content-abstract"/>
            
            <xsl:call-template name="content-image">
                <xsl:with-param name="image" select="metadata/illustrations/image1"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="content-tags">
        <xsl:if test="metadata/category">
            <div class="etiquettes">
                <span class="etiquette"><xsl:value-of select="metadata/category/@title"/></span>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-icon">
        <span class="intraneticon-annonce icon"></span>
    </xsl:template>
    
    <xsl:template name="content-default-image-picto">
        <i class="intraneticon-annonce"></i>
    </xsl:template>
    
    <xsl:template name="get-page-id">
        <xsl:value-of select="ugc:getUgcPage(//content/@id)"/>
    </xsl:template>
    
</xsl:stylesheet>