<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                            xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:math="http://exslt.org/math"
                            xmlns:docbook="http://docbook.org/ns/docbook"
							exclude-result-prefixes="ametys resolver math">

	<xsl:import href="plugin:workspaces://stylesheets/content/member/member-main.xsl"/>	
	<xsl:import href="member.xsl"/>	
    <xsl:import href="skin://stylesheets/utils.xsl" />
	
	<xsl:template name="display-frontedition-placeholder">
    	<xsl:variable name="user" select="metadata/user/@login"/>
    
	    <xsl:if test="$rendering-context = 'front'">
	       <script type="text/javascript">
	            $j(function(){
			       		if ("<xsl:value-of select="$user"/>" == ametysUser.login )
	                	$j('.frontedition-placeholder').show();
	            });
	        </script>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <div class="internal-profil">
            <xsl:call-template name="avatar"/>
            <xsl:call-template name="profil-header"/>
        </div>
        
        <xsl:call-template name="profil-contact"/>
        
        <xsl:call-template name="profil-more-informations"/>
        
        <xsl:call-template name="profil-content"/>
        
        <xsl:call-template name="display-frontedition-placeholder"/>
    </xsl:template> 
    
    <xsl:template name="profil-header">
	   <div class="content">
           <xsl:call-template name="profile-header-entity"/>
	       <xsl:call-template name="profile-header-title"/>
	       <xsl:call-template name="profile-header-function"/>
	   </div>
    </xsl:template>
    
    <xsl:template name="profil-contact">
        <xsl:call-template name="profil-contact-phone" />
        <xsl:call-template name="profil-contact-mail" />
        <xsl:call-template name="profil-contact-links"/>
    </xsl:template>
    
    <xsl:template name="profil-more-informations">
        <xsl:call-template name="profile-mission"/>
        <xsl:call-template name="profile-organisation"/>
    </xsl:template>
    
    <xsl:template name="profil-content">
        <xsl:call-template name="profil-skills"/>
        <xsl:call-template name="profil-professional-history"/>
        <xsl:call-template name="profil-keywords"/>
        <xsl:call-template name="profil-hobbies"/>
    </xsl:template>
    
    <xsl:template name="profil-contact-phone">
        <div class="phones">
            <xsl:call-template name="phone"/>
            <xsl:call-template name="phoneMobile"/>
        </div>
    </xsl:template>
    
    <xsl:template name="profil-skills">
        <xsl:choose>
            <xsl:when test="metadata/skills">
    	        <h2 class="ametys-richtext-title-2"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_SKILLS" i18n:catalogue="skin.{$skin}"/></h2>
                <div data-ametys-metadata="{@id};skills" class="list-editable ">
        	        <ul class="disc skills">
        		        <xsl:for-each select="metadata/skills">
        				    <li>
        				        <xsl:value-of select="@title"/>
        				    </li>
        				</xsl:for-each>
        			</ul>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="frontedition-placeholder" style="display: none;">
                    <h3 class="ametys-richtext-title-2"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_SKILLS" i18n:catalogue="skin.{$skin}"/></h3>
                    <div class="flex-icon">
                        <span style="width: 100%; position: relative" data-ametys-metadata="{@id};skills"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_SKILLS" i18n:catalogue="skin.{$skin}"/></span>
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="profil-professional-history">
        <xsl:choose>
            <xsl:when test="metadata/professional-history/docbook:article">
    	        <h2 class="ametys-richtext-title-2"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_HISTORY_PRO" i18n:catalogue="skin.{$skin}"/></h2>
                
                <div data-ametys-metadata="{@id};professional-history" class="richtext-editable">
        	        <xsl:apply-templates select="metadata/professional-history/docbook:article">
        	            <xsl:with-param name="level" select="2"/>
        	        </xsl:apply-templates>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="richtext-editable frontedition-placeholder" style="display: none;">
                    <h2 class="ametys-richtext-title-2"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_HISTORY_PRO" i18n:catalogue="skin.{$skin}"/></h2>
                    <div style="width: 100%; position: relative" data-ametys-metadata="{@id};professional-history">
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="profil-keywords">
        <xsl:choose>
            <xsl:when test="metadata/keywords">
                <h3 class="ametys-richtext-title-3"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_KEYWORDS" i18n:catalogue="skin.{$skin}"/></h3>
                <div data-ametys-metadata="{@id};keywords" class="list-editable">
                    <ul class="disc">
        	            <xsl:for-each select="metadata/keywords">
        	                <li>
        	                    <xsl:value-of select="@title"/>
        	                </li>
        	            </xsl:for-each>
                    </ul>
                 </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="frontedition-placeholder" style="display: none;">
                    <h3 class="ametys-richtext-title-3"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_KEYWORDS" i18n:catalogue="skin.{$skin}"/></h3>
                    <div class="flex-icon">
                        <span style="width: 100%; position: relative" data-ametys-metadata="{@id};keywords"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_KEYWORDS" i18n:catalogue="skin.{$skin}"/></span>
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="profil-hobbies">
        <xsl:choose>
            <xsl:when test="metadata/hobbies/docbook:article">
                <h2 class="ametys-richtext-title-2"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_HOBBIES" i18n:catalogue="skin.{$skin}"/></h2>
                <div data-ametys-metadata="{@id};hobbies" class="richtext-editable">
                    <xsl:apply-templates select="metadata/hobbies/docbook:article">
                        <xsl:with-param name="level" select="2"/>
                    </xsl:apply-templates>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="richtext-editable frontedition-placeholder" style="display: none;">
                    <h2 class="ametys-richtext-title-2"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_HOBBIES" i18n:catalogue="skin.{$skin}"/></h2>
                    <div style="width: 100%; position: relative" data-ametys-metadata="{@id};hobbies">
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="profile-header-entity">
        <xsl:choose>
            <xsl:when test="count(metadata/orgunits) > 0">
                <xsl:for-each select="metadata/orgunits">
                    <xsl:variable name="page-id"><xsl:value-of select="orgUnit:getOrgUnitPage(@id)"/></xsl:variable>
                    <div class="etiquette">
                        <xsl:choose>
                            <xsl:when test="$page-id != ''">
                                <a href="{resolver:resolve('page', $page-id, false)}"><xsl:value-of select="@title"/></a>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="@title"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="normalize-space(metadata/organisation) != ''">
                <div class="etiquette">
                    <span data-ametys-metadata="{@id};organisation">
                        <xsl:value-of select="metadata/organisation"/>
                    </span>
                    
                    <xsl:if test="normalize-space(metadata/organisation-accronym) != ''">
                        <span data-ametys-metadata="{@id};organisation-accronym">
                            (<xsl:value-of select="metadata/organisation-accronym"/>)
                        </span>
                    </xsl:if>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="etiquette frontedition-placeholder" style="display: none;">
                     <span data-ametys-metadata="{@id};organisation">
                        <i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_ORGANIZATION" i18n:catalogue="skin.{$skin}"/>
                     </span>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="profile-header-function">
         <xsl:choose>
            <xsl:when test="normalize-space(metadata/function) != ''">
                <p class="function" data-ametys-metadata="{@id};function">
                   <xsl:value-of select="metadata/function"/>
               </p>
            </xsl:when>
            <xsl:otherwise>
                <div class="flex-icon frontedition-placeholder" style="display: none;">
                    <span class="function" style="width: 100%; position: relative" data-ametys-metadata="{@id};function"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_FUNCTION" i18n:catalogue="skin.{$skin}"/></span>
                </div>
            </xsl:otherwise>
        </xsl:choose>    
    </xsl:template>
    
    <xsl:template name="profile-header-title">
        <h1 class="ametys-richtext-title-1">
            <xsl:value-of select="metadata/firstname"/> 
            <xsl:text> </xsl:text>
            <xsl:value-of select="metadata/lastname"/>
        </h1>
    </xsl:template>
    
    <xsl:template name="phone">
        <xsl:choose>
            <xsl:when test="normalize-space(metadata/phone) != ''">
                 <div class="flex-icon">
                    <xsl:call-template name="phone-icon"/>
                    <span data-ametys-metadata="{@id};phone">
                        <a href="tel:{metadata/phone}"><xsl:value-of select="metadata/phone"/></a>
                    </span>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="flex-icon frontedition-placeholder" style="display: none;">
                    <xsl:call-template name="phone-icon"/>
                    <span style="width: 100%; position: relative" data-ametys-metadata="{@id};phone"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_PHONE" i18n:catalogue="skin.{$skin}"/></span>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="phoneMobile">
	    <xsl:choose>
		    <xsl:when test="normalize-space(metadata/mobile) != ''">
		         <div class="flex-icon">
		            <xsl:call-template name="mobile-icon"/>
		            <span data-ametys-metadata="{@id};mobile">
		            <a href="tel:{metadata/mobile}"><xsl:value-of select="metadata/mobile"/></a>
		            </span>
		        </div>
		    </xsl:when>
		    <xsl:otherwise>
		        <div class="flex-icon frontedition-placeholder" style="display: none;">
		            <xsl:call-template name="mobile-icon"/>
		            <span style="width: 100%; position: relative" data-ametys-metadata="{@id};mobile"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_MOBILE" i18n:catalogue="skin.{$skin}"/></span>
		        </div>
		    </xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <xsl:template name="profil-contact-mail">
        <xsl:if test="normalize-space(metadata/email) != ''">
            <div class="flex-icon">
                <xsl:call-template name="mail-icon"/>
                <xsl:call-template name="mail-antispam">
                   <xsl:with-param name="mail" select="metadata/email"/>
               </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
	
	<xsl:template name="profil-contact-links">
        <xsl:choose>
            <xsl:when test="normalize-space(metadata/social-link) != ''">
                 <div class="flex-icon">
                    <xsl:call-template name="link-icon"/>
                    <span data-ametys-metadata="{@id};social-link">
                    <a href="{metadata/social-link}"><xsl:value-of select="metadata/social-link"/></a>
                    </span>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="flex-icon frontedition-placeholder" style="display: none;">
                    <xsl:call-template name="link-icon"/>
                    <span style="width: 100%; position: relative" data-ametys-metadata="{@id};social-link"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_SOCIAL_LINK" i18n:catalogue="skin.{$skin}"/></span>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:choose>
            <xsl:when test="normalize-space(metadata/other-link) != ''">
                 <div class="flex-icon">
                    <xsl:call-template name="other-link-icon"/>
                    <span data-ametys-metadata="{@id};other-link">
                    <a href="{metadata/other-link}"><xsl:value-of select="metadata/other-link"/></a>
                    </span>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="flex-icon frontedition-placeholder" style="display: none;">
                    <xsl:call-template name="other-link-icon"/>
                    <span style="width: 100%; position: relative" data-ametys-metadata="{@id};other-link"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_OTHER_LINK" i18n:catalogue="skin.{$skin}"/></span>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
    <xsl:template name="profile-organisation">
        <!-- Display 'organisation' field only if there are orgunits (otherwise orgnisation will be already displayed in "profile-header-entity") -->
        <xsl:if test="count(metadata/orgunits) > 0">
            <xsl:choose>
                <xsl:when test="normalize-space(metadata/organisation) != ''">
                    <div class="flex-icon">
                         <xsl:call-template name="organisation-icon"/>
                         <span data-ametys-metadata="{@id};organisation">
                             <xsl:value-of select="metadata/organisation"/>
                         </span>
                         
                         <xsl:if test="normalize-space(metadata/organisation-accronym) != ''">
                             <span data-ametys-metadata="{@id};organisation-accronym">
                                 (<xsl:value-of select="metadata/organisation-accronym"/>)
                             </span>
                         </xsl:if>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <div class="flex-icon frontedition-placeholder" style="display: none;">
                         <xsl:call-template name="organisation-icon"/>
                         <span class="flexLarge" data-ametys-metadata="{@id};organisation">
                            <i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_ORGANIZATION" i18n:catalogue="skin.{$skin}"/>
                         </span>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="profile-mission">
         <xsl:choose>
             <xsl:when test="normalize-space(metadata/mission) != ''">
                  <div class="flex-icon">
                     <xsl:call-template name="mission-icon"/>
                     <span class="flexLarge" data-ametys-metadata="{@id};mission">
                         <xsl:value-of select="metadata/mission"/>
                     </span>
                </div>
               </xsl:when>
               <xsl:otherwise>
                 <div class="flex-icon frontedition-placeholder" style="display: none;">
                     <xsl:call-template name="mission-icon"/>
                     <span class="flexLarge" data-ametys-metadata="{@id};mission">
                        <i18n:text i18n:key="SKIN_CONTENT_MEMBER_PLACEHOLDER_MISSION" i18n:catalogue="skin.{$skin}"/>
                     </span>
                 </div>
               </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    
    <xsl:template name="avatar">
        <div class="picture" data-ametys-metadata="{@id};illustration/image">
        	<xsl:choose>
        		<xsl:when test="metadata/illustration/image">
                    <xsl:call-template name="common-content-body-image-bigsize">
    		            <xsl:with-param name="maxWidth" select="'300'" />
    		            <xsl:with-param name="maxHeight" select="'300'" />
    		            <xsl:with-param name="type" select="'cropped'"/>
    		            <xsl:with-param name="class" select="'profil ametys-profile-header__img'" />
    		        </xsl:call-template>
        		</xsl:when>
                <xsl:when test="metadata/user">
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">300</xsl:with-param>
                        <xsl:with-param name="login" select="metadata/user/@login"/>
                        <xsl:with-param name="population" select="metadata/user/@populationId"/>
                        <xsl:with-param name="lang" select="@language"/>
                        <xsl:with-param name="class">profil ametys-profile-header__img</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
        		<xsl:otherwise>
    	    	      <img src="{ametys:skinURL('templates/common/img/avatar.png')}"/>
        		</xsl:otherwise>
        	</xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="phone-icon">
        <span class="material-icons">call</span>
    </xsl:template>
    
    <xsl:template name="mobile-icon">
        <span class="material-icons">smartphone</span>
    </xsl:template>
    
    <xsl:template name="mail-icon">
        <span class="material-icons">mail</span>
    </xsl:template>
    
    <xsl:template name="link-icon">
        <span class="material-icons">link</span>
    </xsl:template>
    
    <xsl:template name="other-link-icon">
        <span class="material-icons">link</span>
    </xsl:template>
    
    <xsl:template name="organisation-icon">
	    <span class="material-icons">business</span>
	</xsl:template>
	
	<xsl:template name="mission-icon">
        <span class="material-icons">business_center</span>
    </xsl:template>
    
</xsl:stylesheet>
