<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">

    <xsl:import href="skin://services/link-directory/pages/services/directory/utils/thumbnails_utils.xsl"/>
    
    <xsl:variable name="deactivatePageSubscription" select="ametys:templateParameter('deactivatePageSubscription')"/>
    
    <xsl:template name="acces-rapides">
        <xsl:param name="height">20</xsl:param>
        <xsl:param name="width">20</xsl:param>
        
        <xsl:if test="/cms/inputData/linkDirectory/links/link[themes/theme/@id='ACCES_RAPIDES']">
            <div class="ametys-cms-service ametys-zone-access link-directory">
                <xsl:call-template name="acces-rapides-title"/>
                
                <xsl:call-template name="acces-rapides-ul">
                    <xsl:with-param name="height" select="$height"/>
                    <xsl:with-param name="width" select="$width"/>
                </xsl:call-template>
           </div>
        </xsl:if>
    </xsl:template>
          
    <xsl:template name="acces-rapides-title">
        <h2 class="service-title"><i18n:text i18n:key="SKIN_ACCESS_RAPIDES_LABEL" i18n:catalogue="skin.{$skin}"/></h2>
    </xsl:template>
    
    <xsl:template name="acces-rapides-ul">
        <xsl:param name="height">20</xsl:param>
        <xsl:param name="width">20</xsl:param>
        
        <ul>
            <xsl:for-each select="cms/inputData/linkDirectory[@id='accesRapides']/links/link[themes/theme/@id='ACCES_RAPIDES' and not(@disabled)]">
                <xsl:apply-templates select="." mode="acces-rapides">
                    <xsl:with-param name="height" select="$height"/>
                    <xsl:with-param name="width" select="$width"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template match="link" mode="acces-rapides">
        <xsl:param name="height">20</xsl:param>
        <xsl:param name="width">20</xsl:param>
                
        <li>
             <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}">
                        <div class="icon">
                            <xsl:call-template name="link-picture">
                               <xsl:with-param name="height" select="$height"/>
                               <xsl:with-param name="width" select="$width"/>
                            </xsl:call-template>
                        </div>
                        <div class="title">
                            <xsl:call-template name="link-text"/>
                        </div>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                   <a href="{@url}" onclick="window.open(this.href); return false;">
                        <div class="icon">
                            <xsl:call-template name="link-picture">
                               <xsl:with-param name="height" select="$height"/>
                               <xsl:with-param name="width" select="$width"/>
                            </xsl:call-template>
                        </div>
                        <div class="title">
                            <xsl:call-template name="link-text"/>
                        </div>
                   </a> 
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template name="accessibility-links">
		<div class="accessibility">
			<a href="#main-content"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_CONTENT" i18n:catalogue="skin.{$skin}"/></a>
            <xsl:if test="$template != 'index' and $template != 'login' and $template != 'signup'">
                <a href="#search"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_SEARCH" i18n:catalogue="skin.{$skin}"/></a>
            </xsl:if>
		</div>
	</xsl:template>
    
    <xsl:template name="matomo-stats">
        <xsl:variable name="piwikUrl" select="ametys:config('piwik-url')"/>
        <xsl:variable name="piwikId" select="ametys:siteParameter('piwik-id')"/>
        <xsl:variable name="statsEnabled" select="ametys:siteParameter('matomo-live-stats')"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($piwikId) != '' and normalize-space($piwikUrl) != '' and $statsEnabled = 'true' and not(ametys:isEditionMode())">
            <span class="nb-visits" style="display: none" tabindex="0">
                <span class="icon fa-solid fa-eye" aria-hidden="true"></span>
                <span id="nb-visits-multiple"><i18n:text i18n:key="SKIN_MATOMO_STATS_VISITS" i18n:catalogue="skin.{$skin}"/></span>
                <span id="nb-visits-single"><i18n:text i18n:key="SKIN_MATOMO_STATS_VISIT" i18n:catalogue="skin.{$skin}"/></span>
                
                <span class="nb-visits-tooltip sr-only">
                     <i18n:text i18n:key="SKIN_MATOMO_STATS_VISITS_TOOLTIP" i18n:catalogue="skin.{$skin}"/>
                </span>
            </span>
            <script type="text/javascript">
               // Tippy plugin to hide tooltip on ESC
                const hideVisitTooltipOnEsc = {
                  name: 'hideOnEsc',
                  defaultValue: true,
                  fn({hide}) {
                    function onKeyDown(event) {
                      if (event.keyCode === 27) {
                        hide();
                      }
                    }
                    return {
                      onShow() {
                        document.addEventListener('keydown', onKeyDown);
                      },
                      onHide() {
                        document.removeEventListener('keydown', onKeyDown);
                      },
                    };
                  },
                };
                
               $j(function() {
                 AmetysMatomoHelper.getPageData(".nb-visits", "<xsl:value-of select="$site-uri-prefix" />", null, function() {
                    
                    var nbVisits = $j(".nb-visits #nb-visits-multiple [data-matomo='nb-visits']").text();
                    if (nbVisits)
                    {
                        if (Number(nbVisits) == 1)
                        {
                            $j(".nb-visits #nb-visits-multiple").remove();
                        }
                        else
                        {
                            $j(".nb-visits #nb-visits-single").remove();
                        }
                            
                        $j(".nb-visits").show();
                        
                        // Tooltip
                        tippy('.nb-visits', {
                            content: $j(".nb-visits .nb-visits-tooltip").text(), 
                            plugins: [hideVisitTooltipOnEsc]
                        });
                    }
                    else
                    {
                        $j(".nb-visits").remove();
                    }
                });
               });
            </script>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Subscribe/unsubcribe to a page
         + -->
    <xsl:template name="page-subscription">
        <div data-ametys-subscription-page="{ametys:pageId()}" class="page-follow">
            <xsl:call-template name="page-unsubscribe-btn"/>
            <xsl:call-template name="page-subscribe-btn"/>
            <xsl:call-template name="page-subscription-js"/>
        </div>
        
        <div class="delimiter-actions"></div>
    </xsl:template>
    
    <xsl:template name="page-subscribe-btn">
        <button class="unfollowed" type="button" 
                data-ametys-subscription-page-role="subscribe"
                onclick="AmetysFront.UserPageSubscriptions.subscribePage('{ametys:pageId()}', updateSubscriptionCb)" 
                title="skin.{$skin}:SKIN_PAGE_SUBCRIPTION_SUBSCRIBE_BTN_TITLE"
                i18n:attr="title"
                style="display: none">
            <span class="text"><i18n:text i18n:key="SKIN_PAGE_SUBCRIPTION_SUBSCRIBE" i18n:catalogue="skin.{$skin}"/></span>

            <xsl:call-template name="page-unfollowed-icon"/>
            <span class="number" data-ametys-subscription-page-role="nb-subscribers"></span>
        </button>
    </xsl:template>
    
    <xsl:template name="page-unsubscribe-btn">
        <button class="followed" type="button" 
                data-ametys-subscription-page-role="unsubscribe" 
                onclick="AmetysFront.UserPageSubscriptions.unsubscribePage('{ametys:pageId()}', updateSubscriptionCb)"
                title="skin.{$skin}:SKIN_PAGE_SUBCRIPTION_UNSUBSCRIBE_BTN_TITLE"
                i18n:attr="title" 
                style="display: none">
            <span class="text"><i18n:text i18n:key="SKIN_PAGE_SUBCRIPTION_UNSUBSCRIBE" i18n:catalogue="skin.{$skin}"/></span>

            <xsl:call-template name="page-followed-icon"/>
            <span class="number"><span data-ametys-subscription-page-role="nb-subscribers"></span><span class="sr-only"><i18n:text i18n:key="SKIN_PAGE_SUBCRIPTION_SUBSCRIBERS" i18n:catalogue="skin.{$skin}"/></span></span>
        </button>
    </xsl:template>
    
    <xsl:template name="page-followed-icon">
        <svg aria-hidden="true" class="followed-svg" width="28px" height="20px" viewBox="0 0 28 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" opacity="0.79809643">
                <g transform="translate(-1549, -147)">
                    <g transform="translate(1473, 147)">
                        <g transform="translate(76, 0.3)">
                            <rect stroke="#FFFFFF" stroke-width="1.5" x="0.75" y="0.75" width="26.5" height="17.7" rx="5"></rect>
                            <rect stroke="#FFFFFF" stroke-width="1.5" x="8.75" y="4.11111111" width="10.744444" height="10.744444" rx="5.372222"></rect>
                            <g transform="translate(11, 7.8875)" fill="#FFFFFF" fill-rule="nonzero">
                                <path d="M6.00195312,0.123046875 C6.08398438,0.214192708 6.125,0.319010417 6.125,0.4375 L6.125,0.4375 C6.125,0.555989583 6.08398438,0.660807292 6.00195312,0.751953125 L2.50195312,4.25195312 C2.41080729,4.33398438 2.30598958,4.375 2.1875,4.375 C2.06901042,4.375 1.96419271,4.33398438 1.87304688,4.25195312 L0.123046875,2.50195312 C0.041015625,2.41080729 0,2.30598958 0,2.1875 C0,2.06901042 0.041015625,1.96419271 0.123046875,1.87304688 C0.214192708,1.79101562 0.319010417,1.75 0.4375,1.75 C0.555989583,1.75 0.660807292,1.79101562 0.751953125,1.87304688 L2.17382812,3.32226562 L5.37304688,0.123046875 C5.46419271,0.041015625 5.56901042,0 5.6875,0 C5.80598958,0 5.91080729,0.041015625 6.00195312,0.123046875 L6.00195312,0.123046875 Z" id="Path"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="page-unfollowed-icon">
        <svg aria-hidden="true" class="unfollowed-svg" width="28px" height="20px" viewBox="0 0 28 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g transform="translate(-1549, -147)">
                    <g transform="translate(1454, 147)">
                        <g transform="translate(95, 0.3)">
                            <g stroke="#FFFFFF" stroke-opacity="1" stroke-width="1.5">
                                <rect x="0.75" y="0.75" width="26.5" height="17.7" rx="5"></rect>
                            </g>
                            <g transform="translate(8, 3.3611)">
                                <rect stroke-opacity="1" stroke="#FFFFFF" stroke-width="1.5" x="0.75" y="0.75" width="10.744444" height="10.744444" rx="5.372222"></rect>
                                <g transform="translate(3.2, 3.05)" fill="#FFFFFF" fill-opacity="0.5">
                                    <rect x="2.51874975" y="0" width="1.16250008" height="6.20000042" rx="0.581250039"></rect>
                                    <path
                                        d="M3.09999976,4.49595973e-07 C3.42101529,4.49595973e-07 3.6812498,0.260234956 3.6812498,0.581250489 L3.6812498,5.61874993 C3.6812498,5.93976546 3.42101529,6.19999997 3.09999976,6.19999997 C2.77898423,6.19999997 2.51874972,5.93976546 2.51874972,5.61874993 L2.51874972,0.581250489 C2.51874972,0.260234956 2.77898423,4.49595973e-07 3.09999976,4.49595973e-07 Z"
                                        id="Rectangle" transform="translate(3.1, 3.1) rotate(90) translate(-3.1, -3.1)"></path>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="page-subscription-js">
        <script>
            function updateSubscriptionCb(pageId, data)
            {
                let $wrapper = $j('[' + AmetysFront.UserPageSubscriptions.SUBSCRIPTION_PAGE_ATTR + '="' + pageId + '"]');
                if (data.nbSubscribers == 0)
                {
                    $wrapper.find(AmetysFront.UserPageSubscriptions.NB_SUBSCRIBERS_PAGE_SELECTOR).hide();
                }
                else
                {
                    $wrapper.find(AmetysFront.UserPageSubscriptions.NB_SUBSCRIBERS_PAGE_SELECTOR).show();
                }
            }
            
            $j(function () {
                AmetysFront.UserPageSubscriptions.getSubscriptions("<xsl:value-of select="ametys:pageId()"/>", updateSubscriptionCb);
                
                // Mark as read
                AmetysFront.UserPageSubscriptions.markPageAsRead("<xsl:value-of select="ametys:pageId()"/>");
            });
          </script>
    </xsl:template>
    
</xsl:stylesheet>