<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:docbook="http://docbook.org/ns/docbook" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:cms="http://ametys.org/cms/3.0"
    exclude-result-prefixes="ametys resolver docbook">    
    
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    <!-- Use full ajax comments -->
    <xsl:import href="skin://pages/comments/helper/comments.xsl"/>
    
    <xsl:variable name="zoneItemPosition" select="ametys:zoneItemPosition()"/>
    <xsl:variable name="hideTitle" select="$zone = 'default' and ametys:zoneParameter('default', 'hideTitle') = 'true'" />
    
    <!-- Number of likers display with their fullname in likes/unlike button tooltip -->
    <xsl:variable name="maxLikersInTooltip">3</xsl:variable>
    
    <xsl:template name="common-content-head-css">
         <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" media="screen, print"/>
         
         <xsl:call-template name="custom-content-css"/>
    </xsl:template>
    
    <!-- Custom css class for content rendering -->
    <xsl:template name="custom-content-css"/>
    
    <xsl:template name="common-content-head-js">
        <xsl:call-template name="content-likes-script"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
		<xsl:if test="not($hideTitle) and not($zone = 'default' and $zoneItemPosition = 1)">
	        <h1 class="content-title">
	        	<span class="content-title summary"><xsl:value-of select="$title"/></span>
	            <xsl:if test="$subtitle != ''">
	                <span class="content-subtitle"><xsl:value-of select="$subtitle"/></span>
	            </xsl:if>
	        </h1>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-publish-date"/>
    
    <xsl:template name="common-content-body-meta">
    	<xsl:if test="metadata/contact/name or metadata/contact/mail or @lastValidatedAt">
    		<div class="meta">
    			<xsl:call-template name="common-content-body-contact"/>
	    	</div>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="comment-form-showhint"/>
    
    <!-- Template used to display the content illustration -->
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        
        <xsl:if test="$image">
            <img alt="{$alternative}" class="{$class}">
                <xsl:attribute name="src">
                 <xsl:choose>
                     <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                     <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                 </xsl:choose>
                </xsl:attribute>
            </img>
        </xsl:if>        
    </xsl:template>
    
    <!-- Override to take into account 'hideTitle' parameter value for hX levels -->
    <xsl:template name="common-content-body-content-rich">
        <xsl:param name="level" select="0"/>
        <xsl:param name="content" select="metadata/content"/>

        <xsl:variable name="minLevel">
            <xsl:choose>
                <xsl:when test="$zone = 'default' and ($hideTitle)">0</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:if test="cms:isNotRichTextEmpty($content)">
            <xsl:variable name="raw-is-title-visible">
                <xsl:call-template name="common-content-body-title-content"/>
            </xsl:variable>
            
            <xsl:variable name="truelevel">
                <xsl:choose>
                    <xsl:when test="string-length($raw-is-title-visible) &gt; 0"><xsl:value-of select="number($minLevel) + 1 + number($level)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="number($minLevel) + number($level)"/></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <div class="content-richtext">
                <xsl:apply-templates select="$content/docbook:article">
                    <xsl:with-param name="level" select="$truelevel"/>
                </xsl:apply-templates>
            </div>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="content-likes">
        <xsl:if test="metadata/likes = 'true'">
            <span data-ametys-content-likes="{@id}" class="ametys-content-likes">
                <button 
                    type="button"
                    onclick="AmetysFront.ContentReactions.likeOrUnlike('{@id}', $j(this).attr('data-ametys-content-own-liker') == 'true', likeOrUnlikeContentCb_{$uniqueId})"
                    title="plugin.cms:PLUGINS_CMS_CONTENT_LIKE_TITLE"
                    i18n:attr="title"
                    data-ametys-content-own-liker="false" 
                    aria-pressed="false" 
                    aria-describedby="tooltip-{$uniqueId}"
                    class="ametys-content-likes__btn">
                    <span aria-hidden="true" class="icon like far fa-heart"></span>
                    <span aria-hidden="true" class="icon unlike fas fa-heart"></span>
                </button>
                <span id="tooltip-{$uniqueId}" role="tooltip" class="sr-only">
                    <!-- tootip content with likers-->
                </span>
                <span data-ametys-content-likes-count="true" class="ametys-content-likes__count"></span>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-likes-script">
        <xsl:if test="metadata/likes = 'true'">
            <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/cms/resources/js/AmetysFront/ContentReactions.', ametys:lang(), '.js')}"/>
            <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
            
            <script type="text/javascript">
                // Tippy plugin to hide tooltip on ESC
                const hideContentLikesTooltipOnEsc_<xsl:value-of select="$uniqueId"/> = {
                  name: 'hideOnEsc',
                  defaultValue: true,
                  fn({hide}) {
                    function onKeyDown(event) {
                      if (event.keyCode === 27) {
                        hide();
                      }
                    }
                    return {
                      onShow() {
                        document.addEventListener('keydown', onKeyDown);
                      },
                      onHide() {
                        document.removeEventListener('keydown', onKeyDown);
                      },
                    };
                  },
                };
                    
                function updateContentLikes_<xsl:value-of select="$uniqueId"/>(contentId, likers)
                {
                    let $likesEl = $j("[data-ametys-content-likes='" + contentId + "']");
                    let $btn = $likesEl.find("button");
                    let nbLikes = likers.length;
                    let maxNbLikers = <xsl:value-of select="$maxLikersInTooltip"/>;
                    let ownLiker = false;
                    
                    // Update count
                    $likesEl.find("[data-ametys-content-likes-count]").html(nbLikes);
                    if (nbLikes==0)
                    {
                        $likesEl.find("[data-ametys-content-likes-count]").hide();
                    }
                    else
                    {
                        $likesEl.find("[data-ametys-content-likes-count]").show();
                    }
                    
                    // Destroy tooltip
                    if ($btn.get(0)._tippy)
                    {
                        $btn.get(0)._tippy.destroy();
                    }
                                    
                    // Update likers
                    let likerTooltips = "";
                    $j.each(likers, function(i, liker) {
                        if (ametysUser &amp;&amp; liker.login == ametysUser.login &amp;&amp; liker.populationId == ametysUser.populationId)
                        {
                            ownLiker = true;
                        }
                        
                        if (i &lt; maxNbLikers)
                        {
                            likerTooltips += "&lt;span class='like'>" + liker.fullname + "&lt;/span>"
                        }
                    });
                    
                    let otherCount = nbLikes - maxNbLikers;
                    if (otherCount == 1)
                    {
                        likerTooltips += "&lt;span class='like'><i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_OTHER_TOOLTIP" i18n:catalogue="plugin.cms"/>&lt;/span>"
                    }
                    else if (otherCount &gt; 1)
                    {
                        likerTooltips += "&lt;span class='like'>" + "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_OTHERS_TOOLTIP" i18n:catalogue="plugin.cms"/>".replace(/\{0}/, otherCount) + "&lt;/span>";
                    }
                    
                    if (likerTooltips)
                    {
                        $likesEl.find("[role=tooltip]").html(likerTooltips);
                        
                        // Tooltip
                        tippy("[data-ametys-content-likes='" + contentId + "'] button", {
                            allowHTML: true,
                            content: $likesEl.find("[role=tooltip]").html(),
                            plugins: [hideContentLikesTooltipOnEsc_<xsl:value-of select="$uniqueId"/>]
                        });
                    }
                    
                    $btn.attr("data-ametys-content-own-liker", ownLiker);
                    
                    if (ownLiker)
                    {
                        $btn.addClass("active");
                        $btn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_UNLIKE_TITLE" i18n:catalogue="plugin.cms"/>");
                        $btn.attr("aria-pressed", "true");
                    }
                    else
                    {
                        $btn.removeClass("active");
                        $btn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_TITLE" i18n:catalogue="plugin.cms"/>");
                        $btn.attr("aria-pressed", "false");
                    }
                }
                
                function likeOrUnlikeContentCb_<xsl:value-of select="$uniqueId"/>(contentId, result, liked)
                {
                    if (result.updated)
                    {
                        updateContentLikes_<xsl:value-of select="$uniqueId"/>(contentId, result.actors);
                    }
                }
                
                $j(function(){
                    AmetysFront.ContentReactions.getLikes('<xsl:value-of select="@id"/>', updateContentLikes_<xsl:value-of select="$uniqueId"/>);
                });
            </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>    