<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:math="http://exslt.org/math"
							exclude-result-prefixes="ametys math">

	<xsl:import href="plugin:faq://stylesheets/content/faq/faq-main.xsl"/>	
	
	<xsl:variable name="common-content-css-class-name">faq view-main toggle </xsl:variable>
	
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/faq/scss/main.css')}" />
    </xsl:template>
    
	<xsl:template name="common-content-body-content">
	
		<xsl:if test="not($zone = 'default' and ($template = 'page' or $template = 'full-page'))">
	        <!-- Image -->
	        <xsl:call-template name="common-content-body-image-bigsize">
	            	<xsl:with-param name="maxWidth" select="'720'"/>
	            	<xsl:with-param name="maxHeight" select="'480'"/>
	            </xsl:call-template>    
	    </xsl:if>
    
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
    
        <!-- FAQ -->
        <xsl:call-template name="faq-details"/>
        
        <script>
            $j("#questions-<xsl:value-of select="$uniqueId"/> .question-title button").on('click', function (e) {

                var $header = $j(this).parent();
                if ($header.next('.expandable-element').is(":visible")) {
                    $header.removeClass('open');
                    $header.next('.expandable-element').removeClass('open');
                    $j(this).attr("aria-expanded", false);
                } else {
                    $header.addClass('open');
                    $header.next('.expandable-element').addClass('open');
                    $j(this).attr("aria-expanded", true);
                }

                $j(this).next('.expandable-element').slideToggle();
            });
        </script>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>     
    </xsl:template> 
    
    <xsl:template name="questions-list-title"/>
    <xsl:template name="questions-list"/>
    
    <xsl:template name="questions-list-details">
        <div id="questions-{$uniqueId}">
           <xsl:apply-templates select="metadata/questions/entry[question != '']">
               <xsl:with-param name="prefix" select="concat('content-', @name)"/>
           </xsl:apply-templates>
       </div>
    </xsl:template>
    
     <xsl:template match="entry">
    	<xsl:param name="prefix"/>
    	
            <a name="{$prefix}{@name}{$uniqueId}"/>
            <xsl:call-template name="question-title"/>
            
            <section class="expandable-element" id="faq-panel-{generate-id()}" aria-labelledby="faq-header-{generate-id()}">
	            <xsl:call-template name="question-anwser"/>
	            
	            <xsl:call-template name="question-link"/>
	            
	            <xsl:call-template name="question-additionalinfo"/>
            </section>
    </xsl:template>
    
    <xsl:template name="question-title">
       <h2 class="ametys-richtext-title-4 question-title">
            <button id="faq-header-{generate-id()}"
                    aria-expanded="false"
                    aria-controls="faq-panel-{generate-id()}">
       		    <xsl:value-of select="question"/>
           		<i class="fas fa-plus" aria-hidden="true"></i>
           		<i class="fas fa-minus" aria-hidden="true"></i>
            </button>
       </h2>    
    </xsl:template>
	
</xsl:stylesheet>
