<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver filenameutils">

    <xsl:import href="skin://services/web/pages/services/explorer-folder/files_blocs.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">attachments explorer-folder medium-icons
    	<xsl:if test="ametys:template() != 'index'">ametys-zone-file ametys-zone-file-internal</xsl:if>
    </xsl:variable>
    
    <xsl:variable name="maxLength">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('maxLength') != ''">
                <xsl:value-of select="ametys:serviceViewParameter('maxLength')"/>
            </xsl:when>
            <xsl:otherwise>12<!-- Default value --></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="class-attribute">
        <xsl:if test="ametys:template() != 'index'">
            <xsl:attribute name="class">file-right</xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template name="list-class-attribute">
        <xsl:attribute name="class">file-grid</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']" mode="class-attribute">
        <xsl:attribute name="class">file-grid-item</xsl:attribute>
    </xsl:template>
    
</xsl:stylesheet>
