<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="math ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/user-password/password_3.5.xsl"/>
    <xsl:import href="service:web://pages/services/contenttype/helper/form.xsl"/>
    
    <xsl:template name="common-service-head-css">
    	<link rel="stylesheet" href="{ametys:skinURL('zones/signup/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="strong-password-head-js"/>
        
        <script type="text/javascript">
             $j(function() {
                $j('.user-account.user-password form .field input:not([type=checkbox])').each(function(i, input) {
                    var label = $j(input).closest('.field').find('.label label').text();
                    $j(input).attr('placeholder', label);
                    $j(input).attr('title', label);
                })
             });
        </script>
    </xsl:template>
    
    <!-- Override select population field -->
    <xsl:template name="population-field">
        <xsl:param name="value"/>
        
        <xsl:variable name="countPopulations" select="count(/user-password/UserPopulations/UserPopulation)"/>
        <xsl:choose>
            <xsl:when test="$countPopulations = 1">
                <input type="hidden" id="population-{$uniqueId}" name="population" value="{/user-password/UserPopulations/UserPopulation/@id}"/>
            </xsl:when>
            <xsl:otherwise>
                <div class="field field-select field-select-population">
                    <div class="label">
                        <label for="population-{$uniqueId}">
                            <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION" i18n:catalogue="plugin.web"/>
                            
                            <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                        </label>
                    </div>
                    <div>
                        <xsl:attribute name="class">
                            <xsl:text>input</xsl:text>
                            <xsl:if test="/user-signup/errors/field[@name = 'population']/error"> invalid</xsl:if>
                        </xsl:attribute>
                        
                        <xsl:choose>
                            <xsl:when test="$countPopulations > 0">
                                <select id="population-{$uniqueId}" name="population" style="display: none" >
                                    <xsl:for-each select="/user-password/UserPopulations/UserPopulation">
                                        <option value="{@id}">
                                            <xsl:if test="@id = $value"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                                            <xsl:copy-of select="label"/>
                                        </option>
                                    </xsl:for-each>
                                </select>

                               <div aria-controls="listbox-population-{$uniqueId}"
                                       aria-expanded="false"
                                       aria-haspopup="listbox"
                                       aria-label="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION"
                                       title="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION"
                                       i18n:attr="aria-label title"
                                       id="combobox-population-{$uniqueId}"
                                       role="combobox"
                                       tabindex="0">
                                       
                                   <div id="textbox-population-{$uniqueId}" role="textbox" aria-readonly="true" aria-multiline="false" aria-autocomplete="none" aria-controls="listbox-population-{$uniqueId}"><i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION" i18n:catalogue="plugin.web"/></div>
                              </div>
                              
                              <button class="toggle" aria-hidden="true" aria-label="Toggle list" tabindex="-1" id="toggle-population-{$uniqueId}"></button>
              
                              <div class="select-dropdown monoselect">
                                  <ul class="select-dropdown-list" id="listbox-population-{$uniqueId}" role="listbox" tabindex="-1">
                                        <xsl:for-each select="/user-password/UserPopulations/UserPopulation">
                                            <li class="select-dropdown-item" role="option" aria-selected="false">
                                                <input type="checkbox" id="population-{position()}" value="{@id}" class="sr-only"/>
                                                <label for="population-{position()}"><xsl:copy-of select="label/node()"/></label>
                                            </li>
                                        </xsl:for-each>
                                   </ul>
                               </div>
                               <script>
                                    const $popcbox = $j("#combobox-population-<xsl:value-of select="$uniqueId"/>");
                                    const $lbox = $j("#listbox-population-<xsl:value-of select="$uniqueId"/>");
                                    const $btn = $j("#toggle-population--<xsl:value-of select="$uniqueId"/>");
                                    const $options = $j("#listbox-population-<xsl:value-of select="$uniqueId"/> .select-dropdown-item input");
            
                                    $popcbox.on('click', function(e) {
                                        toggleDropdown($popcbox);
                                        e.stopPropagation();
                                    });
                                    
                                    
                                    $popcbox.on('keydown', function (e) {
                                        switch (e.which) {
                                            case 13:
                                            case 32:
                                                toggleDropdown($popcbox);
                                                if (isOpenDropdown($popcbox)) {
                                                    $lbox.trigger('focus');
                                                }
                                                e.preventDefault();
                                                break;
                                        }
                                        
                                    });
                                  
                                    $btn.on('click', function(e) {
                                        toggleDropdown($popcbox);
                                        $popcbox.trigger('focus');
                                        e.stopPropagation();
                                    })
                                    
                                    $options.on('change', function () {
                                        onSelectOptions(this, <xsl:value-of select="@multiple"/>);
                                        closeDropdown($popcbox);
                                    });
                                    
                                    $j('html').on('keydown', function (e) {
                                        if (e.which == 27 &amp;&amp; isOpenDropdown($popcbox)) {
                                            closeDropdown($popcbox);
                                        } 
                                    });
                                    
                                    $j(document).on('click', function (e) {
                                        if (
                                            $j(e.target).closest(".select-input").length === 0 &amp;&amp;
                                            $j(e.target).closest(".select-dropdown").length === 0
                                        ) {
                                            closeDropdown($popcbox);
                                        }
                                    });
                                    
                                    function toggleDropdown($cbox) {
                                        if (isOpenDropdown($cbox)) {
                                            closeDropdown($cbox);
                                            $cbox.trigger('focus');
                                        } else {
                                            openDropdown($cbox);
                                        }
                                    }
                                    
                                    function isOpenDropdown($cbox) {
                                        return $cbox.attr('aria-expanded') == 'true';
                                    }
                                    
                                    function openDropdown($cbox) {
                                        // close all open combobox
                                        closeDropdown($j('form [role=combobox]'));
                                        
                                        $cbox.attr('aria-expanded', true);
                                        $cbox.siblings(".select-dropdown").show()
                                        $cbox.next().addClass("active");
                                    }
                                    
                                    function closeDropdown($cbox) {
                                        $cbox.attr('aria-expanded', false);
                                        $cbox.siblings(".select-dropdown").hide();
                                        $cbox.next().removeClass("active");
                                    }
                                    
                                    function onSelectOptions(optInput, multiple) {
                                        const $dropdownList = $j(optInput).closest(".select-dropdown");
                                        const $option = $j(optInput).parent();
                                        if ($option.attr('aria-selected') == 'false') {
                                            $option.attr('aria-selected', 'true');
                                        } else {
                                            $option.attr('aria-selected', 'false');
                                        }
                                        const optValue = $j(optInput).val();
                                        const $cbox = $dropdownList.parent().find("[role=combobox]");
                                        const $textbox = $cbox.find("[role=textbox]");
                                        const $input = $dropdownList.parent().find("select");
                                    
                                        if ($j(optInput).is(":checked")) {
                                            // Unselect all other options
                                            $dropdownList.find("input").not(optInput).prop("checked", false);
                                            $textbox.text($j(optInput).next("label").text());
                                            $input.val(optValue);
                                        } else {
                                            // No option selected
                                            $textbox.text($cbox.attr('aria-label'));
                                            $input.val("");
                                        }
                                    }
                                </script>
                            </xsl:when>
                            <xsl:otherwise>
                                <input type="text" id="population-{$uniqueId}" name="population" value="{$value}"/>
                            </xsl:otherwise>
                        </xsl:choose>
                   </div>
            </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- Override to use <button> instead of <input> -->
    <xsl:template name="common-utils-input-submit">
        <xsl:param name="class-name"/>
        <xsl:param name="text"/>
        <xsl:param name="i18nkey"/>
        <xsl:param name="name"/>   
        <xsl:param name="i18ntitle"/>  
        <xsl:param name="title"/>             
        <xsl:param name="id"/>        
        <xsl:param name="onclick"/>        
        <xsl:param name="width"/>        
        <xsl:param name="type">submit</xsl:param>        
        <xsl:param name="disabled" select="false()"/>        
        
        <div class="button">
            <button type="{$type}">
                <xsl:if test="$class-name != ''">
                    <xsl:attribute name="class"><xsl:value-of select="$class-name"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$name != ''">
                    <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$id != ''">
                    <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$onclick">
                    <xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$disabled">
                    <xsl:attribute name="disabled">disabled</xsl:attribute>
                </xsl:if>
                <xsl:if test="$width != ''">
                    <xsl:attribute name="style">width: <xsl:value-of select="$width"/>px;</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="$i18nkey != ''">
                        <i18n:text i18n:key="{substring-after($i18nkey, ':')}" i18n:catalogue="{substring-before($i18nkey, ':')}"/>
                    </xsl:when>
                    <xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise>                
                </xsl:choose>
            </button>
        </div>        
    </xsl:template>        
   
</xsl:stylesheet>
