<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:text="http://ametys.org/text/3.0" 
                              exclude-result-prefixes="docbook resolver ametys"
                              extension-element-prefixes="text">

	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">alert-container view-link</xsl:variable>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body">
        <div class="{$common-content-css-class-name} wrapper">
            <p>
                <strong><xsl:value-of select="metadata/title"/> : </strong>
                <xsl:call-template name="common-utils-simpletext">
                    <xsl:with-param name="text" select="metadata/text"/>                
                    <xsl:with-param name="defaultText" select="metadata/content/docbook:article"/>                
                    <xsl:with-param name="maxDefaultTextSize" select="'150'"/>                
                </xsl:call-template>    
            </p>
            
            <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
            <xsl:if test="$page-id != ''">
                <p class="content-read-more">
                    <a href="{resolver:resolve('page', $page-id, false)}" class="url"><i18n:text i18n:key="SKIN_ALERT_READMORE" i18n:catalogue="skin.{$skin}"/></a>
                </p>
            </xsl:if> 
        </div>            
    </xsl:template>
    
	
</xsl:stylesheet>