<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
        
    <xsl:template name="sorts">
        <xsl:param name="mobile" select="false()"/>
        
        <xsl:if test="count(/search/form/sorts/sort) > 0">
            <div class="results-header-filter">
                <xsl:if test="$mobile"><xsl:attribute name="class">results-header-filter results-header-filter-mobile</xsl:attribute></xsl:if>
                <label for="sort-field_{$uniqueId}"><i18n:text i18n:key="PLUGINS_WEB_SERVICE_SEARCH_VIEW_SORT_BY" i18n:catalogue="plugin.web"/></label>
             	<xsl:call-template name="sorts-list"/>
                <xsl:call-template name="current-sort"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="current-sort">
        <!-- Hidden inputs with current sort(s), required to keep sort when selecting a facet or pagination -->
        <xsl:for-each select="/search/form/sorts/sort[@selected]">
            <xsl:call-template name="sort-hidden-input-for-selected"/>
        </xsl:for-each>
    </xsl:template>
    
     <xsl:template name="sorts-list">
        <div class="results-header-select">
            <select name="sort" id="sort-field_{$uniqueId}">
                <xsl:attribute name="onchange">eval("function a(){" + this.options[this.selectedIndex].getAttribute('onselect') + "}"); try { a.call(this); } catch(e) { }; return true;</xsl:attribute>
                <xsl:for-each select="/search/form/sorts/sort">
                    <xsl:call-template name="sort-element"/>
                </xsl:for-each>
            </select>
        </div>
    </xsl:template>
    
    <xsl:template name="sort-element">
        <option value="{@name}">
            <xsl:attribute name="onselect"><xsl:call-template name="search-js-sort"/></xsl:attribute>
            <xsl:if test="@selected"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
            <xsl:value-of select="label"/>
        </option>
    </xsl:template>
    
</xsl:stylesheet>