<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							exclude-result-prefixes="ametys">
							
	<xsl:import href="plugin:myfavorites://stylesheets/content/myfavorites/myfavorites-main.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">ametys-zone-video</xsl:variable>
	
	<xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:if test="(ametys:template() = 'index') or (ametys:zone('default') != 'default')">
			<div class="flex-right">
		        <h1 class="content-title">
		        	<xsl:value-of select="$title"/>
		        	<xsl:if test="ametys:template() != 'index'">
			            <xsl:if test="$subtitle != ''">
			                <span class="content-subtitle"><xsl:value-of select="$subtitle"/></span>
			            </xsl:if>
		            </xsl:if>
		        </h1>
		        <xsl:if test="ametys:template() = 'index'">
					<xsl:variable name="all_videos_page" select="ametys:findPagesIdsByTag('ALL_VIDEOS')"/>
					<xsl:if test="$all_videos_page">
						<a href="{resolver:resolve('page', $all_videos_page/@id)}" class="btn" target="_blank">
			                <i class="fas fa-arrow-right" aria-hidden="true"></i>
			                <i18n:text i18n:key="SKIN_BO_TAG_ALL_VIDEOS_LABEL" i18n:catalogue="skin.{$skin}"/>
			            </a>
		            </xsl:if>
		        </xsl:if>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="entries"> 
        <xsl:if test="metadata/link/entry[url != '']">
            <ul class="video-list">
                <xsl:apply-templates select="metadata/link/entry[url != '']"/>
            </ul>
        </xsl:if>
	</xsl:template>
	
	<xsl:template match="entry"> 
		<li class="video-list-item">
			<a onclick="window.open(this.href); return false;" href="{url}" title="{link-title}" class="label">
			<xsl:apply-templates select="." mode="link-title"/>
			<div class="video">
               <xsl:if test="link-illustration/link-image">
		            <img src="{resolver:resolveBoundedImage(link-illustration/link-image/@type, link-illustration/link-image/@path, 500, 500)}" alt="{link-illustration/link-alt-text}" class="thumbnail"/>
		        </xsl:if>
               <div class="play-button">
                   <span class="fas fa-play" aria-hidden="true"></span>
               </div>
           </div>
           
			<div class="title">
                 <span><xsl:value-of select="label"/></span>
			</div>
           
            </a>
		</li>
	</xsl:template>
    
    <xsl:template match="entry" mode="link-title"> 
        <xsl:attribute name="title">
        <xsl:choose>
            <xsl:when test="link-title != ''">
                <xsl:value-of select="link-title"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="i18nparams"><label><xsl:value-of select="label"/></label></xsl:variable> 
                <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_CONTENT_FAVORITES_VIDEO_LINK_TITLE'), $lang, $i18nparams)"/>
            </xsl:otherwise>
        </xsl:choose>
        </xsl:attribute>
    </xsl:template>

</xsl:stylesheet>
