<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

	<xsl:import href="wa://tracking" />
    <xsl:import href="plugin:rocket.chat?://stylesheets/rocket.chat.xsl" />
    
	<!-- + 
	     | HEAD
	     + -->
	<xsl:template name="head">
		<head>
			<meta http-equiv="X-UA-Compatible" content="IE=edge" />
			<title><xsl:call-template name="get-title"/></title>
			
			<meta name="viewport" content="width=device-width, initial-scale=1" />

			<xsl:call-template name="meta" />
			<xsl:call-template name="og-meta" />
               
               <xsl:call-template name="head-translations"/>

			<xsl:call-template name="common-css" />
			<xsl:call-template name="additionnal-css" />
			
			<xsl:if test="$rendering-context = 'back'">
				<style type="text/css">
					.ametys-cms-zone-item-grabber{ z-index: 10; }
				</style>
			</xsl:if>

			<xsl:call-template name="common-rss" />
			<xsl:call-template name="additionnal-rss" />

			<xsl:call-template name="common-script" />
			<xsl:call-template name="additionnal-script" />
			
            <!-- Search  -->
            <xsl:call-template name="search-head"/>
            
            <xsl:call-template name="web-tracking"/>
   		</head>
	</xsl:template>
	
	<xsl:template name="get-title">
		<xsl:choose>
			<xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
			<xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
		</xsl:choose>
		<i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/>
	</xsl:template>
	
	<!-- + 
	     | META
	     + -->
	<xsl:template name="meta">
		<meta name="author" content="Ametys V4" />
		<meta name="copyright" content="Ametys V4" />
		<meta name="language" content="{$lang}" />
		<meta name="revisit-after" content="15 days" />
	 	
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.subject']">
    	 	<meta name="subject" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.subject']/@content}"/>
    	</xsl:if>
	 	
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.description']">
    		<meta name="description" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.description']/@content}"/>
    	</xsl:if>
        
        <!-- Copy Dublin Core metadata. -->
        <xsl:copy-of select="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[starts-with(@name, 'DC.')]"/>
	</xsl:template>
	
	<!-- + 
         | OPEN GRAPH META
         + -->
	<xsl:template name="og-meta">
		<xsl:comment>
			<xsl:for-each select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type = 'CONTENT'][1]/html/head">
					<meta property="og:title" content="{meta[@name = 'DC.title']/@content}" />
					<xsl:if test="meta[@name = 'DC.description']">
						<meta property="og:description" content="{meta[@name = 'DC.description']/@content}" />
					</xsl:if>
					<xsl:if test="meta[@name = 'DC.type']">
						<meta property="og:type" content="{meta[@name = 'DC.type']/@content}" />
					</xsl:if>
			</xsl:for-each>
		</xsl:comment>
	</xsl:template>
	
	<!-- + 
         | COMMON CSS
         + -->
    <xsl:template name="head-css-jquery">
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('plugins/css/jquery-ui.css')}" type="text/css" />
    </xsl:template>         
    
	<xsl:template name="common-css">
		<link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/font/material-design-icons/material-icons.css')}" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/font/intranet/IntranetIcon.css')}" type="text/css" />

		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_internal.css')}" />
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
    	
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/styles.css')}" />
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_access.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/cookiebanner.css')}"/>
		
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/secondary-menu/scss/main.css')}"/>
        
        <!-- BEGIN styles for link directory config feature -->
        <link rel="stylesheet" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />
        <link rel="stylesheet" href="{ametys:skinURL('plugins/custombox/custombox.min.css')}" />
        <!-- END styles for link directory config feature -->
        
        <xsl:call-template name="head-css-fancybox"/>
        
        <xsl:call-template name="rocket.chat-css">
            <xsl:with-param name="only-dependencies" select="true()"/>
        </xsl:call-template>

        <xsl:call-template name="custom-css"/>
	</xsl:template>
    
    <!-- + 
         | CUSTOM CSS / ADDITIONAL FONTS
         + -->
    <xsl:template name="custom-css">
        <!-- Insert your custom css here (ex: additional fonts )-->
    </xsl:template>

	<!-- + 
         | ADDITIONNAL CSS
         + -->
	<xsl:template name="additionnal-css"/>


	<!-- + 
         | COMMON RSS
         + -->
	<xsl:template name="common-rss">
<!-- 		<link rel="alternate" type="application/rss+xml" i18n:attr="title" title="skin.{$skin}:SKIN_RSSEVENTS_ALT" href="{$site-uri-prefix}/_plugins/web/{$site}/{$lang}/filter/events/rss.xml"/> -->
<!-- 		<link rel="alternate" type="application/rss+xml" i18n:attr="title" title="skin.{$skin}:SKIN_RSSARTICLE_ALT" href="{$site-uri-prefix}/_plugins/web/{$site}/{$lang}/filter/org.ametys.web.article.RSS/rss.xml"/> -->
	</xsl:template>

	<!-- + 
         | ADDITIONNAL RSS
         + -->
	<xsl:template name="additionnal-rss"/>
		
	<!-- + 
         | COMMON SCRIPT
         + -->
	<xsl:template name="common-script">
        <xsl:call-template name="link-dynamic-info-js">
            <xsl:with-param name="themes" select="/cms/inputData/linkDirectory/themes"/>
            <xsl:with-param name="uniqueId" select="concat('profile_link_', $uniqueId)"/>
        </xsl:call-template>
        <xsl:call-template name="link-dynamic-info-js">
            <xsl:with-param name="themes" select="/cms/inputData/linkDirectory/themes"/>
            <xsl:with-param name="uniqueId" select="concat('header_link_', $uniqueId)"/>
        </xsl:call-template>
        <script type="text/javascript" src="{ametys:pluginResourceURL('front-notification', 'js/FlashInfo.js')}"></script>
		<script type="text/javascript" src="{ametys:skinURL('templates/common/js/script-export.js')}"></script>
        
        <!-- jQuery migrate 3.5.2 -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/jquery-migrate-3.5.2.js')}"></script>
        
        <!-- Scripts for links directory -->
        <script src="{ametys:skinURL(concat('templates/common/js/ametys-tools.', $lang, '.js'))}"></script>
        <script src="{ametys:pluginResourceURL('link-directory', 'js/LinkDirectoryHelper.js')}" type="text/javascript"></script>
        <script src="{ametys:skinURL('plugins/web-animations-js/web-animations.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/hammerjs/hammer.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/muuri/dist/muuri.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/custombox/custombox.min.js')}"></script>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/js/svgconvert.js')}" />
        
        <xsl:call-template name="rocket.chat-scripts"/>
        
        <xsl:call-template name="head-js-fancybox"/>
        
        <xsl:call-template name="head-js-subscriptions"/>
        <xsl:call-template name="head-js-matomo"/>
        
        <xsl:call-template name="custom-script"/>
	</xsl:template>
    
    <!-- JS to follow page button and subscriptions notifications -->
    <xsl:template name="head-js-subscriptions">
        <xsl:if test="$pageFollowEnabled = 'true'">
           <script type="text/javascript" src="{$uri-prefix}/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.{ametys:lang()}.js"/>
        </xsl:if>
        <xsl:if test="$notificationCenterEnabled = 'true'">
            <script type="text/javascript" src="{$uri-prefix}/plugins/page-subscription/resources/js/AmetysFront/UserNotifications.{ametys:lang()}.js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="head-js-matomo">
        <script src="{ametys:pluginResourceURL('web-analytics', 'js/AmetysMatomoHelper.js')}" type="text/javascript"/>
        <script src="{ametys:skinURL('plugins/js/popper.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}"></script>
    </xsl:template>
    
    <!-- + 
         | CUSTOM SCRIPTS
         + -->
    <xsl:template name="custom-script">
        <!-- Insert your custom scripts here-->
    </xsl:template>

	<!-- + 
         | ADDITIONNAL SCRIPT
         + -->
	<xsl:template name="additionnal-script">
	</xsl:template>
	
    <xsl:template name="favico">
        <xsl:choose>
            <xsl:when test="ametys:skinResources('templates/common/img/favicon/favicon.ico')">
                <link rel="icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
                <link rel="shortcut icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
            </xsl:when>
            <xsl:otherwise>
                <link rel="icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
            </xsl:otherwise>
        </xsl:choose>
        <meta name="msapplication-config" content="{ametys:skinURL('templates/common/img/favicon/browserconfig.xml')}" /> 
        <meta name="theme-color" content="#ffffff" /> 
    </xsl:template>
    
	<xsl:template name="head-meta-top">
		<meta content="IE=edge" http-equiv="X-UA-Compatible" />
    </xsl:template>	
    
    <xsl:template name="head-translations">
        <xsl:for-each select="/cms/page/metadata/translations/*">
            <link rel="alternate" href="{resolver:resolve('page', .)}" hreflang="{local-name()}" />
        </xsl:for-each>
    </xsl:template> 	
    
    <xsl:template name="head-css-fancybox">
        <link rel="stylesheet" href="{ametys:skinURL('plugins/fancybox/jquery.fancybox.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-js-fancybox">
        <script src="{ametys:skinURL('plugins/fancybox/jquery.fancybox.js')}"></script>
        <script type="text/javascript">
          $j(function () {
            $j('.js-fancybox').fancybox();
          });
        </script>
    </xsl:template>
</xsl:stylesheet>
