<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:math="java.lang.Math" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:str="http://exslt.org/strings"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
    xmlns:exslt="http://exslt.org/common"
    xmlns:uriutils="org.ametys.core.util.URIUtils"
    xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
    exclude-result-prefixes="xalan math str ametys user resolver stringutils sitemap filenameutils">  
    
    <xsl:import href="plugin:web://stylesheets/utils.xsl"/>
    
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    <xsl:variable name="site" select="ametys:site()"/>
    
    <xsl:variable name="openNewWindowSuffix" select="ametys:translate(concat('skin.', $skin, ':SKIN_LINK_OPEN_NEW_WINDOW_SUFFIX'), $lang)"></xsl:variable>
    
    <xsl:template name="user-info">
        <xsl:param name="login" select="ametys:user()/user/@login"/>                         <!-- user's login -->
        <xsl:param name="population" select="ametys:user()/user/@population"/>               <!-- user's population id -->
        <xsl:param name="userIdentity"/>                                                     <!-- user's identity as login#populationId -->
        <xsl:param name="imgWidth">60</xsl:param>                                            <!-- dimension of user's avatar -->
        
        <xsl:variable name="fUserIdentity">
            <xsl:choose>
                <xsl:when test="$userIdentity != ''"><xsl:text/><xsl:value-of select="$userIdentity"/></xsl:when>
                <xsl:otherwise><xsl:text/><xsl:value-of select="concat($login, '#', $population)"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="userContentId" select="user:getUserContent($lang, $fUserIdentity)"/>
        <xsl:variable name="userPageId" select="user:getUserPage($userContentId)"/>
        <xsl:variable name="ametysUser" select="ametys:user($fUserIdentity)"/>
         
        <user> 
            <login><xsl:value-of select="$ametysUser/user/@login"/></login>
            <population><xsl:value-of select="$ametysUser/user/@population"/></population>
            <contentId><xsl:value-of select="$userContentId"/></contentId>
            <imgUrl><xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', ametys:user()/user/@population, '/', uriutils:encodePath(ametys:user()/user/@login), '/image_', $imgWidth, '?lang=', $lang)"/></imgUrl>
            
            <xsl:choose>
                <xsl:when test="$userContentId != ''">
                   <xsl:variable name="firstname" select="ametys:contentAttribute($userContentId, 'firstname')"/>
                   <xsl:variable name="lastname" select="ametys:contentAttribute($userContentId, 'lastname')"/>
                   <firstname><xsl:value-of select="$firstname"/></firstname>
                   <lastname><xsl:value-of select="$lastname"/></lastname>
                   <fullname><xsl:value-of select="$firstname"/><xsl:if test="$firstname != ''"><xsl:text> </xsl:text></xsl:if><xsl:value-of select="$lastname"/></fullname>
                   <email><xsl:value-of select="ametys:contentAttribute($userContentId, 'email')"/></email>
                   <role><xsl:value-of select="ametys:contentAttribute($userContentId, 'function')"/></role>
                   <contentId><xsl:value-of select="$userContentId"/></contentId>
                </xsl:when>
                <xsl:when test="$ametysUser/user/fullname != ''">
                    <firstname><xsl:value-of select="$ametysUser/user/firstname"/></firstname>
                    <lastname><xsl:value-of select="$ametysUser/user/lastname"/></lastname>
                    <fullname><xsl:value-of select="$ametysUser/user/fullname"/></fullname>
                    <email><xsl:value-of select="$ametysUser/user/email"/></email>
                </xsl:when>
                <xsl:otherwise>
                    <fullname><xsl:value-of select="ametys:translate(concat('skin.', $skin, ':UNKNOWN_USER'))"/></fullname>
                </xsl:otherwise>
            </xsl:choose>
            <pageId><xsl:value-of select="$userPageId"/></pageId>
        </user>
    </xsl:template>
    
    <xsl:template name="user-profile-image">
        <xsl:param name="size">45</xsl:param>
        <xsl:param name="login"/>
        <xsl:param name="population"/>
        <xsl:param name="lang" select="ametys:lang()"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="url">
            <xsl:call-template name="user-profile-image-url">
                <xsl:with-param name="size" select="$size"/>
                <xsl:with-param name="login" select="$login"/>
                <xsl:with-param name="population" select="$population"/>
                <xsl:with-param name="lang" select="$lang"/>
            </xsl:call-template>
        </xsl:variable>
        <img src="{$url}" alt="">
            <xsl:if test="$class != ''">
                <xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
            </xsl:if>
        </img>
    </xsl:template>
    
    <xsl:template name="user-profile-image-url">
        <xsl:param name="size">45</xsl:param>
        <xsl:param name="login"/>
        <xsl:param name="population"/>
        <xsl:param name="lang" select="ametys:lang()"/>

        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', $population, '/', uriutils:encodePath($login), '/image_', $size, '?lang=', $lang)"/>        
    </xsl:template>
    
    <!-- Templates for attributes to add on external links -->
    <xsl:template name="external-link-attributes">
        <xsl:param name="title" select="@sitemap:title"/>
        <xsl:param name="className">external</xsl:param>
        
        <xsl:attribute name="target">_blank</xsl:attribute>
        <xsl:attribute name="class"><xsl:value-of select="$className"/></xsl:attribute>
        <xsl:attribute name="title"><xsl:value-of select="concat($title, $openNewWindowSuffix)"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="get-content-tags">
        <xsl:param name="tags" select="tags/*"/>
        
        <xsl:for-each select="$tags">
            <xsl:variable name="tagId" select="local-name()"/>
            <xsl:variable name="tagPath" select="ametys:tagPath($site, $tagId)"/>
            <xsl:variable name="tagColor" select="ametys:tagColor($site, $tagId)"/>
            
            <xsl:if test="contains($tagPath, 'THEMES')">
                <tag bgColor="{$tagColor/main}" textColor="{$tagColor/text}"><xsl:value-of select="." /></tag>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
     <xsl:template name="file-icon">
        <xsl:param name="filename" select="@name"/>
        <xsl:param name="ext" select="filenameutils:getExtension($filename)"/>
        
        <span aria-hidden="true">
            <xsl:attribute name="class"><xsl:text>icon fas fa-</xsl:text>
                <xsl:choose>
                    <xsl:when test="$ext = 'doc' or $ext = 'docx' or $ext = 'dot'">file-word</xsl:when>
                    <xsl:when test="$ext = 'avi' or $ext = 'flv' or $ext = 'mov' or $ext = 'mpeg' or $ext = 'mgp' or $ext = 'swf' or $ext = 'wmv'">file-video</xsl:when>
                    <xsl:when test="$ext = 'bmp' or $ext = 'gif' or $ext = 'jpeg' or $ext = 'jpg' or $ext = 'png' or $ext = 'psd' or $ext = 'psp'">file-image</xsl:when>
                    <xsl:when test="$ext = 'pdf'">file-pdf</xsl:when>
                    <xsl:when test="$ext = 'pps' or $ext = 'ppsx' or $ext = 'ppt' or $ext = 'pptx'">file-powerpoint</xsl:when>
                    <xsl:when test="$ext = 'mid' or $ext = 'mod' or $ext = 'mp3'">file-audio</xsl:when>
                    <xsl:when test="$ext = 'xls' or $ext = 'xlsx'">file-excel</xsl:when>
                    <xsl:when test="$ext = 'css' or $ext = 'wml' or $ext = 'xsl' or $ext = 'htm' or $ext = 'html' or $ext = 'xhtml'">code</xsl:when>
                    <xsl:when test="$ext = 'tar' or $ext = 'rar' or $ext = 'zip' or $ext = 'tgz' or $ext = 'jar'">archive</xsl:when>
                    <xsl:when test="$ext = 'txt' or $ext = 'odp' or $ext = 'ods' or $ext = 'odt' or $ext = 'sxi' or $ext = 'sxw'">file-alt</xsl:when>
                    <xsl:when test="$ext = 'cvs' or $ext = 'sh' or $ext = 'unknown' or $ext = 'tgz' or $ext = 'jar'">file</xsl:when>
                    <xsl:otherwise>file</xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
        </span>
    </xsl:template>
</xsl:stylesheet>    