<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:template name="hits">
        <div class="results">
            <ul data-ametys-search-role="hits" class="search-container masonry">
                <xsl:for-each select="/search/hits/hit">
                    <xsl:call-template name="hit"/>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <li>
            <xsl:apply-templates select="."/>
        </li>
    </xsl:template>
    
    <!-- Override rendering for resource hits -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']">
        <div>
            <xsl:apply-templates select="." mode="class-attribute"/>
            <a class="item actu-item with-icon">
                <xsl:attribute name="href"><xsl:call-template name="hit-resource-title-link-href"/></xsl:attribute>
                
                <div class="content">
                    <xsl:apply-templates select="." mode="icon"/>
                    <xsl:apply-templates select="." mode="title"/>
                    <xsl:apply-templates select="." mode="abstract"/>
                </div>
                
            </a>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="class-attribute">
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="icon">
        <xsl:call-template name="file-icon">
            <xsl:with-param name="filename" select="filename"></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="title">
        <h3 class="item-title actu-item-title">
            <xsl:value-of select="filename"/>
        </h3>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="abstract">
        <xsl:variable name="truncatedText">
            <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="defaultText" select="excerpt"/>                
                <xsl:with-param name="maxDefaultTextSize" select="'100'"/>                
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="normalize-space($truncatedText) != ''">
            <p class="content-abstract">
                <xsl:copy-of select="$truncatedText"/>           
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="date">
        <div class="date-container">
            <!-- <xsl:call-template name="dates">
                <xsl:with-param name="startDate" select="lastModified"/>
            </xsl:call-template> -->
        </div>
    </xsl:template>
    <!-- // End resource hits -->
    
    <!-- Override rendering for page hits -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']">
        <div>
            <xsl:apply-templates select="." mode="class-attribute"/>
            <a class="item actu-item with-icon">
                <xsl:attribute name="href"><xsl:call-template name="hit-page-title-href"/></xsl:attribute>
                
                <div class="content">
                    <xsl:apply-templates select="." mode="title"/>
                    <xsl:apply-templates select="." mode="abstract"/>
                </div>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="class-attribute">
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="title">
        <h3 class="item-title actu-item-title">
            <xsl:value-of select="title"/>
        </h3>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="abstract">
        <xsl:variable name="truncatedText">
            <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="defaultText" select="excerpt"/>                
                <xsl:with-param name="maxDefaultTextSize" select="'100'"/>                
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="normalize-space($truncatedText) != ''">
            <p class="content-abstract">
                <xsl:copy-of select="$truncatedText"/>           
            </p>
        </xsl:if>
    </xsl:template>
    <!-- // End page hits -->
    
    <xsl:template name="hit-attributes"/>
</xsl:stylesheet>
