<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://templates/page/stylesheets/template.xsl" />
	
    <xsl:template name="main-content">
        <xsl:if test="not($deactivateFOEditionToolbar = 'true')">
            <xsl:call-template name="fo-toolbar"/>
    	</xsl:if>
        
        <div>
            <xsl:call-template name="default-zone"/>
        </div>
    </xsl:template>
    
    <xsl:template name="fo-toolbar">
        <xsl:call-template name="ametys-front-edition-page-toolbar">
	        <xsl:with-param name="items">['edition-mode', 'add-content', 'add-page', {type: 'menu', label: "<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_MENU_LABEL"  i18n:catalogue="plugin.front-edition"/>", items: [ 'tag', 'rename', 'move', 'schedule-publication', 'delete']}]</xsl:with-param>
            <xsl:with-param name="add-contents-config">
                [
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_ARTICLE" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-newspaper", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_NEWS" i18n:catalogue="skin.{$skin}"/>"}                
                ]
            </xsl:with-param>
            <xsl:with-param name="add-page-config">{                 
               "default-pagetype" : "template",                 
               "default-template" : "page",                 
               "default-pagecontent-type" : "contenttype",   
               "pagetype-card-template-filter": ["page", "full-page"]       
               }</xsl:with-param> 
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="right"/>
	
</xsl:stylesheet>