<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver">

    <xsl:import href="plugin:classified-ads://stylesheets/content/ads/ads-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
	
    <xsl:variable name="wrapperContentCssClass"></xsl:variable>
    
    <xsl:template name="content">
    	<div class="picture">
        	<xsl:choose>
            	<xsl:when test="metadata/illustrations/image1">
    		        	<!-- Image -->
    		        	<xsl:call-template name="common-content-body-image">
    		        		<xsl:with-param name="maxWidth" select="'250'"/>
            				<xsl:with-param name="maxHeight" select="'145'"/>
    		        		<xsl:with-param name="image" select="metadata/illustrations/image1"/>
    		        		<xsl:with-param name="alternative" select="metadata/illustrations/image1/alt-text"/>
                            <xsl:with-param name="type">cropped</xsl:with-param>
    		        	</xsl:call-template>
            	</xsl:when>
            	<xsl:when test="metadata/illustration/image2">
    		        	<!-- Image -->
    		        	<xsl:call-template name="common-content-body-image">
    		        		<xsl:with-param name="maxWidth" select="'250'"/>
            				<xsl:with-param name="maxHeight" select="'145'"/>
    		        		<xsl:with-param name="image" select="metadata/illustrations/image2"/>
                            <xsl:with-param name="alternative" select="metadata/illustrations/image2/alt-text"/>
                            <xsl:with-param name="type">cropped</xsl:with-param>
    		        	</xsl:call-template>
            	</xsl:when>
                <xsl:otherwise>
                    <!-- TODO default image -->
                </xsl:otherwise>
            </xsl:choose>
            <div class="etiquette">
                <xsl:value-of select="metadata/category/@title"/>
            </div>
        </div>
        
        <div class="info">
        	<div class="tag"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd MMMM" value="{@createdAt}"/></div>
        	<div class="descri">
        	<xsl:value-of select="metadata/title"/>
        	</div>
        	<xsl:if test="metadata/price">
				<div class="price">
                    <i class="fas fa-arrow-right" aria-hidden="true"></i>
                    <span><xsl:value-of select="metadata/price"/> €</span>
                </div>
        	</xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <img alt="{$alternative}">
                <xsl:attribute name="src">
                 <xsl:choose>
                     <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                     <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                 </xsl:choose>
                </xsl:attribute>
            </img>
        </xsl:if>        
    </xsl:template>  
    
    <xsl:template name="get-page-id">
        <xsl:value-of select="ugc:getUgcPage(//content/@id)"/>
    </xsl:template>
    
</xsl:stylesheet>