<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	xmlns:math="java.lang.Math"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	extension-element-prefixes="ametys math sitemap resolver">

	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>

    <!-- +
         | Name of global search text field :
         | * use "user.input.criterion.common$wording$textfield$1" if global search service if configured with "Full text" criteria (in first place)
         | * use "user.input.criterion.common$titleorwording$textfield$1" if global search service if configured with "Title or full text" criteria (in first place)
         + -->
    <xsl:variable name="searchInputName">user.input.criterion.common$titleorwording$textfield$1</xsl:variable>
    
    <xsl:template name="search-head">
		<xsl:call-template name="search-keywords-highlight"/>
	</xsl:template>

    <xsl:template name="search-placeholder">
		<script type="text/javascript" src="{ametys:skinURL('js/jquery.placeholder.min.js')}"></script>
		<script type="text/javascript">
			$j(function() { $j("#search-field-<xsl:value-of select="$uniqueId"/>").placeholder(); });
		</script>
	</xsl:template>
	
	<!-- autocomplete removed -->
	    
    <xsl:template name="search">
    	<xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]">
            <xsl:if test="ametys:renderingContext() = 'back'"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>
				<form class="search-input" action="{resolver:resolve('page', /cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]/@sitemap:id)}" method="post">
                    <label for="search-field-{$uniqueId}" class="sr-only">
                    	<i18n:text i18n:key="SKIN_MAIN_SEARCH" i18n:catalogue="skin.{$skin}"/>
                    </label>
                    <input type="text" class="input-text" placeholder="skin.{$skin}:SKIN_MAIN_SEARCH" name="{$searchInputName}" id="search-field-{$uniqueId}" title="skin.{$skin}:SKIN_MAIN_SEARCH" i18n:attr="title placeholder"/>
		    		<input type="hidden" name="submit-form" />
                    
                    <button type="button" aria-label="skin.{$skin}:SKIN_SEARCH_CLOSE" i18n:attr="aria-label" class="close-search-input-in-input" onclick="closeSearchInput()">
                        <i aria-hidden="true" class="fas fa-times"></i>
                    </button>
		    	</form>
	    </xsl:if>
    </xsl:template>
        
    <xsl:template name="search-button">
    	<xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]">
    		<li class="open-search-input" role="search" aria-label="skin.{$skin}:SKIN_MAIN_SEARCH_LABEL" i18n:attr="aria-label">
                <a name="search"></a>
    			<button aria-expanded="false" aria-label="skin.{$skin}:SKIN_SEARCH_OPEN" i18n:attr="aria-label" onclick="openSearchInput()">
    				<xsl:call-template name="search-open-icon"/>
				</button>
                
                <xsl:call-template name="search"/>
			</li>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="search-open-icon">
		<svg aria-hidden="true" viewBox="0 0 20 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
			<title><i18n:text i18n:key="SKIN_SEARCH_LABEL" i18n:catalogue="skin.{$skin}"/></title>
			<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
				<g id="Univ-Tours-home" transform="translate(-1167.000000, -36.000000)" fill="#206782" fill-rule="nonzero">
					<g id="Univ-tours-home" transform="translate(-64.000000, -307.003750)">
						<g id="top-header" transform="translate(61.000000, 207.936760)">
							<g id="icons" transform="translate(1170.000000, 128.066990)">
								<g id="icon-search" transform="translate(0.000000, 7.500042)">
									<path d="M19.7265155,17.2929351 L15.8319859,13.3984056 C15.656205,13.2226247 15.4179396,13.1249687 15.167925,13.1249687 L14.5312154,13.1249687 C15.6093225,11.7460734 16.2499613,10.0116873 16.2499613,8.12498063 C16.2499613,3.63669482 12.6132664,0 8.12498063,0 C3.63669482,0 0,3.63669482 0,8.12498063 C0,12.6132664 3.63669482,16.2499613 8.12498063,16.2499613 C10.0116873,16.2499613 11.7460734,15.6093225 13.1249687,14.5312154 L13.1249687,15.167925 C13.1249687,15.4179396 13.2226247,15.656205 13.3984056,15.8319859 L17.2929351,19.7265155 C17.6600989,20.0937174 18.2538551,20.0937174 18.6171279,19.7265155 L19.7226245,18.621057 C20.0897882,18.2538551 20.0897882,17.6600989 19.7265155,17.2929351 Z M8.12498063,13.1249687 C5.36326083,13.1249687 3.12499255,10.8905914 3.12499255,8.12498063 C3.12499255,5.36326083 5.35936985,3.12499255 8.12498063,3.12499255 C10.8867004,3.12499255 13.1249687,5.35936985 13.1249687,8.12498063 C13.1249687,10.8867004 10.8905914,13.1249687 8.12498063,13.1249687 Z"></path>
								</g>
							</g>
						</g>
					</g>
				</g>
			</g>
		</svg>
	</xsl:template>
	
    <xsl:template name="search-keywords-highlight">
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/jquery.mark.js')}"></script>
        <script type="text/javascript">
            $j(function()
            {
                // Extract the keywords from the URL
                var hlRegexp = new RegExp('[\?\&amp;]search-keywords=([^\?\&amp;#;]+)', 'i');
                var result = hlRegexp.exec(location.search);
                if (result != null &amp;&amp; result.length &gt; 1)
                {
                    var keywords = result[1].split('+');
                    for (var x = 0; x &lt; keywords.length; x++)
                    {
                        if (keywords[x] != '')
                        {
                            <xsl:for-each select="/cms/template-information/template/zone">
                                $j('#ametys-cms-zone-<xsl:value-of select="@id"/>').mark($j.trim(decodeURIComponent(keywords[x])));
                            </xsl:for-each> 
                        }
                    }
                }
            });
        </script>
    </xsl:template> 
    
</xsl:stylesheet>
