<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              extension-element-prefixes="cms" 
                              exclude-result-prefixes="docbook resolver">
                              
    <xsl:import href="view://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <a href="{resolver:resolve(concat(metadata/file/@type, '-flipbook'), metadata/file/@path)}" title="{metadata/file/@filename}" target="_blank">
            <xsl:if test="$rendering-context = 'back'">
                <xsl:attribute name="internal">internal</xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="filename">
                <xsl:choose>
                    <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="i18nparams"><filename><xsl:value-of select="$filename"/></filename></xsl:variable> 
            <xsl:attribute name="title">
                <xsl:value-of select="ametys:translate('plugin.flipbook:CONTENT_PDF_DOCUMENT_BOOK_TITLE', $lang, $i18nparams)"/>
            </xsl:attribute>
                    
            <xsl:call-template name="pdf-preview"/>
            <xsl:call-template name="preview-icon"/>
        </a>
    </xsl:template>
    
    <xsl:template name="pdf-preview">
        <xsl:param name="previewHeight">204</xsl:param>
        <xsl:param name="previewWidth">144</xsl:param>
        <img src="{resolver:resolveBoundedImage(concat(metadata/file/@type, '-flipbook'), metadata/file/@path, $previewHeight, $previewWidth)}">
            <xsl:attribute name="alt">
                <xsl:choose>
                    <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
        </img>
    </xsl:template>
    
    <xsl:template name="preview-icon">
        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 431.67">
            <g id="Calque_2" data-name="Calque 2">
                <g id="Layer_1" data-name="Layer 1">
                    <path
                        d="M497,96.4H447.73V15A15,15,0,0,0,426,1.58l-170,85L86,1.58A15,15,0,0,0,64.27,15V96.4H15a15,15,0,0,0-15,15V416.67a15,15,0,0,0,15,15H497a15,15,0,0,0,15-15V111.4a15,15,0,0,0-15-15ZM30,401.67V126.4H64.27V328.3a15,15,0,0,0,8.29,13.42l119.9,59.95Zm211-9.27L94.27,319V39.27L241,112.64Zm30-279.76L417.73,39.27V319L271,392.4Zm211,289H319.54l119.9-59.95a15,15,0,0,0,8.29-13.42V126.4H482Z" />
                    <path
                        d="M136.82,138.88,185,163a15,15,0,0,0,13.42-26.84L150.24,112a15,15,0,0,0-13.42,26.84Z" />
                    <path
                        d="M136.82,217.2,185,241.3a15,15,0,1,0,13.42-26.83l-48.2-24.1a15,15,0,0,0-13.42,26.83Z" />
                    <path
                        d="M136.82,295.53l48.2,24.1a15,15,0,1,0,13.42-26.84l-48.2-24.1a15,15,0,0,0-13.42,26.84Z" />
                    <path
                        d="M361.76,112l-48.2,24.1A15,15,0,0,0,327,163l48.2-24.1A15,15,0,0,0,361.76,112Z" />
                    <path
                        d="M361.76,190.37l-48.2,24.1A15,15,0,1,0,327,241.3l48.2-24.1a15,15,0,0,0-13.42-26.83Z" />
                    <path
                        d="M361.76,268.69l-48.2,24.1A15,15,0,1,0,327,319.63l48.2-24.1a15,15,0,0,0-13.42-26.84Z" />
                </g>
            </g>
        </svg>    
    </xsl:template>
</xsl:stylesheet>